/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.FacadeLoader;
import net.jqwik.api.Shrinkable;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="1.0")
public interface RandomGenerator<T> {
    public Shrinkable<T> next(Random var1);

    @API(status=API.Status.INTERNAL)
    default public <U> RandomGenerator<U> map(Function<? super T, ? extends U> mapper) {
        return this.mapShrinkable(s -> s.map(mapper));
    }

    @API(status=API.Status.INTERNAL)
    default public <U> RandomGenerator<U> mapShrinkable(Function<? super Shrinkable<T>, ? extends Shrinkable<U>> mapper) {
        return random -> {
            Shrinkable<T> tShrinkable = this.next(random);
            return (Shrinkable)mapper.apply(tShrinkable);
        };
    }

    @API(status=API.Status.INTERNAL)
    default public <U> RandomGenerator<U> flatMap(Function<? super T, ? extends RandomGenerator<U>> mapper) {
        return random -> {
            Shrinkable<T> wrappedShrinkable = this.next(random);
            return RandomGeneratorFacade.implementation.flatMap(wrappedShrinkable, mapper, random.nextLong());
        };
    }

    @API(status=API.Status.INTERNAL)
    default public <U> RandomGenerator<U> flatMap(Function<? super T, ? extends Arbitrary<U>> mapper, int genSize, boolean withEmbeddedEdgeCases) {
        return random -> {
            Shrinkable<T> wrappedShrinkable = this.next(random);
            return RandomGeneratorFacade.implementation.flatMap(wrappedShrinkable, mapper, genSize, random.nextLong(), withEmbeddedEdgeCases);
        };
    }

    @API(status=API.Status.INTERNAL)
    default public RandomGenerator<T> filter(Predicate<? super T> filterPredicate, int maxMisses) {
        return RandomGeneratorFacade.implementation.filter(this, filterPredicate, maxMisses);
    }

    @API(status=API.Status.INTERNAL)
    default public RandomGenerator<T> withEdgeCases(int genSize, EdgeCases<T> edgeCases) {
        return RandomGeneratorFacade.implementation.withEdgeCases(this, genSize, edgeCases);
    }

    @API(status=API.Status.INTERNAL)
    default public Stream<Shrinkable<T>> stream(Random random) {
        return Stream.generate(() -> this.next(random));
    }

    @API(status=API.Status.INTERNAL)
    default public RandomGenerator<List<T>> collect(Predicate<? super List<? extends T>> until) {
        return RandomGeneratorFacade.implementation.collect(this, until);
    }

    @API(status=API.Status.INTERNAL)
    default public RandomGenerator<T> injectDuplicates(double duplicateProbability) {
        return RandomGeneratorFacade.implementation.injectDuplicates(this, duplicateProbability);
    }

    @API(status=API.Status.INTERNAL)
    default public RandomGenerator<T> ignoreExceptions(int maxThrows, Class<? extends Throwable>[] exceptionTypes) {
        return RandomGeneratorFacade.implementation.ignoreExceptions(this, exceptionTypes, maxThrows);
    }

    @API(status=API.Status.INTERNAL)
    default public RandomGenerator<T> dontShrink() {
        return random -> {
            Shrinkable<T> shrinkable = this.next(random).makeUnshrinkable();
            return shrinkable.makeUnshrinkable();
        };
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class RandomGeneratorFacade {
        private static final RandomGeneratorFacade implementation = FacadeLoader.load(RandomGeneratorFacade.class);

        public abstract <T, U> Shrinkable<U> flatMap(Shrinkable<T> var1, Function<? super T, ? extends RandomGenerator<U>> var2, long var3);

        public abstract <T, U> Shrinkable<U> flatMap(Shrinkable<T> var1, Function<? super T, ? extends Arbitrary<U>> var2, int var3, long var4, boolean var6);

        public abstract <T> RandomGenerator<T> filter(RandomGenerator<T> var1, Predicate<? super T> var2, int var3);

        public abstract <T> RandomGenerator<T> withEdgeCases(RandomGenerator<T> var1, int var2, EdgeCases<T> var3);

        public abstract <T> RandomGenerator<List<T>> collect(RandomGenerator<T> var1, Predicate<? super List<? extends T>> var2);

        public abstract <T> RandomGenerator<T> injectDuplicates(RandomGenerator<T> var1, double var2);

        public abstract <T> RandomGenerator<T> ignoreExceptions(RandomGenerator<T> var1, Class<? extends Throwable>[] var2, int var3);
    }
}

