/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.List;

class ShrinkingDistanceArraysSupport {
    ShrinkingDistanceArraysSupport() {
    }

    static long at(long[] array, int i) {
        return array.length > i ? array[i] : 0L;
    }

    static long[] sumUp(List<long[]> listOfArrays) {
        long[] summedUpArray = new long[ShrinkingDistanceArraysSupport.maxLength(listOfArrays)];
        for (long[] array : listOfArrays) {
            for (int i = 0; i < summedUpArray.length; ++i) {
                summedUpArray[i] = ShrinkingDistanceArraysSupport.plusWithoutOverflowAt(summedUpArray, array, i);
            }
        }
        return summedUpArray;
    }

    private static int maxLength(List<long[]> listOfArrays) {
        int maxDistanceSize = 0;
        for (long[] array : listOfArrays) {
            maxDistanceSize = Math.max(maxDistanceSize, array.length);
        }
        return maxDistanceSize;
    }

    private static long plusWithoutOverflowAt(long[] left, long[] right, int index) {
        long summedValue = ShrinkingDistanceArraysSupport.at(right, index) + ShrinkingDistanceArraysSupport.at(left, index);
        if (summedValue < 0L) {
            return Long.MAX_VALUE;
        }
        return summedValue;
    }

    static long[] concatenate(List<long[]> listOfArrays) {
        int size = listOfArrays.stream().mapToInt(s -> ((long[])s).length).sum();
        long[] concatenatedArrays = new long[size];
        int i = 0;
        for (long[] array : listOfArrays) {
            System.arraycopy(array, 0, concatenatedArrays, i, array.length);
            i += array.length;
        }
        return concatenatedArrays;
    }
}

