/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.state;

import java.util.function.Predicate;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.state.ActionBuilder;
import net.jqwik.api.state.Transformer;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.7.0")
public interface Action<S> {
    public static <T> ActionBuilder<T> builder() {
        return new ActionBuilder();
    }

    public static <T> ActionBuilder<T> when(Predicate<T> precondition) {
        return new ActionBuilder<T>().when(precondition);
    }

    public static <T> Independent<T> just(Transformer<T> transformer) {
        return Action.builder().just(transformer);
    }

    public static <T> Independent<T> just(String description, Transformer<T> transformer) {
        return Action.builder().describeAs(description).just(transformer);
    }

    default public boolean precondition(S state) {
        return true;
    }

    @FunctionalInterface
    public static interface Independent<S>
    extends Action<S> {
        public Arbitrary<Transformer<S>> transformer();
    }

    public static abstract class JustMutate<S>
    implements Independent<S> {
        @Override
        public Arbitrary<Transformer<S>> transformer() {
            return Arbitraries.just(Transformer.mutate(this.description(), this::mutate));
        }

        public abstract void mutate(S var1);

        public String description() {
            return this.getClass().getSimpleName();
        }
    }

    public static abstract class JustTransform<S>
    implements Independent<S> {
        @Override
        public Arbitrary<Transformer<S>> transformer() {
            return Arbitraries.just(Transformer.transform(this.description(), this::transform));
        }

        public abstract S transform(S var1);

        String description() {
            return this.getClass().getSimpleName();
        }
    }

    @FunctionalInterface
    public static interface Dependent<S>
    extends Action<S> {
        public Arbitrary<Transformer<S>> transformer(S var1);
    }
}

