/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.FacadeLoader;
import net.jqwik.api.JqwikException;
import net.jqwik.api.NullableType;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.ArrayArbitrary;
import net.jqwik.api.arbitraries.IteratorArbitrary;
import net.jqwik.api.arbitraries.ListArbitrary;
import net.jqwik.api.arbitraries.SetArbitrary;
import net.jqwik.api.arbitraries.StreamArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="1.0")
@CheckReturnValue
public interface Arbitrary<T> {
    public RandomGenerator<T> generator(int var1);

    @API(status=API.Status.INTERNAL, since="1.4.0")
    default public RandomGenerator<T> generator(int genSize, boolean withEdgeCases) {
        return ArbitraryFacade.implementation.memoizedGenerator(this, genSize, withEdgeCases);
    }

    @API(status=API.Status.INTERNAL, since="1.4.0")
    default public RandomGenerator<T> generatorWithEmbeddedEdgeCases(int genSize) {
        return this.generator(genSize);
    }

    @API(status=API.Status.INTERNAL)
    default public Arbitrary<Object> asGeneric() {
        return this;
    }

    @API(status=API.Status.INTERNAL)
    default public Optional<ExhaustiveGenerator<T>> exhaustive() {
        return this.exhaustive(Integer.MAX_VALUE);
    }

    @API(status=API.Status.INTERNAL)
    default public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
        return Optional.empty();
    }

    @API(status=API.Status.INTERNAL)
    default public boolean isGeneratorMemoizable() {
        return true;
    }

    public EdgeCases<T> edgeCases(int var1);

    @API(status=API.Status.EXPERIMENTAL, since="1.3.0")
    default public EdgeCases<T> edgeCases() {
        return this.edgeCases(1000);
    }

    default public Optional<Stream<T>> allValues() {
        return this.exhaustive().map((? super T generator) -> StreamSupport.stream(generator.spliterator(), false));
    }

    @API(status=API.Status.MAINTAINED, since="1.1.2")
    default public void forEachValue(Consumer<? super T> action) {
        if (!this.allValues().isPresent()) {
            throw new AssertionError((Object)("Cannot generate all values of " + this));
        }
        this.allValues().ifPresent(stream -> stream.forEach(action::accept));
    }

    default public Arbitrary<T> filter(Predicate<T> filterPredicate) {
        return this.filter(10000, filterPredicate);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.7.0")
    default public Arbitrary<T> filter(int maxMisses, Predicate<T> filterPredicate) {
        return ArbitraryFacade.implementation.filter(this, filterPredicate, maxMisses);
    }

    default public <U> Arbitrary<U> map(Function<T, U> mapper) {
        return ArbitraryFacade.implementation.map(this, mapper);
    }

    default public <U> Arbitrary<U> flatMap(Function<T, Arbitrary<U>> mapper) {
        return ArbitraryFacade.implementation.flatMap(this, mapper);
    }

    default public Arbitrary<@NullableType T> injectNull(double nullProbability) {
        return ArbitraryFacade.implementation.injectNull(this, nullProbability);
    }

    @API(status=API.Status.MAINTAINED, since="1.2.0")
    default public Arbitrary<T> fixGenSize(int genSize) {
        return ArbitraryFacade.implementation.fixGenSize(this, genSize);
    }

    default public ListArbitrary<T> list() {
        return ArbitraryFacade.implementation.list(this);
    }

    default public SetArbitrary<T> set() {
        return ArbitraryFacade.implementation.set(this);
    }

    default public StreamArbitrary<T> stream() {
        return ArbitraryFacade.implementation.stream(this);
    }

    default public IteratorArbitrary<T> iterator() {
        return ArbitraryFacade.implementation.iterator(this);
    }

    default public <A> ArrayArbitrary<T, A> array(Class<A> arrayClass) {
        return ArbitraryFacade.implementation.array(this, arrayClass);
    }

    default public Arbitrary<Optional<T>> optional() {
        return this.optional(0.95);
    }

    @API(status=API.Status.MAINTAINED, since="1.5.4")
    default public Arbitrary<Optional<T>> optional(double presenceProbability) {
        double emptyProbability = 1.0 - presenceProbability;
        return this.injectNull(emptyProbability).map(Optional::ofNullable);
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public Arbitrary<List<T>> collect(Predicate<List<T>> until) {
        return ArbitraryFacade.implementation.collect(this, until);
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public Stream<T> sampleStream() {
        return ArbitraryFacade.implementation.sampleStream(this);
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public T sample() {
        return this.sampleStream().map(Optional::ofNullable).findFirst().orElseThrow(() -> new JqwikException("Cannot generate a value")).orElse(null);
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public Arbitrary<T> injectDuplicates(final double duplicateProbability) {
        return new Arbitrary<T>(){

            @Override
            public RandomGenerator<T> generator(int genSize) {
                return Arbitrary.this.generator(genSize).injectDuplicates(duplicateProbability);
            }

            @Override
            public RandomGenerator<T> generatorWithEmbeddedEdgeCases(int genSize) {
                return Arbitrary.this.generatorWithEmbeddedEdgeCases(genSize).injectDuplicates(duplicateProbability);
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
                return Arbitrary.this.exhaustive(maxNumberOfSamples);
            }

            @Override
            public EdgeCases<T> edgeCases(int maxEdgeCases) {
                if (duplicateProbability >= 1.0) {
                    return EdgeCases.none();
                }
                return Arbitrary.this.edgeCases(maxEdgeCases);
            }

            @Override
            public boolean isGeneratorMemoizable() {
                return false;
            }
        };
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public Arbitrary<Tuple.Tuple1<T>> tuple1() {
        return this.map(Tuple::of);
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public Arbitrary<Tuple.Tuple2<T, T>> tuple2() {
        return this.list().ofSize(2).map(l -> Tuple.of(l.get(0), l.get(1)));
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public Arbitrary<Tuple.Tuple3<T, T, T>> tuple3() {
        return this.list().ofSize(3).map(l -> Tuple.of(l.get(0), l.get(1), l.get(2)));
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public Arbitrary<Tuple.Tuple4<T, T, T, T>> tuple4() {
        return this.list().ofSize(4).map(l -> Tuple.of(l.get(0), l.get(1), l.get(2), l.get(3)));
    }

    @API(status=API.Status.MAINTAINED, since="1.3.3")
    default public Arbitrary<Tuple.Tuple5<T, T, T, T, T>> tuple5() {
        return this.list().ofSize(5).map(l -> Tuple.of(l.get(0), l.get(1), l.get(2), l.get(3), l.get(4)));
    }

    @API(status=API.Status.MAINTAINED, since="1.3.1")
    default public Arbitrary<T> ignoreException(Class<? extends Throwable> exceptionType) {
        return this.ignoreExceptions(exceptionType);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.7.3")
    default public Arbitrary<T> ignoreException(int maxThrows, Class<? extends Throwable> exceptionType) {
        return this.ignoreExceptions(maxThrows, exceptionType);
    }

    @API(status=API.Status.MAINTAINED, since="1.7.2")
    default public Arbitrary<T> ignoreExceptions(Class<? extends Throwable> ... exceptionTypes) {
        return this.ignoreExceptions(10000, exceptionTypes);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.7.3")
    default public Arbitrary<T> ignoreExceptions(int maxThrows, Class<? extends Throwable> ... exceptionTypes) {
        return ArbitraryFacade.implementation.ignoreExceptions(this, maxThrows, exceptionTypes);
    }

    @API(status=API.Status.MAINTAINED, since="1.4.0")
    default public Arbitrary<T> dontShrink() {
        return ArbitraryFacade.implementation.dontShrink(this);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.3.9")
    default public Arbitrary<T> edgeCases(Consumer<EdgeCases.Config<T>> configurator) {
        return ArbitraryFacade.implementation.configureEdgeCases(this, configurator);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.4.0")
    default public Arbitrary<T> withoutEdgeCases() {
        return ArbitraryFacade.implementation.withoutEdgeCases(this);
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class ArbitraryFacade {
        private static final ArbitraryFacade implementation = FacadeLoader.load(ArbitraryFacade.class);

        public abstract <T> ListArbitrary<T> list(Arbitrary<T> var1);

        public abstract <T> SetArbitrary<T> set(Arbitrary<T> var1);

        public abstract <T> StreamArbitrary<T> stream(Arbitrary<T> var1);

        public abstract <T> IteratorArbitrary<T> iterator(Arbitrary<T> var1);

        public abstract <T, A> ArrayArbitrary<T, A> array(Arbitrary<T> var1, Class<A> var2);

        public abstract <T> Stream<T> sampleStream(Arbitrary<T> var1);

        public abstract <T> Arbitrary<T> injectNull(Arbitrary<T> var1, double var2);

        public abstract <T> Arbitrary<T> filter(Arbitrary<T> var1, Predicate<T> var2, int var3);

        public abstract <T, U> Arbitrary<U> map(Arbitrary<T> var1, Function<T, U> var2);

        public abstract <T, U> Arbitrary<U> flatMap(Arbitrary<T> var1, Function<T, Arbitrary<U>> var2);

        public abstract <T> Arbitrary<T> ignoreExceptions(Arbitrary<T> var1, int var2, Class<? extends Throwable>[] var3);

        public abstract <T> Arbitrary<T> dontShrink(Arbitrary<T> var1);

        public abstract <T> Arbitrary<T> configureEdgeCases(Arbitrary<T> var1, Consumer<EdgeCases.Config<T>> var2);

        public abstract <T> Arbitrary<T> withoutEdgeCases(Arbitrary<T> var1);

        public abstract <T> RandomGenerator<T> memoizedGenerator(Arbitrary<T> var1, int var2, boolean var3);

        public abstract <T> Arbitrary<T> fixGenSize(Arbitrary<T> var1, int var2);

        public abstract <T> Arbitrary<List<T>> collect(Arbitrary<T> var1, Predicate<List<T>> var2);
    }
}

