/*
 * Decompiled with CFR 0.152.
 */
package net.joshka.junit.json.params;

import jakarta.json.Json;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.joshka.junit.json.params.JsonFileSource;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.util.Preconditions;

public class JsonFileArgumentsProvider
implements AnnotationConsumer<JsonFileSource>,
ArgumentsProvider {
    private final BiFunction<Class<?>, String, InputStream> inputStreamProvider;
    private String[] resources;

    JsonFileArgumentsProvider() {
        this(Class::getResourceAsStream);
    }

    JsonFileArgumentsProvider(BiFunction<Class<?>, String, InputStream> inputStreamProvider) {
        this.inputStreamProvider = inputStreamProvider;
    }

    private static JsonValue values(InputStream inputStream) {
        try (JsonReader reader = Json.createReader((InputStream)inputStream);){
            JsonStructure jsonStructure = reader.read();
            return jsonStructure;
        }
    }

    public void accept(JsonFileSource jsonFileSource) {
        this.resources = jsonFileSource.resources();
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        boolean isList = Arrays.stream(context.getRequiredTestMethod().getParameterTypes()).anyMatch(List.class::isAssignableFrom);
        return Arrays.stream(this.resources).map(resource -> this.openInputStream(context, (String)resource)).map(JsonFileArgumentsProvider::values).flatMap(json -> {
            if (json.getValueType() == JsonValue.ValueType.ARRAY && !isList) {
                return json.asJsonArray().stream();
            }
            return Stream.of(json);
        }).map(xva$0 -> Arguments.arguments((Object[])new Object[]{xva$0}));
    }

    private InputStream openInputStream(ExtensionContext context, String resource) {
        Class testClass = context.getRequiredTestClass();
        InputStream inputStream = this.inputStreamProvider.apply(testClass, resource);
        return (InputStream)Preconditions.notNull((Object)inputStream, () -> "Classpath resource does not exist: " + resource);
    }
}

