/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.internal;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.FlowListener;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jodah.lyra.config.ChannelConfig;
import net.jodah.lyra.config.Config;
import net.jodah.lyra.event.ChannelListener;
import net.jodah.lyra.event.ConsumerListener;
import net.jodah.lyra.internal.Binding;
import net.jodah.lyra.internal.ConnectionHandler;
import net.jodah.lyra.internal.ConsumerDeclaration;
import net.jodah.lyra.internal.ConsumerDelegate;
import net.jodah.lyra.internal.QueueDeclaration;
import net.jodah.lyra.internal.RecurringStats;
import net.jodah.lyra.internal.ResourceDeclaration;
import net.jodah.lyra.internal.RetryableResource;
import net.jodah.lyra.internal.util.Collections;
import net.jodah.lyra.internal.util.Exceptions;
import net.jodah.lyra.internal.util.Reflection;

public class ChannelHandler
extends RetryableResource
implements InvocationHandler {
    private final ConnectionHandler connectionHandler;
    private final Config config;
    volatile long previousMaxDeliveryTag;
    volatile long maxDeliveryTag;
    volatile String lastGeneratedQueueName;
    Channel proxy;
    Channel delegate;
    private AtomicBoolean recoveryPending = new AtomicBoolean();
    private RecurringStats recoveryStats;
    private Map<String, ConsumerDeclaration> recoveryConsumers;
    private ShutdownSignalException lastShutdownSignal;
    final Map<String, ConsumerDeclaration> consumerDeclarations = Collections.synchronizedLinkedMap();
    private final List<ConfirmListener> confirmListeners = new CopyOnWriteArrayList<ConfirmListener>();
    private final List<FlowListener> flowListeners = new CopyOnWriteArrayList<FlowListener>();
    private final List<ReturnListener> returnListeners = new CopyOnWriteArrayList<ReturnListener>();
    private boolean flowBlocked;
    private ResourceDeclaration basicQos;
    private boolean confirmSelect;
    private boolean txSelect;

    public ChannelHandler(ConnectionHandler connectionHandler, Channel delegate, Config config) {
        this.connectionHandler = connectionHandler;
        this.delegate = delegate;
        this.config = config;
        ChannelShutdownListener listener = new ChannelShutdownListener();
        this.shutdownListeners.add(listener);
        delegate.addShutdownListener((ShutdownListener)listener);
    }

    @Override
    public Object invoke(Object ignored, final Method method, final Object[] args) throws Throwable {
        if (this.closed && method.getDeclaringClass().isAssignableFrom(Channel.class)) {
            throw new AlreadyClosedException(this.delegate.getCloseReason());
        }
        Callable<Object> callable = new Callable<Object>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object call() throws Exception {
                if (method.getDeclaringClass().isAssignableFrom(ChannelConfig.class)) {
                    return Reflection.invoke(ChannelHandler.this.config, method, args);
                }
                String methodName = method.getName();
                if ("basicAck".equals(methodName) || "basicNack".equals(methodName) || "basicReject".equals(methodName)) {
                    long deliveryTag = (Long)args[0] - ChannelHandler.this.previousMaxDeliveryTag;
                    if (deliveryTag <= 0L) return null;
                    args[0] = deliveryTag;
                } else {
                    if ("basicConsume".equals(methodName)) {
                        return ChannelHandler.this.handleConsumerDeclare(method, args);
                    }
                    if ("basicCancel".equals(methodName) && args[0] != null) {
                        ChannelHandler.this.consumerDeclarations.remove((String)args[0]);
                    } else if ("exchangeDelete".equals(methodName) && args[0] != null) {
                        ((ChannelHandler)ChannelHandler.this).connectionHandler.exchangeDeclarations.remove((String)args[0]);
                    } else if ("exchangeUnbind".equals(methodName) && args[0] != null) {
                        ((ChannelHandler)ChannelHandler.this).connectionHandler.exchangeBindings.remove((String)args[0], new Binding(args));
                    } else if ("queueDelete".equals(methodName) && args[0] != null) {
                        ((ChannelHandler)ChannelHandler.this).connectionHandler.queueDeclarations.remove((String)args[0]);
                    } else if ("queueUnbind".equals(methodName) && args[0] != null) {
                        ((ChannelHandler)ChannelHandler.this).connectionHandler.queueBindings.remove((String)args[0], new Binding(args));
                    }
                }
                Object result = Reflection.invoke(ChannelHandler.this.delegate, method, args);
                if ("exchangeDeclare".equals(methodName)) {
                    ChannelHandler.this.handleExchangeDeclare(method, args);
                    return result;
                } else if ("exchangeBind".equals(methodName)) {
                    ChannelHandler.this.handleExchangeBind(args);
                    return result;
                } else if ("queueDeclare".equals(methodName)) {
                    ChannelHandler.this.handleQueueDeclare(((AMQP.Queue.DeclareOk)result).getQueue(), method, args);
                    return result;
                } else if ("queueBind".equals(methodName)) {
                    ChannelHandler.this.handleQueueBind(method, args);
                    return result;
                } else if ("flowBlocked".equals(methodName)) {
                    ChannelHandler.this.flowBlocked = true;
                    return result;
                } else if ("basicQos".equals(methodName)) {
                    if (args.length >= 3 && ((Boolean)args[2]).booleanValue()) return result;
                    ChannelHandler.this.basicQos = new ResourceDeclaration(method, args);
                    return result;
                } else if ("confirmSelect".equals(methodName)) {
                    ChannelHandler.this.confirmSelect = true;
                    return result;
                } else if ("txSelect".equals(methodName)) {
                    ChannelHandler.this.txSelect = true;
                    return result;
                } else if (methodName.startsWith("add")) {
                    ChannelHandler.this.handleAdd(methodName, args[0]);
                    return result;
                } else if (methodName.startsWith("remove")) {
                    ChannelHandler.this.handleRemove(methodName, args[0]);
                    return result;
                } else {
                    if (!methodName.startsWith("clear")) return result;
                    ChannelHandler.this.handleClear(methodName);
                }
                return result;
            }

            public String toString() {
                return Reflection.toString(method);
            }
        };
        return this.handleCommonMethods(this.delegate, method, args) ? null : this.callWithRetries(callable, this.config.getChannelRetryPolicy(), null, this.config.getRetryableExceptions(), this.canRecover(), true);
    }

    public String toString() {
        return String.format("channel-%s on %s", this.delegate.getChannelNumber(), this.connectionHandler);
    }

    @Override
    void afterClosure() {
        this.connectionHandler.removeChannel(this.delegate.getChannelNumber());
    }

    boolean canRecover() {
        return this.connectionHandler.canRecover() && this.config.getChannelRecoveryPolicy() != null && this.config.getChannelRecoveryPolicy().allowsAttempts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void channelShutdown() {
        this.circuit.open();
        Map<String, ConsumerDeclaration> map = this.consumerDeclarations;
        synchronized (map) {
            for (ResourceDeclaration resourceDeclaration : this.consumerDeclarations.values()) {
                ((ConsumerDelegate)resourceDeclaration.args[resourceDeclaration.args.length - 1]).close();
            }
        }
    }

    synchronized void recoverChannel(boolean viaConnectionRecovery) throws Exception {
        block9: {
            this.recoveryPending.set(false);
            if (this.circuit.isClosed()) {
                return;
            }
            if (this.recoveryStats == null) {
                this.recoveryConsumers = this.consumerDeclarations.isEmpty() ? null : new LinkedHashMap<String, ConsumerDeclaration>(this.consumerDeclarations);
                this.recoveryStats = new RecurringStats(this.config.getChannelRecoveryPolicy());
                this.recoveryStats.incrementTime();
            } else if (this.recoveryStats.isPolicyExceeded()) {
                this.recoveryFailed((Exception)this.lastShutdownSignal);
                if (!viaConnectionRecovery) {
                    return;
                }
            }
            try {
                this.notifyRecoveryStarted();
                this.delegate = this.callWithRetries(new Callable<Channel>(){

                    @Override
                    public Channel call() throws Exception {
                        ChannelHandler.this.log.info("Recovering {}", (Object)ChannelHandler.this);
                        ChannelHandler.this.previousMaxDeliveryTag = ChannelHandler.this.maxDeliveryTag;
                        Channel channel = ChannelHandler.this.connectionHandler.createChannel(ChannelHandler.this.delegate.getChannelNumber());
                        ChannelHandler.this.migrateConfiguration(channel);
                        ChannelHandler.this.log.info("Recovered {}", (Object)ChannelHandler.this);
                        return channel;
                    }
                }, this.config.getChannelRecoveryPolicy(), this.recoveryStats, this.config.getRecoverableExceptions(), true, false);
                this.notifyRecovery();
                this.recoverConsumers(!viaConnectionRecovery);
                this.recoverySucceeded();
            }
            catch (Exception e) {
                ShutdownSignalException sse = Exceptions.extractCause(e, ShutdownSignalException.class);
                if (sse != null) {
                    if (Exceptions.isConnectionClosure(sse)) {
                        throw e;
                    }
                }
                if (!this.recoveryStats.isPolicyExceeded()) break block9;
                this.recoveryFailed(e);
            }
        }
    }

    private void handleAdd(String methodName, Object arg) {
        if ("addConfirmListener".equals(methodName)) {
            this.confirmListeners.add((ConfirmListener)arg);
        } else if ("addFlowListener".equals(methodName)) {
            this.flowListeners.add((FlowListener)arg);
        } else if ("addReturnListener".equals(methodName)) {
            this.returnListeners.add((ReturnListener)arg);
        }
    }

    private void handleClear(String methodName) {
        if ("clearConfirmListeners".equals(methodName)) {
            this.confirmListeners.clear();
        } else if ("clearFlowListeners".equals(methodName)) {
            this.flowListeners.clear();
        } else if ("clearReturnListeners".equals(methodName)) {
            this.returnListeners.clear();
        }
    }

    private String handleConsumerDeclare(Method method, Object[] args) throws Exception {
        if (this.config.isConsumerRecoveryEnabled()) {
            Consumer consumer = (Consumer)args[args.length - 1];
            args[args.length - 1] = new ConsumerDelegate(this, consumer);
            String consumerTag = (String)Reflection.invoke(this.delegate, method, args);
            String queueName = "".equals(args[0]) ? this.lastGeneratedQueueName : (String)args[0];
            QueueDeclaration queueDeclaration = this.connectionHandler.queueDeclarations.get(queueName);
            if (queueDeclaration != null) {
                queueName = queueDeclaration.name;
            }
            this.consumerDeclarations.put(consumerTag, new ConsumerDeclaration(queueDeclaration, method, args));
            this.log.info("".equals(queueName) ? "Created consumer-{}{} via {}" : "Created consumer-{} of {} via {}", new Object[]{consumerTag, queueName, this});
            return consumerTag;
        }
        return (String)Reflection.invoke(this.delegate, method, args);
    }

    private void handleExchangeBind(Object[] args) {
        if (this.config.isExchangeRecoveryEnabled()) {
            this.connectionHandler.exchangeBindings.put((String)args[0], new Binding(args));
        }
    }

    private void handleExchangeDeclare(Method method, Object[] args) {
        if (this.config.isExchangeRecoveryEnabled()) {
            boolean durable;
            boolean autoDelete = args.length > 3 && (Boolean)args[3] != false;
            boolean bl = durable = args.length > 2 && (Boolean)args[2] != false;
            if (autoDelete || !durable) {
                this.connectionHandler.exchangeDeclarations.put((String)args[0], new ResourceDeclaration(method, args));
            }
        }
    }

    private void handleQueueBind(Method method, Object[] args) {
        if (this.config.isQueueRecoveryEnabled()) {
            this.connectionHandler.queueBindings.put("".equals(args[0]) ? this.lastGeneratedQueueName : (String)args[0], new Binding(args));
        }
    }

    private void handleQueueDeclare(String queueName, Method method, Object[] args) {
        if (args == null) {
            this.lastGeneratedQueueName = queueName;
        }
        if (this.config.isQueueRecoveryEnabled()) {
            boolean durable;
            boolean autoDelete = args == null || (Boolean)args[3] != false;
            boolean bl = durable = args != null && (Boolean)args[1] != false;
            if (autoDelete || !durable) {
                this.connectionHandler.queueDeclarations.put(queueName, new QueueDeclaration(queueName, method, args));
            }
        }
    }

    private void handleRemove(String methodName, Object arg) {
        if ("removeConfirmListener".equals(methodName)) {
            this.confirmListeners.remove((ConfirmListener)arg);
        } else if ("removeFlowListener".equals(methodName)) {
            this.flowListeners.remove((FlowListener)arg);
        } else if ("removeReturnListener".equals(methodName)) {
            this.returnListeners.remove((ReturnListener)arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateConfiguration(Channel channel) throws Exception {
        channel.setDefaultConsumer(this.delegate.getDefaultConsumer());
        if (this.flowBlocked) {
            channel.flowBlocked();
        }
        if (this.basicQos != null) {
            this.basicQos.invoke(channel);
        }
        if (this.confirmSelect) {
            channel.confirmSelect();
        }
        if (this.txSelect) {
            channel.txSelect();
        }
        Iterator<FlowListener> iterator = this.shutdownListeners;
        synchronized (iterator) {
            for (ShutdownListener listener : this.shutdownListeners) {
                channel.addShutdownListener(listener);
            }
        }
        for (ConfirmListener confirmListener : this.confirmListeners) {
            channel.addConfirmListener(confirmListener);
        }
        for (FlowListener flowListener : this.flowListeners) {
            channel.addFlowListener(flowListener);
        }
        for (ReturnListener returnListener : this.returnListeners) {
            channel.addReturnListener(returnListener);
        }
    }

    private void notifyRecoveryStarted() {
        for (ChannelListener listener : this.config.getChannelListeners()) {
            try {
                listener.onRecoveryStarted(this.proxy);
            }
            catch (Exception exception) {}
        }
    }

    private void notifyRecovery() {
        for (ChannelListener listener : this.config.getChannelListeners()) {
            try {
                if (this.recoveryPending.get()) continue;
                listener.onRecovery(this.proxy);
            }
            catch (Exception exception) {}
        }
    }

    private void notifyRecoveryCompleted() {
        for (ChannelListener listener : this.config.getChannelListeners()) {
            try {
                listener.onRecoveryCompleted(this.proxy);
            }
            catch (Exception exception) {}
        }
    }

    private void notifyConsumerRecoveryStarted(Consumer consumer) {
        for (ConsumerListener listener : this.config.getConsumerListeners()) {
            try {
                listener.onRecoveryStarted(consumer, this.proxy);
            }
            catch (Exception exception) {}
        }
    }

    private void notifyConsumerRecoveryCompleted(Consumer consumer) {
        for (ConsumerListener listener : this.config.getConsumerListeners()) {
            try {
                listener.onRecoveryCompleted(consumer, this.proxy);
            }
            catch (Exception exception) {}
        }
    }

    private void notifyConsumerRecoveryFailure(Consumer consumer, Exception e) {
        for (ConsumerListener listener : this.config.getConsumerListeners()) {
            try {
                listener.onRecoveryFailure(consumer, this.proxy, e);
            }
            catch (Exception exception) {}
        }
    }

    private void recoverConsumers(boolean recoverReferences) throws Exception {
        if (this.config.isConsumerRecoveryEnabled() && !this.recoveryPending.get() && this.recoveryConsumers != null) {
            HashSet<QueueDeclaration> recoveredQueues = new HashSet<QueueDeclaration>();
            HashSet<String> recoveredExchanges = new HashSet<String>();
            Iterator<Map.Entry<String, ConsumerDeclaration>> it = this.recoveryConsumers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, ConsumerDeclaration> entry = it.next();
                ConsumerDeclaration consumerDeclaration = entry.getValue();
                Object[] args = consumerDeclaration.args;
                ConsumerDelegate consumer = (ConsumerDelegate)args[args.length - 1];
                String queueName = consumerDeclaration.queueDeclaration != null ? consumerDeclaration.queueDeclaration.name : (String)args[0];
                try {
                    if (recoverReferences) {
                        List<Binding> queueBindings = this.connectionHandler.queueBindings.get(queueName);
                        this.recoverRelatedExchanges(recoveredExchanges, queueBindings);
                        if (consumerDeclaration.queueDeclaration != null && recoveredQueues.add(consumerDeclaration.queueDeclaration)) {
                            queueName = this.recoverQueue(queueName, consumerDeclaration.queueDeclaration, queueBindings);
                        }
                    }
                    this.log.info(queueName == "" ? "Recovering consumer-{}{} via {}" : "Recovering consumer-{} of {} via {}", new Object[]{entry.getKey(), queueName, this});
                    this.notifyConsumerRecoveryStarted(consumer);
                    consumer.open();
                    consumerDeclaration.invoke(this.delegate);
                    this.notifyConsumerRecoveryCompleted(consumer);
                }
                catch (Exception e) {
                    this.log.error("Failed to recover consumer-{} via {}", new Object[]{entry.getKey(), this, e});
                    this.notifyConsumerRecoveryFailure(consumer, e);
                    ShutdownSignalException sse = Exceptions.extractCause(e, ShutdownSignalException.class);
                    if (sse == null) continue;
                    if (!Exceptions.isConnectionClosure(sse)) {
                        it.remove();
                    }
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverRelatedExchanges(Set<String> recoveredExchanges, List<Binding> queueBindings) throws Exception {
        if (this.config.isExchangeRecoveryEnabled() && queueBindings != null) {
            List<Binding> list = queueBindings;
            synchronized (list) {
                for (Binding queueBinding : queueBindings) {
                    String exchangeName = queueBinding.source;
                    if (!recoveredExchanges.add(exchangeName)) continue;
                    ResourceDeclaration exchangeDeclaration = this.connectionHandler.exchangeDeclarations.get(exchangeName);
                    if (exchangeDeclaration != null) {
                        this.recoverExchange(exchangeName, exchangeDeclaration);
                    }
                    this.recoverExchangeBindings(this.connectionHandler.exchangeBindings.get(exchangeName));
                }
            }
        }
    }

    private String recoverQueue(String queueName, QueueDeclaration queueDeclaration, List<Binding> queueBindings) throws Exception {
        String newQueueName = queueName;
        if (this.config.isQueueRecoveryEnabled()) {
            if (queueDeclaration != null && !queueName.equals(newQueueName = this.recoverQueue(queueName, queueDeclaration))) {
                this.connectionHandler.queueDeclarations.remove(queueName);
                this.connectionHandler.queueDeclarations.put(newQueueName, queueDeclaration);
                this.connectionHandler.updateQueueBindingReferences(queueName, newQueueName);
            }
            this.recoverQueueBindings(queueBindings);
        }
        return newQueueName;
    }

    private void recoveryComplete() {
        this.recoveryStats = null;
        this.recoveryConsumers = null;
        this.lastShutdownSignal = null;
    }

    private void recoverySucceeded() {
        if (!this.recoveryPending.get()) {
            this.notifyRecoveryCompleted();
            this.recoveryComplete();
            this.circuit.close();
        }
    }

    private void recoveryFailed(Exception e) {
        this.log.error("Failed to recover {}", (Object)this, (Object)e);
        this.recoveryComplete();
        this.interruptWaiters();
        for (ChannelListener listener : this.config.getChannelListeners()) {
            try {
                listener.onRecoveryFailure(this.proxy, e);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    Channel getRecoveryChannel() {
        return this.delegate;
    }

    @Override
    boolean throwOnRecoveryFailure() {
        return true;
    }

    private class ChannelShutdownListener
    implements ShutdownListener {
        private ChannelShutdownListener() {
        }

        public void shutdownCompleted(ShutdownSignalException e) {
            ChannelHandler.this.channelShutdown();
            if (!e.isInitiatedByApplication()) {
                ChannelHandler.this.log.error("Channel {} was closed unexpectedly", (Object)ChannelHandler.this);
                ChannelHandler.this.lastShutdownSignal = e;
                if (!Exceptions.isConnectionClosure(e) && ChannelHandler.this.canRecover()) {
                    ConnectionHandler.RECOVERY_EXECUTORS.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ChannelHandler.this.recoveryPending.set(true);
                                ChannelHandler.this.recoverChannel(false);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        }
    }
}

