/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.internal;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import net.jodah.lyra.internal.Binding;
import net.jodah.lyra.internal.QueueDeclaration;
import net.jodah.lyra.internal.RecurringPolicy;
import net.jodah.lyra.internal.RecurringStats;
import net.jodah.lyra.internal.ResourceDeclaration;
import net.jodah.lyra.internal.util.Collections;
import net.jodah.lyra.internal.util.Exceptions;
import net.jodah.lyra.internal.util.Reflection;
import net.jodah.lyra.internal.util.concurrent.InterruptableWaiter;
import net.jodah.lyra.internal.util.concurrent.ReentrantCircuit;
import net.jodah.lyra.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RetryableResource {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    final ReentrantCircuit circuit = new ReentrantCircuit();
    final InterruptableWaiter retryWaiter = new InterruptableWaiter();
    final List<ShutdownListener> shutdownListeners = Collections.synchronizedList();
    volatile boolean closed;

    RetryableResource() {
    }

    void afterClosure() {
    }

    <T> T callWithRetries(Callable<T> callable, RecurringPolicy<?> recurringPolicy, RecurringStats retryStats, Set<Class<? extends Exception>> retryableExceptions, boolean recoverable, boolean logFailures) throws Exception {
        boolean recovery = retryStats != null;
        while (true) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                block15: {
                    ShutdownSignalException sse = Exceptions.extractCause(e, ShutdownSignalException.class);
                    if (sse == null && logFailures && recurringPolicy != null && recurringPolicy.allowsAttempts()) {
                        this.log.error("Invocation of {} failed.", callable, (Object)e);
                    }
                    if (sse != null && (recovery || !recoverable)) {
                        throw e;
                    }
                    if (!this.closed) {
                        try {
                            boolean retryable = recurringPolicy != null && recurringPolicy.allowsAttempts() && Exceptions.isRetryable(retryableExceptions, e, sse);
                            long startTime = System.nanoTime();
                            if (retryable) {
                                if (retryStats == null) {
                                    retryStats = new RecurringStats(recurringPolicy);
                                }
                                if (sse != null) {
                                    if (recurringPolicy.getMaxDuration() == null) {
                                        this.circuit.await();
                                    } else if (!this.circuit.await(retryStats.getMaxWaitTime())) {
                                        this.log.debug("Exceeded max wait time while waiting for {} to recover", (Object)this);
                                        throw e;
                                    }
                                }
                                retryStats.incrementAttempts();
                                if (!retryStats.isPolicyExceeded()) {
                                    long remainingWaitTime = retryStats.getWaitTime().toNanos() - (System.nanoTime() - startTime);
                                    if (remainingWaitTime <= 0L) continue;
                                    this.retryWaiter.await(Duration.nanos(remainingWaitTime));
                                    continue;
                                }
                            }
                            break block15;
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                            break block15;
                        }
                        continue;
                    }
                }
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleCommonMethods(Object delegate, Method method, Object[] args) throws Throwable {
        if ("abort".equals(method.getName()) || "close".equals(method.getName())) {
            try {
                Reflection.invoke(delegate, method, args);
                boolean bl = true;
                return bl;
            }
            finally {
                this.closed = true;
                this.afterClosure();
                this.interruptWaiters();
            }
        }
        if ("addShutdownListener".equals(method.getName()) && args[0] != null) {
            this.shutdownListeners.add((ShutdownListener)args[0]);
        } else if ("removeShutdownListener".equals(method.getName()) && args[0] != null) {
            this.shutdownListeners.remove((ShutdownListener)args[0]);
        }
        return false;
    }

    void interruptWaiters() {
        this.circuit.interruptWaiters();
        this.retryWaiter.interruptWaiters();
    }

    abstract Channel getRecoveryChannel() throws IOException;

    abstract boolean throwOnRecoveryFailure();

    void recoverExchange(String exchangeName, ResourceDeclaration exchangeDeclaration) throws Exception {
        block2: {
            try {
                this.log.info("Recovering exchange {} via {}", (Object)exchangeName, (Object)this);
                exchangeDeclaration.invoke(this.getRecoveryChannel());
            }
            catch (Exception e) {
                this.log.error("Failed to recover exchange {} via {}", new Object[]{exchangeName, this, e});
                if (!this.throwOnRecoveryFailure() && !Exceptions.isCausedByConnectionClosure(e)) break block2;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recoverExchangeBindings(Iterable<Binding> exchangeBindings) throws Exception {
        if (exchangeBindings != null) {
            Iterable<Binding> iterable = exchangeBindings;
            synchronized (iterable) {
                for (Binding binding : exchangeBindings) {
                    try {
                        this.log.info("Recovering exchange binding from {} to {} with {} via {}", new Object[]{binding.source, binding.destination, binding.routingKey, this});
                        this.getRecoveryChannel().exchangeBind(binding.destination, binding.source, binding.routingKey, binding.arguments);
                    }
                    catch (Exception e) {
                        this.log.error("Failed to recover exchange binding from {} to {} with {} via {}", new Object[]{binding.source, binding.destination, binding.routingKey, this, e});
                        if (!this.throwOnRecoveryFailure() && !Exceptions.isCausedByConnectionClosure(e)) continue;
                        throw e;
                    }
                }
            }
        }
    }

    String recoverQueue(String queueName, QueueDeclaration queueDeclaration) throws Exception {
        try {
            String newQueueName = ((AMQP.Queue.DeclareOk)queueDeclaration.invoke(this.getRecoveryChannel())).getQueue();
            if (queueName.equals(newQueueName)) {
                this.log.info("Recovered queue {} via {}", (Object)queueName, (Object)this);
            } else {
                this.log.info("Recovered queue {} as {} via {}", new Object[]{queueName, newQueueName, this});
                queueDeclaration.name = newQueueName;
            }
            return newQueueName;
        }
        catch (Exception e) {
            this.log.error("Failed to recover queue {} via {}", new Object[]{queueName, this, e});
            if (this.throwOnRecoveryFailure() || Exceptions.isCausedByConnectionClosure(e)) {
                throw e;
            }
            return queueName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recoverQueueBindings(Iterable<Binding> queueBindings) throws Exception {
        if (queueBindings != null) {
            Iterable<Binding> iterable = queueBindings;
            synchronized (iterable) {
                for (Binding binding : queueBindings) {
                    try {
                        this.log.info("Recovering queue binding from {} to {} with {} via {}", new Object[]{binding.source, binding.destination, binding.routingKey, this});
                        this.getRecoveryChannel().queueBind(binding.destination, binding.source, binding.routingKey, binding.arguments);
                    }
                    catch (Exception e) {
                        this.log.error("Failed to recover queue binding from {} to {} with {} via {}", new Object[]{binding.source, binding.destination, binding.routingKey, this, e});
                        if (!this.throwOnRecoveryFailure() && !Exceptions.isCausedByConnectionClosure(e)) continue;
                        throw e;
                    }
                }
            }
        }
    }
}

