/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.internal.util.concurrent;

import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import net.jodah.lyra.util.Duration;

public class InterruptableWaiter {
    private final Sync sync = new Sync();

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(0);
    }

    public void await(Duration waitDuration) throws InterruptedException {
        this.sync.tryAcquireSharedNanos(0, waitDuration.toNanos());
    }

    public void interruptWaiters() {
        for (Thread t : this.sync.getSharedQueuedThreads()) {
            t.interrupt();
        }
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 4016766900138538852L;

        private Sync() {
        }

        @Override
        protected int tryAcquireShared(int acquires) {
            return -1;
        }
    }
}

