/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.config;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.jodah.lyra.config.ConfigurableChannel;
import net.jodah.lyra.config.ConfigurableConnection;
import net.jodah.lyra.config.ConnectionConfig;
import net.jodah.lyra.config.RecoveryPolicy;
import net.jodah.lyra.config.RetryPolicy;
import net.jodah.lyra.event.ChannelListener;
import net.jodah.lyra.event.ConnectionListener;
import net.jodah.lyra.event.ConsumerListener;
import net.jodah.lyra.internal.util.Assert;

public class Config
implements ConnectionConfig {
    private static final Class<Exception>[] RECURRING_EXCEPTIONS = new Class[]{SocketTimeoutException.class, ConnectException.class, AlreadyClosedException.class};
    private final Config parent;
    private RetryPolicy retryPolicy;
    private RecoveryPolicy recoveryPolicy;
    private RetryPolicy connectRetryPolicy;
    private RecoveryPolicy connectionRecoveryPolicy;
    private RetryPolicy connectionRetryPolicy;
    private RecoveryPolicy channelRecoveryPolicy;
    private RetryPolicy channelRetryPolicy;
    private Boolean exchangeRecovery;
    private Boolean queueRecovery;
    private Boolean consumerRecovery;
    private Collection<ConnectionListener> connectionListeners;
    private Collection<ChannelListener> channelListeners;
    private Collection<ConsumerListener> consumerListeners;
    private Set<Class<? extends Exception>> retryableExceptions;
    private Set<Class<? extends Exception>> recoverableExceptions;

    public Config() {
        this.parent = null;
        this.retryableExceptions = new CopyOnWriteArraySet<Class<? extends Exception>>();
        this.recoverableExceptions = new CopyOnWriteArraySet<Class<? extends Exception>>();
        for (Class<Exception> e : RECURRING_EXCEPTIONS) {
            this.retryableExceptions.add(e);
            this.recoverableExceptions.add(e);
        }
    }

    public Config(Config parent) {
        this.parent = parent;
    }

    public static ConfigurableChannel of(Channel channel) {
        Assert.isTrue(channel instanceof ConfigurableChannel, "The channel {} was not created by Lyra", channel);
        return (ConfigurableChannel)channel;
    }

    public static ConfigurableConnection of(Connection connection) {
        Assert.isTrue(connection instanceof ConfigurableConnection, "The connection {} was not created by Lyra", connection);
        return (ConfigurableConnection)connection;
    }

    @Override
    public Collection<ChannelListener> getChannelListeners() {
        return this.channelListeners != null ? this.channelListeners : (this.parent != null ? this.parent.getChannelListeners() : Collections.emptyList());
    }

    @Override
    public RecoveryPolicy getChannelRecoveryPolicy() {
        RecoveryPolicy result;
        RecoveryPolicy recoveryPolicy = result = this.channelRecoveryPolicy == null ? this.recoveryPolicy : this.channelRecoveryPolicy;
        return result != null ? result : (this.parent != null ? this.parent.getChannelRecoveryPolicy() : null);
    }

    @Override
    public RetryPolicy getChannelRetryPolicy() {
        RetryPolicy result;
        RetryPolicy retryPolicy = result = this.channelRetryPolicy == null ? this.retryPolicy : this.channelRetryPolicy;
        return result != null ? result : (this.parent != null ? this.parent.getChannelRetryPolicy() : null);
    }

    @Override
    public Collection<ConnectionListener> getConnectionListeners() {
        return this.connectionListeners != null ? this.connectionListeners : (this.parent != null ? this.parent.getConnectionListeners() : Collections.emptyList());
    }

    @Override
    public RecoveryPolicy getConnectionRecoveryPolicy() {
        RecoveryPolicy result;
        RecoveryPolicy recoveryPolicy = result = this.connectionRecoveryPolicy == null ? this.recoveryPolicy : this.connectionRecoveryPolicy;
        return result != null ? result : (this.parent != null ? this.parent.getConnectionRecoveryPolicy() : null);
    }

    @Override
    public RetryPolicy getConnectionRetryPolicy() {
        RetryPolicy result;
        RetryPolicy retryPolicy = result = this.connectionRetryPolicy == null ? this.retryPolicy : this.connectionRetryPolicy;
        return result != null ? result : (this.parent != null ? this.parent.getConnectionRetryPolicy() : null);
    }

    public RetryPolicy getConnectRetryPolicy() {
        RetryPolicy result;
        RetryPolicy retryPolicy = result = this.connectRetryPolicy == null ? this.retryPolicy : this.connectRetryPolicy;
        return result != null ? result : (this.parent != null ? this.parent.getConnectRetryPolicy() : null);
    }

    @Override
    public Collection<ConsumerListener> getConsumerListeners() {
        return this.consumerListeners != null ? this.consumerListeners : (this.parent != null ? this.parent.getConsumerListeners() : Collections.emptyList());
    }

    public Set<Class<? extends Exception>> getRecoverableExceptions() {
        return this.recoverableExceptions != null ? this.recoverableExceptions : (this.parent != null ? this.parent.getRecoverableExceptions() : Collections.emptySet());
    }

    public Set<Class<? extends Exception>> getRetryableExceptions() {
        return this.retryableExceptions != null ? this.retryableExceptions : (this.parent != null ? this.parent.getRetryableExceptions() : Collections.emptySet());
    }

    @Override
    public boolean isConsumerRecoveryEnabled() {
        Boolean result = this.consumerRecovery != null ? this.consumerRecovery : (this.parent != null ? Boolean.valueOf(this.parent.isConsumerRecoveryEnabled()) : null);
        return this.isRecoveryEnabled(result);
    }

    @Override
    public boolean isExchangeRecoveryEnabled() {
        Boolean result = this.exchangeRecovery != null ? this.exchangeRecovery : (this.parent != null ? Boolean.valueOf(this.parent.isExchangeRecoveryEnabled()) : null);
        return this.isRecoveryEnabled(result);
    }

    @Override
    public boolean isQueueRecoveryEnabled() {
        Boolean result = this.queueRecovery != null ? this.queueRecovery : (this.parent != null ? Boolean.valueOf(this.parent.isQueueRecoveryEnabled()) : null);
        return this.isRecoveryEnabled(result);
    }

    @Override
    public Config withChannelListeners(ChannelListener ... channelListeners) {
        this.channelListeners = Arrays.asList(channelListeners);
        return this;
    }

    @Override
    public Config withChannelRecoveryPolicy(RecoveryPolicy channelRecoveryPolicy) {
        this.channelRecoveryPolicy = channelRecoveryPolicy;
        return this;
    }

    @Override
    public Config withChannelRetryPolicy(RetryPolicy channelRetryPolicy) {
        this.channelRetryPolicy = channelRetryPolicy;
        return this;
    }

    @Override
    public Config withConnectionListeners(ConnectionListener ... connectionListeners) {
        this.connectionListeners = Arrays.asList(connectionListeners);
        return this;
    }

    @Override
    public Config withConnectionRecoveryPolicy(RecoveryPolicy connectionRecoveryPolicy) {
        this.connectionRecoveryPolicy = connectionRecoveryPolicy;
        return this;
    }

    @Override
    public Config withConnectionRetryPolicy(RetryPolicy connectionRetryPolicy) {
        this.connectionRetryPolicy = connectionRetryPolicy;
        return this;
    }

    public Config withConnectRetryPolicy(RetryPolicy connectRetryPolicy) {
        this.connectRetryPolicy = connectRetryPolicy;
        return this;
    }

    @Override
    public Config withConsumerListeners(ConsumerListener ... consumerListeners) {
        this.consumerListeners = Arrays.asList(consumerListeners);
        return this;
    }

    @Override
    public Config withConsumerRecovery(boolean enabled) {
        this.consumerRecovery = enabled;
        return this;
    }

    @Override
    public Config withExchangeRecovery(boolean enabled) {
        this.exchangeRecovery = enabled;
        return this;
    }

    @Override
    public Config withQueueRecovery(boolean enabled) {
        this.queueRecovery = enabled;
        return this;
    }

    public Config withRecoveryPolicy(RecoveryPolicy recoveryPolicy) {
        this.recoveryPolicy = recoveryPolicy;
        return this;
    }

    public Config withRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    private Boolean isRecoveryEnabled(Boolean recovery) {
        if (recovery != null) {
            return recovery;
        }
        RecoveryPolicy policy = this.getChannelRecoveryPolicy();
        return policy != null && policy.allowsAttempts();
    }
}

