/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.internal;

import net.jodah.lyra.internal.RecurringPolicy;
import net.jodah.lyra.util.Duration;

public final class RecurringStats {
    private final int maxAttempts;
    private final long maxDuration;
    private final long interval;
    private long startTime;
    private double intervalMultiplier = -1.0;
    private long maxInterval;
    private int attemptCount;
    private long waitTime;
    private long maxWaitTime;

    public RecurringStats(RecurringPolicy<?> retryPolicy) {
        this.maxAttempts = retryPolicy.getMaxAttempts();
        long l = this.interval = retryPolicy.getInterval() == null ? 0L : retryPolicy.getInterval().toNanos();
        if (retryPolicy.getMaxDuration() == null) {
            this.maxDuration = -1L;
            this.waitTime = this.interval;
            this.maxWaitTime = -1L;
        } else {
            this.maxDuration = retryPolicy.getMaxDuration().toNanos();
            this.waitTime = Math.min(this.interval, this.maxDuration);
            this.maxWaitTime = this.maxDuration;
        }
        if (retryPolicy.getMaxInterval() != null) {
            this.intervalMultiplier = retryPolicy.getIntervalMultiplier();
            this.maxInterval = retryPolicy.getMaxInterval().toNanos();
        }
    }

    public Duration getMaxWaitTime() {
        return this.maxWaitTime == -1L ? Duration.inf() : Duration.nanos(this.maxWaitTime);
    }

    public Duration getWaitTime() {
        return Duration.nanos(this.waitTime);
    }

    public void incrementAttempts() {
        ++this.attemptCount;
        this.incrementTime();
    }

    public void incrementTime() {
        long now = System.nanoTime();
        if (this.startTime == 0L) {
            this.startTime = now;
        } else if (this.intervalMultiplier != -1.0) {
            this.waitTime = Math.min(this.maxInterval, (long)((double)this.waitTime * this.intervalMultiplier));
        }
        if (this.maxDuration != -1L) {
            long elapsedNanos = now - this.startTime;
            this.waitTime = Math.min(this.waitTime, this.maxDuration - elapsedNanos);
            this.maxWaitTime = this.maxDuration - elapsedNanos;
        }
    }

    public boolean isPolicyExceeded() {
        boolean withinMaxRetries = this.maxAttempts == -1 || this.attemptCount < this.maxAttempts;
        boolean withinMaxDuration = this.maxDuration == -1L || System.nanoTime() - this.startTime < this.maxDuration;
        return !withinMaxRetries || !withinMaxDuration;
    }
}

