/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ArrayListMultiMap<K, V> {
    private final Map<K, List<V>> map = new ConcurrentHashMap<K, List<V>>();

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public List<V> get(K key) {
        return this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(K key, V value) {
        Object object;
        List<V> set = this.map.get(key);
        if (set == null) {
            object = this.map;
            synchronized (object) {
                set = this.map.get(key);
                if (set == null) {
                    set = new ArrayList<V>();
                    this.map.put(key, set);
                }
            }
        }
        object = set;
        synchronized (object) {
            return set.add(value);
        }
    }

    public List<V> putAll(K key, List<V> values) {
        return this.map.put(key, values);
    }

    public List<V> remove(K key) {
        return this.map.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key, V value) {
        List<V> set = this.map.get(key);
        if (set == null) {
            return false;
        }
        List<V> list = set;
        synchronized (list) {
            boolean result = set.remove(value);
            if (set.isEmpty()) {
                this.map.remove(key);
            }
            return result;
        }
    }

    public Iterable<V> values() {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    final Iterator<List<V>> valuesIterator;
                    Iterator<V> current;
                    {
                        this.valuesIterator = ArrayListMultiMap.this.map.values().iterator();
                        if (this.valuesIterator.hasNext()) {
                            this.current = this.valuesIterator.next().iterator();
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current != null && this.current.hasNext();
                    }

                    @Override
                    public V next() {
                        Object value = this.current.next();
                        while (!this.current.hasNext() && this.valuesIterator.hasNext()) {
                            this.current = this.valuesIterator.next().iterator();
                        }
                        return value;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

