/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.internal;

import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import net.jodah.lyra.internal.RecurringPolicy;
import net.jodah.lyra.internal.RecurringStats;
import net.jodah.lyra.internal.util.Collections;
import net.jodah.lyra.internal.util.Exceptions;
import net.jodah.lyra.internal.util.Reflection;
import net.jodah.lyra.internal.util.concurrent.InterruptableWaiter;
import net.jodah.lyra.internal.util.concurrent.ReentrantCircuit;
import net.jodah.lyra.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RetryableResource {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    final ReentrantCircuit circuit = new ReentrantCircuit();
    final InterruptableWaiter retryWaiter = new InterruptableWaiter();
    final List<ShutdownListener> shutdownListeners = Collections.synchronizedList();
    volatile boolean closed;

    RetryableResource() {
    }

    void afterClosure() {
    }

    <T> T callWithRetries(Callable<T> callable, RecurringPolicy<?> recurringPolicy, RecurringStats retryStats, boolean recoverable, boolean logFailures) throws Exception {
        boolean recovery = retryStats != null;
        while (true) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                block15: {
                    ShutdownSignalException sse = Exceptions.extractCause(e, ShutdownSignalException.class);
                    if (sse == null && logFailures && recurringPolicy != null && recurringPolicy.allowsAttempts()) {
                        this.log.error("Invocation of {} failed.", callable, (Object)e);
                    }
                    if (sse != null && (recovery || !recoverable)) {
                        throw e;
                    }
                    if (!this.closed) {
                        try {
                            boolean retryable = recurringPolicy != null && recurringPolicy.allowsAttempts() && Exceptions.isRetryable(e, sse);
                            long startTime = System.nanoTime();
                            if (retryable) {
                                if (sse != null) {
                                    if (recurringPolicy.getMaxDuration() == null) {
                                        this.circuit.await();
                                    } else if (!this.circuit.await(retryStats.getMaxWaitTime())) {
                                        this.log.debug("Exceeded max wait time while waiting for {} to recover", (Object)this);
                                        throw e;
                                    }
                                }
                                if (retryStats == null) {
                                    retryStats = new RecurringStats(recurringPolicy);
                                }
                                retryStats.incrementAttempts();
                                if (!retryStats.isPolicyExceeded()) {
                                    long remainingWaitTime = retryStats.getWaitTime().toNanos() - (System.nanoTime() - startTime);
                                    if (remainingWaitTime <= 0L) continue;
                                    this.retryWaiter.await(Duration.nanos(remainingWaitTime));
                                    continue;
                                }
                            }
                            break block15;
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                            break block15;
                        }
                        continue;
                    }
                }
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleCommonMethods(Object delegate, Method method, Object[] args) throws Throwable {
        if ("abort".equals(method.getName()) || "close".equals(method.getName())) {
            try {
                Reflection.invoke(delegate, method, args);
                boolean bl = true;
                return bl;
            }
            finally {
                this.closed = true;
                this.afterClosure();
                this.interruptWaiters();
            }
        }
        if ("addShutdownListener".equals(method.getName()) && args[0] != null) {
            this.shutdownListeners.add((ShutdownListener)args[0]);
        } else if ("removeShutdownListener".equals(method.getName()) && args[0] != null) {
            this.shutdownListeners.remove((ShutdownListener)args[0]);
        }
        return false;
    }

    void interruptWaiters() {
        this.circuit.interruptWaiters();
        this.retryWaiter.interruptWaiters();
    }

    abstract void resourceClosed();
}

