/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.internal;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.FlowListener;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jodah.lyra.config.ChannelConfig;
import net.jodah.lyra.config.Config;
import net.jodah.lyra.event.ChannelListener;
import net.jodah.lyra.event.ConsumerListener;
import net.jodah.lyra.internal.ConnectionHandler;
import net.jodah.lyra.internal.ConsumerDelegate;
import net.jodah.lyra.internal.Invocation;
import net.jodah.lyra.internal.RecurringStats;
import net.jodah.lyra.internal.RetryableResource;
import net.jodah.lyra.internal.util.Collections;
import net.jodah.lyra.internal.util.Exceptions;
import net.jodah.lyra.internal.util.Reflection;

public class ChannelHandler
extends RetryableResource
implements InvocationHandler {
    private final ConnectionHandler connectionHandler;
    private final Config config;
    volatile long previousMaxDeliveryTag;
    volatile long maxDeliveryTag;
    Channel proxy;
    Channel delegate;
    private AtomicBoolean recoveryPending = new AtomicBoolean();
    private RecurringStats recoveryStats;
    private Map<String, Invocation> recoveryConsumers;
    private ShutdownSignalException lastShutdownSignal;
    final Map<String, Invocation> consumerInvocations = Collections.synchronizedMap();
    private List<ConfirmListener> confirmListeners = new CopyOnWriteArrayList<ConfirmListener>();
    private List<FlowListener> flowListeners = new CopyOnWriteArrayList<FlowListener>();
    private List<ReturnListener> returnListeners = new CopyOnWriteArrayList<ReturnListener>();
    private boolean flowDisabled;
    private Invocation basicQos;
    private boolean confirmSelect;
    private boolean txSelect;

    public ChannelHandler(ConnectionHandler connectionHandler, Channel delegate, Config config) {
        this.connectionHandler = connectionHandler;
        this.delegate = delegate;
        this.config = config;
        ChannelShutdownListener listener = new ChannelShutdownListener();
        this.shutdownListeners.add(listener);
        delegate.addShutdownListener((ShutdownListener)listener);
    }

    @Override
    public Object invoke(Object ignored, final Method method, final Object[] args) throws Throwable {
        if (this.closed && method.getDeclaringClass().isAssignableFrom(Channel.class)) {
            throw new AlreadyClosedException("Attempt to use closed channel", (Object)this.proxy);
        }
        Callable<Object> callable = new Callable<Object>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object call() throws Exception {
                if (method.getDeclaringClass().isAssignableFrom(ChannelConfig.class)) {
                    return Reflection.invoke(ChannelHandler.this.config, method, args);
                }
                String methodName = method.getName();
                if ("basicAck".equals(methodName) || "basicNack".equals(methodName) || "basicReject".equals(methodName)) {
                    long deliveryTag = (Long)args[0] - ChannelHandler.this.previousMaxDeliveryTag;
                    if (deliveryTag <= 0L) return null;
                    args[0] = deliveryTag;
                } else {
                    if ("basicConsume".equals(methodName)) {
                        Consumer consumer = (Consumer)args[args.length - 1];
                        args[args.length - 1] = new ConsumerDelegate(ChannelHandler.this, consumer);
                        String consumerTag = (String)Reflection.invoke(ChannelHandler.this.delegate, method, args);
                        if (args.length > 3) {
                            args[2] = consumerTag;
                        }
                        ChannelHandler.this.consumerInvocations.put(consumerTag, new Invocation(method, args));
                        ChannelHandler.this.log.info("Created consumer-{} of {} via {}", new Object[]{consumerTag, args[0], ChannelHandler.this});
                        return consumerTag;
                    }
                    if ("basicCancel".equals(methodName) && args[0] != null) {
                        ChannelHandler.this.consumerInvocations.remove((String)args[0]);
                    }
                }
                Object result = Reflection.invoke(ChannelHandler.this.delegate, method, args);
                if ("flow".equals(methodName)) {
                    ChannelHandler.this.flowDisabled = (Boolean)args[0] == false;
                    return result;
                } else if ("basicQos".equals(methodName)) {
                    if (args.length >= 3 && ((Boolean)args[2]).booleanValue()) return result;
                    ChannelHandler.this.basicQos = new Invocation(method, args);
                    return result;
                } else if ("confirmSelect".equals(methodName)) {
                    ChannelHandler.this.confirmSelect = true;
                    return result;
                } else if ("txSelect".equals(methodName)) {
                    ChannelHandler.this.txSelect = true;
                    return result;
                } else if ("addConfirmListener".equals(methodName)) {
                    ChannelHandler.this.confirmListeners.add((ConfirmListener)args[0]);
                    return result;
                } else if ("addFlowListener".equals(methodName)) {
                    ChannelHandler.this.flowListeners.add((FlowListener)args[0]);
                    return result;
                } else if ("addReturnListener".equals(methodName)) {
                    ChannelHandler.this.returnListeners.add((ReturnListener)args[0]);
                    return result;
                } else if ("removeConfirmListener".equals(methodName)) {
                    ChannelHandler.this.confirmListeners.remove((ConfirmListener)args[0]);
                    return result;
                } else if ("removeFlowListener".equals(methodName)) {
                    ChannelHandler.this.flowListeners.remove((FlowListener)args[0]);
                    return result;
                } else if ("removeReturnListener".equals(methodName)) {
                    ChannelHandler.this.returnListeners.remove((ReturnListener)args[0]);
                    return result;
                } else if ("clearConfirmListeners".equals(methodName)) {
                    ChannelHandler.this.confirmListeners.clear();
                    return result;
                } else if ("clearFlowListeners".equals(methodName)) {
                    ChannelHandler.this.flowListeners.clear();
                    return result;
                } else {
                    if (!"clearReturnListeners".equals(methodName)) return result;
                    ChannelHandler.this.returnListeners.clear();
                }
                return result;
            }

            public String toString() {
                return Reflection.toString(method);
            }
        };
        return this.handleCommonMethods(this.delegate, method, args) ? null : this.callWithRetries(callable, this.config.getChannelRetryPolicy(), null, this.canRecover(), true);
    }

    public String toString() {
        return String.format("channel-%s on %s", this.delegate.getChannelNumber(), this.connectionHandler);
    }

    @Override
    void afterClosure() {
        this.connectionHandler.removeChannel(this.delegate.getChannelNumber());
    }

    boolean canRecover() {
        return this.connectionHandler.canRecover() && this.config.getChannelRecoveryPolicy() != null && this.config.getChannelRecoveryPolicy().allowsAttempts();
    }

    synchronized void recoverChannel(boolean returnOnFailedRecovery) throws Exception {
        block13: {
            this.recoveryPending.set(false);
            if (this.circuit.isClosed()) {
                return;
            }
            if (this.recoveryStats == null) {
                this.recoveryConsumers = this.consumerInvocations.isEmpty() ? null : new HashMap<String, Invocation>(this.consumerInvocations);
                this.recoveryStats = new RecurringStats(this.config.getChannelRecoveryPolicy());
                this.recoveryStats.incrementTime();
            } else if (this.recoveryStats.isPolicyExceeded()) {
                this.recoveryFailed((Exception)this.lastShutdownSignal);
                if (returnOnFailedRecovery) {
                    return;
                }
            }
            try {
                this.delegate = this.callWithRetries(new Callable<Channel>(){

                    @Override
                    public Channel call() throws Exception {
                        ChannelHandler.this.log.info("Recovering {}", (Object)ChannelHandler.this);
                        ChannelHandler.this.previousMaxDeliveryTag = ChannelHandler.this.maxDeliveryTag;
                        Channel channel = ChannelHandler.this.connectionHandler.createChannel(ChannelHandler.this.delegate.getChannelNumber());
                        ChannelHandler.this.migrateConfiguration(channel);
                        return channel;
                    }
                }, this.config.getChannelRecoveryPolicy(), this.recoveryStats, true, false);
                for (ChannelListener listener : this.config.getChannelListeners()) {
                    try {
                        if (this.recoveryPending.get()) continue;
                        listener.onRecovery(this.proxy);
                    }
                    catch (Exception ignore) {}
                }
                if (this.config.isConsumerRecoveryEnabled() && !this.recoveryPending.get()) {
                    this.recoverConsumers(this.recoveryConsumers);
                }
                this.recoverySucceeded();
            }
            catch (Exception e) {
                ShutdownSignalException sse = Exceptions.extractCause(e, ShutdownSignalException.class);
                if (sse != null) {
                    if (Exceptions.isConnectionClosure(sse)) {
                        throw e;
                    }
                }
                if (!this.recoveryStats.isPolicyExceeded()) break block13;
                this.recoveryFailed(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void resourceClosed() {
        this.circuit.open();
        Map<String, Invocation> map = this.consumerInvocations;
        synchronized (map) {
            for (Invocation invocation : this.consumerInvocations.values()) {
                ((ConsumerDelegate)invocation.args[invocation.args.length - 1]).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateConfiguration(Channel channel) throws Exception {
        channel.setDefaultConsumer(this.delegate.getDefaultConsumer());
        if (this.flowDisabled) {
            channel.flow(false);
        }
        if (this.basicQos != null) {
            Reflection.invoke(channel, this.basicQos.method, this.basicQos.args);
        }
        if (this.confirmSelect) {
            channel.confirmSelect();
        }
        if (this.txSelect) {
            channel.txSelect();
        }
        List list = this.shutdownListeners;
        synchronized (list) {
            for (ShutdownListener listener : this.shutdownListeners) {
                channel.addShutdownListener(listener);
            }
        }
        for (ConfirmListener confirmListener : this.confirmListeners) {
            channel.addConfirmListener(confirmListener);
        }
        for (FlowListener flowListener : this.flowListeners) {
            channel.addFlowListener(flowListener);
        }
        for (ReturnListener returnListener : this.returnListeners) {
            channel.addReturnListener(returnListener);
        }
    }

    private void recoverConsumers(Map<String, Invocation> consumers) throws Exception {
        if (consumers != null) {
            Iterator<Map.Entry<String, Invocation>> it = consumers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Invocation> entry = it.next();
                Object[] args = entry.getValue().args;
                ConsumerDelegate consumer = (ConsumerDelegate)args[args.length - 1];
                try {
                    for (ConsumerListener listener : this.config.getConsumerListeners()) {
                        try {
                            listener.onBeforeRecovery(consumer, this.proxy);
                        }
                        catch (Exception ignore) {}
                    }
                    this.log.info("Recovering consumer-{} via {}", (Object)entry.getKey(), (Object)this);
                    consumer.open();
                    Reflection.invoke(this.delegate, entry.getValue().method, entry.getValue().args);
                    for (ConsumerListener listener : this.config.getConsumerListeners()) {
                        try {
                            listener.onAfterRecovery(consumer, this.proxy);
                        }
                        catch (Exception ignore) {}
                    }
                }
                catch (Exception e) {
                    ShutdownSignalException sse = Exceptions.extractCause(e, ShutdownSignalException.class);
                    this.log.error("Failed to recover consumer-{} via {}", new Object[]{entry.getKey(), this, e});
                    for (ConsumerListener listener : this.config.getConsumerListeners()) {
                        try {
                            listener.onRecoveryFailure(consumer, this.proxy, e);
                        }
                        catch (Exception ignore) {}
                    }
                    if (sse == null) continue;
                    if (!Exceptions.isConnectionClosure(sse)) {
                        it.remove();
                    }
                    throw e;
                }
            }
        }
        for (ChannelListener listener : this.config.getChannelListeners()) {
            try {
                listener.onConsumerRecovery(this.proxy);
            }
            catch (Exception ignore) {}
        }
    }

    private void recoveryComplete() {
        this.recoveryStats = null;
        this.recoveryConsumers = null;
        this.lastShutdownSignal = null;
    }

    private void recoveryFailed(Exception e) {
        this.log.error("Failed to recover {}", (Object)this, (Object)e);
        this.recoveryComplete();
        this.interruptWaiters();
        for (ChannelListener listener : this.config.getChannelListeners()) {
            try {
                listener.onRecoveryFailure(this.proxy, e);
            }
            catch (Exception ignore) {}
        }
    }

    private void recoverySucceeded() {
        if (!this.recoveryPending.get()) {
            this.recoveryComplete();
            this.circuit.close();
        }
    }

    private class ChannelShutdownListener
    implements ShutdownListener {
        private ChannelShutdownListener() {
        }

        public void shutdownCompleted(ShutdownSignalException e) {
            ChannelHandler.this.resourceClosed();
            if (!e.isInitiatedByApplication()) {
                ChannelHandler.this.log.error("Channel {} was closed unexpectedly", (Object)ChannelHandler.this);
                ChannelHandler.this.lastShutdownSignal = e;
                if (!Exceptions.isConnectionClosure(e) && ChannelHandler.this.canRecover()) {
                    ConnectionHandler.RECOVERY_EXECUTORS.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ChannelHandler.this.recoveryPending.set(true);
                                ChannelHandler.this.recoverChannel(true);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        }
    }
}

