/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.retry;

import net.jodah.lyra.internal.util.Assert;
import net.jodah.lyra.util.Duration;

public class RetryPolicy {
    private int maxRetries = -1;
    private Duration maxDuration;
    private Duration retryInterval;
    private Duration maxRetryInterval;
    private int retryIntervalMultiplier;

    public boolean allowsRetries() {
        return !(this.maxRetries != -1 && this.maxRetries <= 0 || this.maxDuration != null && this.maxDuration.length <= 0L);
    }

    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Duration getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public Duration getRetryInterval() {
        return this.retryInterval;
    }

    public int getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    public RetryPolicy withBackoff(Duration retryInterval, Duration maxRetryInterval) {
        return this.withBackoff(retryInterval, maxRetryInterval, 2);
    }

    public RetryPolicy withBackoff(Duration retryInterval, Duration maxRetryInterval, int retryIntervalMultiplier) {
        Assert.notNull(retryInterval, "retryInterval");
        Assert.notNull(maxRetryInterval, "maxRetryInterval");
        Assert.isTrue(retryInterval.length > 0L, "The retryInterval must be greater than 0", new Object[0]);
        Assert.isTrue(retryInterval.length < maxRetryInterval.length, "The retryInterval must be less than the maxRetryInterval", new Object[0]);
        Assert.isTrue(retryIntervalMultiplier > 1, "The retryIntervalMultiplier must be greater than 1", new Object[0]);
        this.retryInterval = retryInterval;
        this.maxRetryInterval = maxRetryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        return this;
    }

    public RetryPolicy withMaxDuration(Duration maxDuration) {
        Assert.notNull(maxDuration, "maxDuration");
        this.maxDuration = maxDuration;
        return this;
    }

    public RetryPolicy withMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public RetryPolicy withRetryInterval(Duration retryInterval) {
        Assert.notNull(retryInterval, "retryInterval");
        Assert.state(this.maxRetryInterval == null, "Backoff intervals have already been set", new Object[0]);
        this.retryInterval = retryInterval;
        return this;
    }
}

