/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.internal;

import net.jodah.lyra.retry.RetryPolicy;
import net.jodah.lyra.util.Duration;

public final class RetryStats {
    private final int maxRetries;
    private final long maxDuration;
    private final long retryInterval;
    private long startTime;
    private double retryIntervalMultiplier = -1.0;
    private long maxRetryInterval;
    private int retryCount;
    private long waitTime;
    private long maxWaitTime;

    public RetryStats(RetryPolicy retryPolicy) {
        this.maxRetries = retryPolicy.getMaxRetries();
        long l = this.retryInterval = retryPolicy.getRetryInterval() == null ? 0L : retryPolicy.getRetryInterval().toNanos();
        if (retryPolicy.getMaxDuration() == null) {
            this.maxDuration = -1L;
            this.waitTime = this.retryInterval;
            this.maxWaitTime = -1L;
        } else {
            this.maxDuration = retryPolicy.getMaxDuration().toNanos();
            this.waitTime = Math.min(this.retryInterval, this.maxDuration);
            this.maxWaitTime = this.maxDuration;
        }
        if (retryPolicy.getMaxRetryInterval() != null) {
            this.retryIntervalMultiplier = retryPolicy.getRetryIntervalMultiplier();
            this.maxRetryInterval = retryPolicy.getMaxRetryInterval().toNanos();
        }
    }

    public boolean canRetryForUpdatedStats() {
        ++this.retryCount;
        long now = System.nanoTime();
        if (this.startTime == 0L) {
            this.startTime = now;
        } else if (this.retryIntervalMultiplier != -1.0) {
            this.waitTime = Math.min(this.maxRetryInterval, (long)((double)this.waitTime * this.retryIntervalMultiplier));
        }
        long elapsedNanos = now - this.startTime;
        if (this.maxDuration != -1L) {
            this.waitTime = Math.min(this.waitTime, this.maxDuration - elapsedNanos);
            this.maxWaitTime = this.maxDuration - elapsedNanos;
        }
        boolean withinMaxRetries = this.maxRetries == -1 || this.retryCount <= this.maxRetries;
        boolean withinMaxDuration = this.maxDuration == -1L || elapsedNanos <= this.maxDuration;
        return withinMaxRetries && withinMaxDuration;
    }

    public Duration getWaitTime() {
        return Duration.nanos(this.waitTime);
    }

    public Duration getMaxWaitTime() {
        return this.maxWaitTime == -1L ? Duration.inf() : Duration.nanos(this.maxWaitTime);
    }
}

