/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.FailsafeExecutor;
import net.jodah.failsafe.FailsafeFuture;
import net.jodah.failsafe.Functions;
import net.jodah.failsafe.PolicyExecutor;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.concurrent.Scheduler;

public final class AsyncExecution
extends AbstractExecution {
    private Functions.SettableSupplier<CompletableFuture<ExecutionResult>> innerExecutionSupplier;
    private Supplier<CompletableFuture<ExecutionResult>> outerExecutionSupplier;
    final FailsafeFuture<Object> future;
    private volatile boolean completeCalled;
    private volatile boolean retryCalled;

    <T> AsyncExecution(Scheduler scheduler, FailsafeFuture<T> future, FailsafeExecutor<?> executor) {
        super(scheduler, executor);
        this.future = future;
    }

    void inject(Supplier<CompletableFuture<ExecutionResult>> syncSupplier, boolean asyncExecution) {
        if (!asyncExecution) {
            this.outerExecutionSupplier = Functions.getPromiseAsync(syncSupplier, this.scheduler, this);
        } else {
            this.innerExecutionSupplier = Functions.toSettableSupplier(syncSupplier);
            this.outerExecutionSupplier = this.innerExecutionSupplier;
        }
        for (PolicyExecutor policyExecutor : this.policyExecutors) {
            this.outerExecutionSupplier = policyExecutor.supplyAsync(this.outerExecutionSupplier, this.scheduler, this.future);
        }
    }

    public void complete() {
        this.postExecute(ExecutionResult.NONE);
    }

    public boolean complete(Object result) {
        this.postExecute(new ExecutionResult(result, null));
        return this.completed;
    }

    public boolean complete(Object result, Throwable failure) {
        this.postExecute(new ExecutionResult(result, failure));
        return this.completed;
    }

    public boolean retry() {
        return this.retryFor(this.lastResult, this.lastFailure);
    }

    public boolean retryFor(Object result) {
        return this.retryFor(result, null);
    }

    public boolean retryFor(Object result, Throwable failure) {
        Assert.state(!this.retryCalled, "Retry has already been called", new Object[0]);
        this.retryCalled = true;
        return !this.completeOrHandle(result, failure);
    }

    public boolean retryOn(Throwable failure) {
        Assert.notNull(failure, "failure");
        return this.retryFor(null, failure);
    }

    @Override
    void preExecute() {
        super.preExecute();
        this.completeCalled = false;
        this.retryCalled = false;
    }

    @Override
    boolean isAsyncExecution() {
        return this.innerExecutionSupplier != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ExecutionResult postExecute(ExecutionResult result) {
        FailsafeFuture<Object> failsafeFuture = this.future;
        synchronized (failsafeFuture) {
            if (!this.completeCalled) {
                result = super.postExecute(result);
                if (this.completed) {
                    this.complete(result, null);
                }
                this.completeCalled = true;
                this.resultHandled = true;
            }
            return result;
        }
    }

    void executeAsync(boolean asyncExecution) {
        if (!asyncExecution) {
            this.outerExecutionSupplier.get().whenComplete(this::complete);
        } else {
            ScheduledFuture<?> scheduledSupply = this.scheduler.schedule(this.innerExecutionSupplier::get, 0L, TimeUnit.NANOSECONDS);
            this.future.injectCancelFn((mayInterrupt, result) -> scheduledSupply.cancel((boolean)mayInterrupt));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean completeOrHandle(Object result, Throwable failure) {
        FailsafeFuture<Object> failsafeFuture = this.future;
        synchronized (failsafeFuture) {
            ExecutionResult er = new ExecutionResult(result, failure).withWaitNanos(this.waitNanos);
            if (!this.completeCalled) {
                this.record(er);
            }
            this.completeCalled = true;
            this.innerExecutionSupplier.set(CompletableFuture.completedFuture(er));
            this.outerExecutionSupplier.get().whenComplete(this::complete);
            return this.completed;
        }
    }

    private void complete(ExecutionResult result, Throwable error) {
        if (result == null && error == null) {
            return;
        }
        this.completed = true;
        if (!this.future.isDone()) {
            if (result != null) {
                this.future.completeResult(result);
            } else {
                if (error instanceof CompletionException) {
                    error = error.getCause();
                }
                this.future.completeResult(ExecutionResult.failure(error));
            }
        }
    }
}

