/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.time.Duration;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.FailurePolicy;
import net.jodah.failsafe.function.DelayFunction;
import net.jodah.failsafe.internal.util.Assert;

public abstract class DelayablePolicy<S, R>
extends FailurePolicy<S, R> {
    protected DelayFunction<R, ? extends Throwable> delayFn;
    protected Object delayResult;
    protected Class<? extends Throwable> delayFailure;

    public DelayFunction<R, ? extends Throwable> getDelayFn() {
        return this.delayFn;
    }

    public S withDelay(DelayFunction<R, ? extends Throwable> delayFunction) {
        Assert.notNull(delayFunction, "delayFunction");
        this.delayFn = delayFunction;
        return (S)this;
    }

    public <F extends Throwable> S withDelayOn(DelayFunction<R, F> delayFunction, Class<F> failure) {
        this.withDelay(delayFunction);
        Assert.notNull(failure, "failure");
        this.delayFailure = failure;
        return (S)this;
    }

    public S withDelayWhen(DelayFunction<R, ? extends Throwable> delayFunction, R result) {
        this.withDelay(delayFunction);
        Assert.notNull(result, "result");
        this.delayResult = result;
        return (S)this;
    }

    public Duration computeDelay(ExecutionContext context) {
        Duration computed = null;
        if (context != null && this.delayFn != null) {
            Object exResult = context.getLastResult();
            Object exFailure = context.getLastFailure();
            if ((this.delayResult == null || this.delayResult.equals(exResult)) && (this.delayFailure == null || exFailure != null && this.delayFailure.isAssignableFrom(exFailure.getClass()))) {
                computed = this.delayFn.computeDelay(exResult, (Throwable)exFailure, context);
            }
        }
        return computed != null && !computed.isNegative() ? computed : null;
    }
}

