/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal.executor;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.FailsafeFuture;
import net.jodah.failsafe.PolicyExecutor;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.internal.EventListener;
import net.jodah.failsafe.internal.util.RandomDelay;
import net.jodah.failsafe.util.concurrent.Scheduler;

public class RetryPolicyExecutor
extends PolicyExecutor<RetryPolicy> {
    private volatile int failedAttempts;
    private volatile boolean retriesExceeded;
    private volatile long delayNanos = -1L;
    private EventListener abortListener;
    private EventListener failedAttemptListener;
    private EventListener retriesExceededListener;
    private EventListener retryListener;

    public RetryPolicyExecutor(RetryPolicy retryPolicy, AbstractExecution execution, EventListener abortListener, EventListener failedAttemptListener, EventListener retriesExceededListener, EventListener retryListener) {
        super(retryPolicy, execution);
        this.abortListener = abortListener;
        this.failedAttemptListener = failedAttemptListener;
        this.retriesExceededListener = retriesExceededListener;
        this.retryListener = retryListener;
    }

    @Override
    protected Supplier<ExecutionResult> supply(Supplier<ExecutionResult> supplier) {
        return () -> {
            while (true) {
                ExecutionResult result = (ExecutionResult)supplier.get();
                if (this.retriesExceeded) {
                    return result;
                }
                if ((result = this.postExecute(result)).isComplete()) {
                    return result;
                }
                try {
                    Thread.sleep(TimeUnit.NANOSECONDS.toMillis(result.getWaitNanos()));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return ExecutionResult.failure(new FailsafeException(e));
                }
                if (this.retryListener == null) continue;
                this.retryListener.handle(result, this.execution);
            }
        };
    }

    @Override
    protected Supplier<CompletableFuture<ExecutionResult>> supplyAsync(final Supplier<CompletableFuture<ExecutionResult>> supplier, final Scheduler scheduler, final FailsafeFuture<Object> future) {
        return () -> {
            final CompletableFuture promise = new CompletableFuture();
            Callable<Object> callable = new Callable<Object>(){
                volatile ExecutionResult previousResult;

                @Override
                public Object call() {
                    if (RetryPolicyExecutor.this.retryListener != null && this.previousResult != null) {
                        RetryPolicyExecutor.this.retryListener.handle(this.previousResult, RetryPolicyExecutor.this.execution);
                    }
                    return ((CompletableFuture)supplier.get()).handle((result, error) -> {
                        if (result != null) {
                            Consumer<ExecutionResult> postExecutionHandler = postResult -> {
                                if (RetryPolicyExecutor.this.retriesExceeded || postResult.isComplete()) {
                                    promise.complete(postResult);
                                } else if (!future.isDone() && !future.isCancelled()) {
                                    try {
                                        this.previousResult = postResult;
                                        future.inject(scheduler.schedule(this, postResult.getWaitNanos(), TimeUnit.NANOSECONDS));
                                    }
                                    catch (Exception e) {
                                        promise.completeExceptionally(e);
                                    }
                                }
                            };
                            if (!RetryPolicyExecutor.this.retriesExceeded) {
                                RetryPolicyExecutor.this.postExecuteAsync(result, scheduler, future).thenAccept(postExecutionHandler);
                            } else {
                                postExecutionHandler.accept((ExecutionResult)result);
                            }
                        } else if (error != null) {
                            promise.completeExceptionally((Throwable)error);
                        } else {
                            promise.complete(null);
                        }
                        return result;
                    });
                }
            };
            try {
                callable.call();
            }
            catch (Throwable t) {
                promise.completeExceptionally(t);
            }
            return promise;
        };
    }

    @Override
    protected ExecutionResult onFailure(ExecutionResult result) {
        boolean success;
        long maxRemainingWaitTime;
        long waitNanos;
        Duration computedDelay;
        ++this.failedAttempts;
        long computedDelayNanos = -1L;
        RetryPolicy.DelayFunction<Object, Throwable> delayFunction = ((RetryPolicy)this.policy).getDelayFn();
        if (delayFunction != null && ((RetryPolicy)this.policy).canApplyDelayFn(result.getResult(), result.getFailure()) && (computedDelay = delayFunction.computeDelay(result.getResult(), result.getFailure(), this.execution)) != null && computedDelay.toNanos() >= 0L) {
            computedDelayNanos = computedDelay.toNanos();
        }
        if (computedDelayNanos == -1L) {
            Duration delay = ((RetryPolicy)this.policy).getDelay();
            Duration delayMin = ((RetryPolicy)this.policy).getDelayMin();
            Duration delayMax = ((RetryPolicy)this.policy).getDelayMax();
            if (this.delayNanos == -1L && delay != null && !delay.equals(Duration.ZERO)) {
                this.delayNanos = delay.toNanos();
            } else if (delayMin != null && delayMax != null) {
                this.delayNanos = RandomDelay.randomDelayInRange(delayMin.toNanos(), delayMin.toNanos(), Math.random());
            }
            if (this.execution.getAttemptCount() != 1 && ((RetryPolicy)this.policy).getMaxDelay() != null) {
                this.delayNanos = (long)Math.min((double)this.delayNanos * ((RetryPolicy)this.policy).getDelayFactor(), (double)((RetryPolicy)this.policy).getMaxDelay().toNanos());
            }
        }
        long l = waitNanos = computedDelayNanos != -1L ? computedDelayNanos : this.delayNanos;
        if (((RetryPolicy)this.policy).getJitter() != null) {
            waitNanos = RandomDelay.randomDelay(waitNanos, ((RetryPolicy)this.policy).getJitter().toNanos(), Math.random());
        } else if (((RetryPolicy)this.policy).getJitterFactor() > 0.0) {
            waitNanos = RandomDelay.randomDelay(waitNanos, ((RetryPolicy)this.policy).getJitterFactor(), Math.random());
        }
        long elapsedNanos = this.execution.getElapsedTime().toNanos();
        if (((RetryPolicy)this.policy).getMaxDuration() != null && (waitNanos = Math.min(waitNanos, (maxRemainingWaitTime = ((RetryPolicy)this.policy).getMaxDuration().toNanos() - elapsedNanos) < 0L ? 0L : maxRemainingWaitTime)) < 0L) {
            waitNanos = 0L;
        }
        boolean maxRetriesExceeded = ((RetryPolicy)this.policy).getMaxRetries() != -1 && this.failedAttempts > ((RetryPolicy)this.policy).getMaxRetries();
        boolean maxDurationExceeded = ((RetryPolicy)this.policy).getMaxDuration() != null && elapsedNanos > ((RetryPolicy)this.policy).getMaxDuration().toNanos();
        this.retriesExceeded = maxRetriesExceeded || maxDurationExceeded;
        boolean isAbortable = ((RetryPolicy)this.policy).isAbortable(result.getResult(), result.getFailure());
        boolean shouldRetry = !result.isSuccess() && !isAbortable && !this.retriesExceeded && ((RetryPolicy)this.policy).allowsRetries();
        boolean completed = isAbortable || !shouldRetry;
        boolean bl = success = completed && result.isSuccess() && !isAbortable;
        if (this.failedAttemptListener != null && !success) {
            this.failedAttemptListener.handle(result, this.execution);
        }
        if (this.abortListener != null && isAbortable) {
            this.abortListener.handle(result, this.execution);
        } else if (this.retriesExceededListener != null && !success && this.retriesExceeded) {
            this.retriesExceededListener.handle(result, this.execution);
        }
        return result.with(waitNanos, completed, success);
    }
}

