/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.Predicates;
import net.jodah.failsafe.function.BiPredicate;
import net.jodah.failsafe.function.Predicate;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.Duration;

public class RetryPolicy {
    static final RetryPolicy NEVER = new RetryPolicy().withMaxRetries(0);
    private Duration delay;
    private Duration delayMin;
    private Duration delayMax;
    private double delayFactor;
    private Duration maxDelay;
    private DelayFunction<?, ? extends Throwable> delayFn;
    private Object delayResult;
    private Class<? extends Throwable> delayFailure;
    private Duration jitter;
    private double jitterFactor;
    private Duration maxDuration;
    private int maxRetries;
    private boolean failuresChecked;
    private List<BiPredicate<Object, Throwable>> retryConditions;
    private List<BiPredicate<Object, Throwable>> abortConditions;

    public RetryPolicy() {
        this.delay = Duration.NONE;
        this.maxRetries = -1;
        this.retryConditions = new ArrayList<BiPredicate<Object, Throwable>>();
        this.abortConditions = new ArrayList<BiPredicate<Object, Throwable>>();
    }

    public RetryPolicy(RetryPolicy rp) {
        this.delay = rp.delay;
        this.delayFactor = rp.delayFactor;
        this.maxDelay = rp.maxDelay;
        this.maxDuration = rp.maxDuration;
        this.maxRetries = rp.maxRetries;
        this.jitter = rp.jitter;
        this.jitterFactor = rp.jitterFactor;
        this.failuresChecked = rp.failuresChecked;
        this.retryConditions = new ArrayList<BiPredicate<Object, Throwable>>(rp.retryConditions);
        this.abortConditions = new ArrayList<BiPredicate<Object, Throwable>>(rp.abortConditions);
    }

    public <T> RetryPolicy abortIf(BiPredicate<T, ? extends Throwable> completionPredicate) {
        Assert.notNull(completionPredicate, "completionPredicate");
        this.abortConditions.add(completionPredicate);
        return this;
    }

    public <T> RetryPolicy abortIf(Predicate<T> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        this.abortConditions.add(Predicates.resultPredicateFor(resultPredicate));
        return this;
    }

    public RetryPolicy abortOn(Class<? extends Throwable> failure) {
        Assert.notNull(failure, "failure");
        return this.abortOn(Arrays.asList(failure));
    }

    public RetryPolicy abortOn(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "Failures cannot be empty", new Object[0]);
        return this.abortOn(Arrays.asList(failures));
    }

    public RetryPolicy abortOn(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        this.abortConditions.add(Predicates.failurePredicateFor(failures));
        return this;
    }

    public RetryPolicy abortOn(Predicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        this.abortConditions.add(Predicates.failurePredicateFor(failurePredicate));
        return this;
    }

    public RetryPolicy abortWhen(Object result) {
        this.abortConditions.add(Predicates.resultPredicateFor(result));
        return this;
    }

    public boolean allowsRetries() {
        return !(this.maxRetries != -1 && this.maxRetries <= 0 || this.maxDuration != null && this.maxDuration.toNanos() <= 0L);
    }

    public boolean canAbortFor(Object result, Throwable failure) {
        for (BiPredicate<Object, Throwable> predicate : this.abortConditions) {
            try {
                if (!predicate.test(result, failure)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public boolean canRetryFor(Object result, Throwable failure) {
        for (BiPredicate<Object, Throwable> predicate : this.retryConditions) {
            try {
                if (!predicate.test(result, failure)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return failure != null && !this.failuresChecked;
    }

    public boolean canApplyDelayFn(Object result, Throwable failure) {
        return (this.delayResult == null || this.delayResult.equals(result)) && (this.delayFailure == null || failure != null && this.delayFailure.isAssignableFrom(failure.getClass()));
    }

    public RetryPolicy copy() {
        return new RetryPolicy(this);
    }

    public Duration getDelay() {
        return this.delay;
    }

    public Duration getDelayMin() {
        return this.delayMin;
    }

    public Duration getDelayMax() {
        return this.delayMax;
    }

    public DelayFunction<?, ? extends Throwable> getDelayFn() {
        return this.delayFn;
    }

    public double getDelayFactor() {
        return this.delayFactor;
    }

    public Duration getJitter() {
        return this.jitter;
    }

    public double getJitterFactor() {
        return this.jitterFactor;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public <T> RetryPolicy retryIf(BiPredicate<T, ? extends Throwable> completionPredicate) {
        Assert.notNull(completionPredicate, "completionPredicate");
        this.failuresChecked = true;
        this.retryConditions.add(completionPredicate);
        return this;
    }

    public <T> RetryPolicy retryIf(Predicate<T> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        this.retryConditions.add(Predicates.resultPredicateFor(resultPredicate));
        return this;
    }

    public RetryPolicy retryOn(Class<? extends Throwable> failure) {
        Assert.notNull(failure, "failure");
        return this.retryOn(Arrays.asList(failure));
    }

    public RetryPolicy retryOn(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "Failures cannot be empty", new Object[0]);
        return this.retryOn(Arrays.asList(failures));
    }

    public RetryPolicy retryOn(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        this.failuresChecked = true;
        this.retryConditions.add(Predicates.failurePredicateFor(failures));
        return this;
    }

    public RetryPolicy retryOn(Predicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        this.failuresChecked = true;
        this.retryConditions.add(Predicates.failurePredicateFor(failurePredicate));
        return this;
    }

    public RetryPolicy retryWhen(Object result) {
        this.retryConditions.add(Predicates.resultPredicateFor(result));
        return this;
    }

    public RetryPolicy withBackoff(long delay, long maxDelay, TimeUnit timeUnit) {
        return this.withBackoff(delay, maxDelay, timeUnit, 2.0);
    }

    public RetryPolicy withBackoff(long delay, long maxDelay, TimeUnit timeUnit, double delayFactor) {
        Assert.notNull(timeUnit, "timeUnit");
        Assert.isTrue(timeUnit.toNanos(delay) > 0L, "The delay must be greater than 0", new Object[0]);
        Assert.state(this.maxDuration == null || timeUnit.toNanos(delay) < this.maxDuration.toNanos(), "delay must be less than the maxDuration", new Object[0]);
        Assert.isTrue(timeUnit.toNanos(delay) < timeUnit.toNanos(maxDelay), "delay must be less than the maxDelay", new Object[0]);
        Assert.isTrue(delayFactor > 1.0, "delayFactor must be greater than 1", new Object[0]);
        Assert.state(this.delay == null || this.delay.equals(Duration.NONE), "Delays have already been set", new Object[0]);
        Assert.state(this.delayMin == null, "Random delays have already been set", new Object[0]);
        this.delay = new Duration(delay, timeUnit);
        this.maxDelay = new Duration(maxDelay, timeUnit);
        this.delayFactor = delayFactor;
        return this;
    }

    public RetryPolicy withDelay(long delay, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        Assert.isTrue(timeUnit.toNanos(delay) > 0L, "delay must be greater than 0", new Object[0]);
        Assert.state(this.maxDuration == null || timeUnit.toNanos(delay) < this.maxDuration.toNanos(), "delay must be less than the maxDuration", new Object[0]);
        Assert.state(this.delayMin == null, "Random delays have already been set", new Object[0]);
        Assert.state(this.maxDelay == null, "Backoff delays have already been set", new Object[0]);
        this.delay = new Duration(delay, timeUnit);
        return this;
    }

    public RetryPolicy withDelay(long delayMin, long delayMax, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        Assert.isTrue(timeUnit.toNanos(delayMin) > 0L, "delayMin must be greater than 0", new Object[0]);
        Assert.isTrue(timeUnit.toNanos(delayMax) > 0L, "delayMax must be greater than 0", new Object[0]);
        Assert.isTrue(timeUnit.toNanos(delayMin) < timeUnit.toNanos(delayMax), "delayMin must be less than delayMax", new Object[0]);
        Assert.state(this.maxDuration == null || timeUnit.toNanos(delayMax) < this.maxDuration.toNanos(), "delayMax must be less than the maxDuration", new Object[0]);
        Assert.state(this.delay == null || this.delay.equals(Duration.NONE), "Delays have already been set", new Object[0]);
        Assert.state(this.maxDelay == null, "Backoff delays have already been set", new Object[0]);
        this.delayMin = new Duration(delayMin, timeUnit);
        this.delayMax = new Duration(delayMax, timeUnit);
        return this;
    }

    public RetryPolicy withDelay(DelayFunction<?, ? extends Throwable> delayFunction) {
        Assert.notNull(delayFunction, "delayFunction");
        this.delayFn = delayFunction;
        return this;
    }

    public <F extends Throwable> RetryPolicy withDelayOn(DelayFunction<Object, F> delayFunction, Class<F> failure) {
        this.withDelay(delayFunction);
        Assert.notNull(failure, "failure");
        this.delayFailure = failure;
        return this;
    }

    public <R> RetryPolicy withDelayWhen(DelayFunction<R, ? extends Throwable> delayFunction, R result) {
        this.withDelay(delayFunction);
        Assert.notNull(result, "result");
        this.delayResult = result;
        return this;
    }

    public RetryPolicy withJitter(double jitterFactor) {
        Assert.isTrue(jitterFactor >= 0.0 && jitterFactor <= 1.0, "jitterFactor must be >= 0 and <= 1", new Object[0]);
        Assert.state(this.delay != null || this.delayMin != null, "A delay must be configured", new Object[0]);
        Assert.state(this.jitter == null, "withJitter(long, timeUnit) has already been called", new Object[0]);
        this.jitterFactor = jitterFactor;
        return this;
    }

    public RetryPolicy withJitter(long jitter, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        Assert.isTrue(jitter > 0L, "jitter must be > 0", new Object[0]);
        Assert.state(this.delay != null || this.delayMin != null, "A delay must be configured", new Object[0]);
        Assert.state(this.jitterFactor == 0.0, "withJitter(double) has already been called", new Object[0]);
        Assert.state(timeUnit.toNanos(jitter) <= this.delay.toNanos(), "jitter must be less than the configured delay", new Object[0]);
        this.jitter = new Duration(jitter, timeUnit);
        return this;
    }

    public RetryPolicy withMaxDuration(long maxDuration, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        Assert.state(timeUnit.toNanos(maxDuration) > this.delay.toNanos(), "maxDuration must be greater than the delay", new Object[0]);
        this.maxDuration = new Duration(maxDuration, timeUnit);
        return this;
    }

    public RetryPolicy withMaxRetries(int maxRetries) {
        Assert.isTrue(maxRetries >= -1, "maxRetries must be greater than or equal to -1", new Object[0]);
        this.maxRetries = maxRetries;
        return this;
    }

    @FunctionalInterface
    public static interface DelayFunction<R, F extends Throwable> {
        public Duration computeDelay(R var1, F var2, ExecutionContext var3);
    }
}

