/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.util;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class Duration {
    public static final Duration NONE = new Duration(0L, TimeUnit.MILLISECONDS);
    private final long length;
    private final TimeUnit timeUnit;

    public Duration(long length, TimeUnit timeUnit) {
        this.length = length;
        this.timeUnit = timeUnit;
    }

    public boolean equals(Object o) {
        return this == o || Duration.class.isInstance(o) && this.toNanos() == ((Duration)Duration.class.cast(o)).toNanos();
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.toNanos(), TimeUnit.NANOSECONDS});
    }

    public String toString() {
        return this.length + " " + this.timeUnit.toString().toLowerCase();
    }

    public long toNanos() {
        return this.timeUnit.toNanos(this.length);
    }

    public long toMillis() {
        return this.timeUnit.toMillis(this.length);
    }

    public long toSeconds() {
        return this.timeUnit.toSeconds(this.length);
    }

    public long toMinutes() {
        return this.timeUnit.toMinutes(this.length);
    }

    public long toHours() {
        return this.timeUnit.toHours(this.length);
    }

    public long toDays() {
        return this.timeUnit.toDays(this.length);
    }
}

