/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.FailsafeConfig;
import net.jodah.failsafe.function.CheckedBiFunction;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.internal.util.ReentrantCircuit;

public class FailsafeFuture<T>
implements Future<T> {
    private final ReentrantCircuit circuit = new ReentrantCircuit();
    private final FailsafeConfig<T, ?> config;
    private ExecutionContext execution;
    private CompletableFuture<T> completableFuture;
    private volatile Future<T> delegate;
    private volatile boolean done;
    private volatile boolean cancelled;
    private volatile T result;
    private volatile Throwable failure;

    FailsafeFuture(FailsafeConfig<T, ?> config) {
        this.config = config;
        this.circuit.open();
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.done) {
            return false;
        }
        boolean cancelResult = this.delegate.cancel(mayInterruptIfRunning);
        this.failure = new CancellationException();
        this.cancelled = true;
        this.config.handleComplete(null, this.failure, this.execution, false);
        this.complete(null, this.failure, this.config.fallback, false);
        return cancelResult;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.circuit.await();
        if (this.failure != null) {
            if (this.failure instanceof CancellationException) {
                throw (CancellationException)this.failure;
            }
            throw new ExecutionException(this.failure);
        }
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Assert.isTrue(timeout >= 0L, "timeout cannot be negative", new Object[0]);
        if (!this.circuit.await(timeout, Assert.notNull(unit, "unit"))) {
            throw new TimeoutException();
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    synchronized void complete(T result, Throwable failure, CheckedBiFunction<T, Throwable, T> fallback, boolean success) {
        if (this.done) {
            return;
        }
        if (fallback == null) {
            this.result = result;
            this.failure = failure;
        } else if (!success) {
            try {
                this.result = fallback.apply(result, failure);
            }
            catch (Throwable fallbackFailure) {
                this.failure = fallbackFailure;
            }
        }
        this.done = true;
        if (this.completableFuture != null) {
            this.completeFuture();
        }
        this.circuit.close();
    }

    void inject(CompletableFuture<T> completableFuture) {
        this.completableFuture = completableFuture;
    }

    void inject(Future<T> delegate) {
        this.delegate = delegate;
    }

    void inject(ExecutionContext execution) {
        this.execution = execution;
    }

    private void completeFuture() {
        if (this.failure == null) {
            this.completableFuture.complete(this.result);
        } else {
            this.completableFuture.completeExceptionally(this.failure);
        }
    }
}

