/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import net.jodah.failsafe.AsyncExecution;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.FailsafeFuture;
import net.jodah.failsafe.function.AsyncCallable;
import net.jodah.failsafe.function.AsyncRunnable;
import net.jodah.failsafe.function.CheckedBiConsumer;
import net.jodah.failsafe.function.CheckedBiFunction;
import net.jodah.failsafe.function.CheckedConsumer;
import net.jodah.failsafe.function.CheckedFunction;
import net.jodah.failsafe.function.CheckedRunnable;
import net.jodah.failsafe.function.ContextualCallable;
import net.jodah.failsafe.function.ContextualRunnable;
import net.jodah.failsafe.internal.util.Assert;

final class Functions {
    Functions() {
    }

    static <T> AsyncCallableWrapper<T> asyncOf(final AsyncCallable<T> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public synchronized T call() throws Exception {
                try {
                    this.execution.before();
                    Object result = callable.call(this.execution);
                    return result;
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                    return null;
                }
            }
        };
    }

    static <T> AsyncCallableWrapper<T> asyncOf(final AsyncRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public synchronized T call() throws Exception {
                try {
                    this.execution.before();
                    runnable.run(this.execution);
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncCallableWrapper<T> asyncOf(final Callable<T> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.before();
                    Object result = callable.call();
                    this.execution.completeOrRetry(result, null);
                    return result;
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                    return null;
                }
            }
        };
    }

    static <T> AsyncCallableWrapper<T> asyncOf(final CheckedRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.before();
                    runnable.run();
                    this.execution.completeOrRetry(null, null);
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncCallableWrapper<T> asyncOf(final ContextualCallable<T> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.before();
                    Object result = callable.call(this.execution);
                    this.execution.completeOrRetry(result, null);
                    return result;
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                    return null;
                }
            }
        };
    }

    static <T> AsyncCallableWrapper<T> asyncOf(final ContextualRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.before();
                    runnable.run(this.execution);
                    this.execution.completeOrRetry(null, null);
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncCallableWrapper<T> asyncOfFuture(final AsyncCallable<CompletableFuture<T>> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallableWrapper<T>(){
            Semaphore asyncFutureLock = new Semaphore(1);

            @Override
            public T call() throws Exception {
                try {
                    this.execution.before();
                    this.asyncFutureLock.acquire();
                    ((CompletableFuture)callable.call(this.execution)).whenComplete(new BiConsumer<T, Throwable>(){

                        @Override
                        public void accept(T innerResult, Throwable failure) {
                            try {
                                if (failure != null) {
                                    execution.completeOrRetry(innerResult, failure instanceof CompletionException ? failure.getCause() : failure);
                                }
                            }
                            finally {
                                asyncFutureLock.release();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    try {
                        this.execution.completeOrRetry(null, e);
                    }
                    finally {
                        this.asyncFutureLock.release();
                    }
                }
                return null;
            }
        };
    }

    static <T> AsyncCallableWrapper<T> asyncOfFuture(final Callable<CompletableFuture<T>> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.before();
                    ((CompletableFuture)callable.call()).whenComplete(new BiConsumer<T, Throwable>(){

                        @Override
                        public void accept(T innerResult, Throwable failure) {
                            if (failure != null && failure instanceof CompletionException) {
                                failure = failure.getCause();
                            }
                            execution.completeOrRetry(innerResult, failure);
                        }
                    });
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncCallableWrapper<T> asyncOfFuture(final ContextualCallable<CompletableFuture<T>> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.before();
                    ((CompletableFuture)callable.call(this.execution)).whenComplete(new BiConsumer<T, Throwable>(){

                        @Override
                        public void accept(T innerResult, Throwable failure) {
                            if (failure != null && failure instanceof CompletionException) {
                                failure = failure.getCause();
                            }
                            execution.completeOrRetry(innerResult, failure);
                        }
                    });
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> Callable<T> callableOf(final CheckedRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                runnable.run();
                return null;
            }
        };
    }

    static <T> Callable<T> callableOf(final ContextualCallable<T> callable) {
        Assert.notNull(callable, "callable");
        return new ContextualCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                Object result = callable.call(this.context);
                return result;
            }
        };
    }

    static <T> Callable<T> callableOf(final ContextualRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new ContextualCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                runnable.run(this.context);
                return null;
            }
        };
    }

    static <T> CompletableFuture<T> cancellableFutureOf(final FailsafeFuture<T> future) {
        return new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                future.cancel(mayInterruptIfRunning);
                return super.cancel(mayInterruptIfRunning);
            }
        };
    }

    static <T, U, R> CheckedBiFunction<T, U, R> fnOf(final Callable<R> callable) {
        return new CheckedBiFunction<T, U, R>(){

            @Override
            public R apply(T t, U u) throws Exception {
                return callable.call();
            }
        };
    }

    static <T, U, R> CheckedBiFunction<T, U, R> fnOf(final CheckedBiConsumer<T, U> consumer) {
        return new CheckedBiFunction<T, U, R>(){

            @Override
            public R apply(T t, U u) throws Exception {
                consumer.accept(t, u);
                return null;
            }
        };
    }

    static <T, U, R> CheckedBiFunction<T, U, R> fnOf(final CheckedConsumer<U> consumer) {
        return new CheckedBiFunction<T, U, R>(){

            @Override
            public R apply(T t, U u) throws Exception {
                consumer.accept(u);
                return null;
            }
        };
    }

    static <T, U, R> CheckedBiFunction<T, U, R> fnOf(final CheckedFunction<U, R> function) {
        return new CheckedBiFunction<T, U, R>(){

            @Override
            public R apply(T t, U u) throws Exception {
                return function.apply(u);
            }
        };
    }

    static <T, U, R> CheckedBiFunction<T, U, R> fnOf(final CheckedRunnable runnable) {
        return new CheckedBiFunction<T, U, R>(){

            @Override
            public R apply(T t, U u) throws Exception {
                runnable.run();
                return null;
            }
        };
    }

    static <T, U, R> CheckedBiFunction<T, U, R> fnOf(final R result) {
        return new CheckedBiFunction<T, U, R>(){

            @Override
            public R apply(T t, U u) throws Exception {
                return result;
            }
        };
    }

    static abstract class ContextualCallableWrapper<T>
    implements Callable<T> {
        protected ExecutionContext context;

        ContextualCallableWrapper() {
        }

        void inject(ExecutionContext context) {
            this.context = context;
        }
    }

    static abstract class AsyncCallableWrapper<T>
    implements Callable<T> {
        protected AsyncExecution execution;

        AsyncCallableWrapper() {
        }

        void inject(AsyncExecution execution) {
            this.execution = execution;
        }
    }
}

