/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import net.jodah.failsafe.AsyncFailsafe;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.CircuitBreakerOpenException;
import net.jodah.failsafe.Execution;
import net.jodah.failsafe.FailsafeConfig;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.Functions;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.function.CheckedRunnable;
import net.jodah.failsafe.function.ContextualCallable;
import net.jodah.failsafe.function.ContextualRunnable;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.concurrent.Scheduler;
import net.jodah.failsafe.util.concurrent.Schedulers;

public class SyncFailsafe<R>
extends FailsafeConfig<R, SyncFailsafe<R>> {
    SyncFailsafe(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    SyncFailsafe(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public <T> T get(Callable<T> callable) {
        return this.call(Assert.notNull(callable, "callable"));
    }

    public <T> T get(ContextualCallable<T> callable) {
        return this.call(Functions.callableOf(callable));
    }

    public void run(CheckedRunnable runnable) {
        this.call(Functions.callableOf(runnable));
    }

    public void run(ContextualRunnable runnable) {
        this.call(Functions.callableOf(runnable));
    }

    public AsyncFailsafe<R> with(ScheduledExecutorService executor) {
        return new AsyncFailsafe(this, Schedulers.of(executor));
    }

    public AsyncFailsafe<R> with(Scheduler scheduler) {
        return new AsyncFailsafe(this, Assert.notNull(scheduler, "scheduler"));
    }

    private <T> T call(Callable<T> callable) {
        Execution execution = new Execution(this);
        if (callable instanceof Functions.ContextualCallableWrapper) {
            ((Functions.ContextualCallableWrapper)callable).inject(execution);
        }
        R result = null;
        while (true) {
            Throwable failure;
            if (this.circuitBreaker != null && !this.circuitBreaker.allowsExecution()) {
                CircuitBreakerOpenException e = new CircuitBreakerOpenException();
                if (this.fallback != null) {
                    return this.fallbackFor(result, e);
                }
                throw e;
            }
            try {
                execution.before();
                failure = null;
                result = (R)callable.call();
            }
            catch (Throwable t) {
                failure = t;
            }
            if (execution.complete(result, failure, true)) {
                if (execution.success || failure == null && this.fallback == null) {
                    return (T)result;
                }
                if (this.fallback != null) {
                    return this.fallbackFor(result, failure);
                }
                throw failure instanceof FailsafeException ? (FailsafeException)failure : new FailsafeException(failure);
            }
            try {
                Thread.sleep(execution.getWaitTime().toMillis());
            }
            catch (InterruptedException e) {
                throw new FailsafeException(e);
            }
            this.handleRetry(result, failure, execution);
        }
    }

    private <T> T fallbackFor(R result, Throwable failure) {
        try {
            return (T)this.fallback.apply(result, failure);
        }
        catch (Exception e) {
            throw e instanceof FailsafeException ? (FailsafeException)e : new FailsafeException(e);
        }
    }
}

