/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.AsyncExecution;
import net.jodah.failsafe.AsyncFailsafeConfig;
import net.jodah.failsafe.CircuitBreakerOpenException;
import net.jodah.failsafe.FailsafeConfig;
import net.jodah.failsafe.FailsafeFuture;
import net.jodah.failsafe.Functions;
import net.jodah.failsafe.function.AsyncCallable;
import net.jodah.failsafe.function.AsyncRunnable;
import net.jodah.failsafe.function.CheckedRunnable;
import net.jodah.failsafe.function.ContextualCallable;
import net.jodah.failsafe.function.ContextualRunnable;
import net.jodah.failsafe.util.concurrent.Scheduler;

public class AsyncFailsafe<R>
extends AsyncFailsafeConfig<R, AsyncFailsafe<R>> {
    AsyncFailsafe(FailsafeConfig<R, ?> config, Scheduler scheduler) {
        super(config, scheduler);
    }

    public <T> CompletableFuture<T> future(Callable<CompletableFuture<T>> callable) {
        return this.call(Functions.asyncOfFuture(callable));
    }

    public <T> CompletableFuture<T> future(ContextualCallable<CompletableFuture<T>> callable) {
        return this.call(Functions.asyncOfFuture(callable));
    }

    public <T> CompletableFuture<T> futureAsync(AsyncCallable<CompletableFuture<T>> callable) {
        return this.call(Functions.asyncOfFuture(callable));
    }

    public <T> FailsafeFuture<T> get(Callable<T> callable) {
        return this.call(Functions.asyncOf(callable), null);
    }

    public <T> FailsafeFuture<T> get(ContextualCallable<T> callable) {
        return this.call(Functions.asyncOf(callable), null);
    }

    public <T> FailsafeFuture<T> getAsync(AsyncCallable<T> callable) {
        return this.call(Functions.asyncOf(callable), null);
    }

    public FailsafeFuture<Void> run(CheckedRunnable runnable) {
        return this.call(Functions.asyncOf(runnable), null);
    }

    public FailsafeFuture<Void> run(ContextualRunnable runnable) {
        return this.call(Functions.asyncOf(runnable), null);
    }

    public FailsafeFuture<Void> runAsync(AsyncRunnable runnable) {
        return this.call(Functions.asyncOf(runnable), null);
    }

    private <T> CompletableFuture<T> call(Functions.AsyncCallableWrapper<T> callable) {
        FailsafeFuture future = new FailsafeFuture(this);
        CompletableFuture response = Functions.cancellableFutureOf(future);
        future.inject(response);
        this.call(callable, future);
        return response;
    }

    private <T> FailsafeFuture<T> call(Functions.AsyncCallableWrapper<T> callable, FailsafeFuture<T> future) {
        if (future == null) {
            future = new FailsafeFuture(this);
        }
        if (this.circuitBreaker != null && !this.circuitBreaker.allowsExecution()) {
            CircuitBreakerOpenException e = new CircuitBreakerOpenException();
            if (this.fallback == null) {
                throw e;
            }
            future.complete(null, e, this.fallback, false);
            return future;
        }
        AsyncExecution execution = new AsyncExecution(callable, this.scheduler, future, this);
        callable.inject(execution);
        future.inject(execution);
        try {
            future.inject(this.scheduler.schedule(callable, 0L, TimeUnit.MILLISECONDS));
        }
        catch (Throwable t) {
            this.handleComplete(null, t, execution, false);
            future.complete(null, t, this.fallback, false);
        }
        return future;
    }
}

