/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.Predicates;
import net.jodah.failsafe.function.BiPredicate;
import net.jodah.failsafe.function.Predicate;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.Duration;

public class RetryPolicy {
    static final RetryPolicy NEVER = new RetryPolicy().withMaxRetries(0);
    private Duration delay;
    private double delayMultiplier;
    private Duration maxDelay;
    private Duration maxDuration;
    private int maxRetries;
    private boolean failuresChecked;
    private List<BiPredicate<Object, Throwable>> retryConditions;
    private List<BiPredicate<Object, Throwable>> abortConditions;

    public RetryPolicy() {
        this.delay = Duration.NONE;
        this.maxRetries = -1;
        this.retryConditions = new ArrayList<BiPredicate<Object, Throwable>>();
        this.abortConditions = new ArrayList<BiPredicate<Object, Throwable>>();
    }

    public RetryPolicy(RetryPolicy rp) {
        this.delay = rp.delay;
        this.delayMultiplier = rp.delayMultiplier;
        this.maxDelay = rp.maxDelay;
        this.maxDuration = rp.maxDuration;
        this.maxRetries = rp.maxRetries;
        this.failuresChecked = rp.failuresChecked;
        this.retryConditions = new ArrayList<BiPredicate<Object, Throwable>>(rp.retryConditions);
        this.abortConditions = new ArrayList<BiPredicate<Object, Throwable>>(rp.abortConditions);
    }

    public <T> RetryPolicy abortIf(BiPredicate<T, ? extends Throwable> completionPredicate) {
        Assert.notNull(completionPredicate, "completionPredicate");
        this.abortConditions.add(completionPredicate);
        return this;
    }

    public <T> RetryPolicy abortIf(Predicate<T> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        this.abortConditions.add(Predicates.resultPredicateFor(resultPredicate));
        return this;
    }

    public RetryPolicy abortOn(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "Failures cannot be empty", new Object[0]);
        return this.abortOn(Arrays.asList(failures));
    }

    public RetryPolicy abortOn(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        this.abortConditions.add(Predicates.failurePredicateFor(failures));
        return this;
    }

    public RetryPolicy abortOn(Predicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        this.abortConditions.add(Predicates.failurePredicateFor(failurePredicate));
        return this;
    }

    public RetryPolicy abortWhen(Object result) {
        this.abortConditions.add(Predicates.resultPredicateFor(result));
        return this;
    }

    public boolean allowsRetries() {
        return !(this.maxRetries != -1 && this.maxRetries <= 0 || this.maxDuration != null && this.maxDuration.toNanos() <= 0L);
    }

    public boolean canAbortFor(Object result, Throwable failure) {
        for (BiPredicate<Object, Throwable> predicate : this.abortConditions) {
            if (!predicate.test(result, failure)) continue;
            return true;
        }
        return false;
    }

    public boolean canRetryFor(Object result, Throwable failure) {
        for (BiPredicate<Object, Throwable> predicate : this.retryConditions) {
            if (!predicate.test(result, failure)) continue;
            return true;
        }
        return failure != null && !this.failuresChecked;
    }

    public RetryPolicy copy() {
        return new RetryPolicy(this);
    }

    public Duration getDelay() {
        return this.delay;
    }

    public double getDelayMultiplier() {
        return this.delayMultiplier;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public <T> RetryPolicy retryIf(BiPredicate<T, ? extends Throwable> completionPredicate) {
        Assert.notNull(completionPredicate, "completionPredicate");
        this.failuresChecked = true;
        this.retryConditions.add(completionPredicate);
        return this;
    }

    public <T> RetryPolicy retryIf(Predicate<T> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        this.retryConditions.add(Predicates.resultPredicateFor(resultPredicate));
        return this;
    }

    public RetryPolicy retryOn(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "Failures cannot be empty", new Object[0]);
        return this.retryOn(Arrays.asList(failures));
    }

    public RetryPolicy retryOn(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        this.failuresChecked = true;
        this.retryConditions.add(Predicates.failurePredicateFor(failures));
        return this;
    }

    public RetryPolicy retryOn(Predicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        this.failuresChecked = true;
        this.retryConditions.add(Predicates.failurePredicateFor(failurePredicate));
        return this;
    }

    public RetryPolicy retryWhen(Object result) {
        this.retryConditions.add(Predicates.resultPredicateFor(result));
        return this;
    }

    public RetryPolicy withBackoff(long delay, long maxDelay, TimeUnit timeUnit) {
        return this.withBackoff(delay, maxDelay, timeUnit, 2.0);
    }

    public RetryPolicy withBackoff(long delay, long maxDelay, TimeUnit timeUnit, double delayMultiplier) {
        Assert.notNull(timeUnit, "timeUnit");
        this.delay = new Duration(delay, timeUnit);
        this.maxDelay = new Duration(maxDelay, timeUnit);
        this.delayMultiplier = delayMultiplier;
        Assert.isTrue(this.delay.toNanos() > 0L, "The delay must be greater than 0", new Object[0]);
        if (this.maxDuration != null) {
            Assert.state(this.delay.toNanos() < this.maxDuration.toNanos(), "delay must be less than the maxDuration", new Object[0]);
        }
        Assert.isTrue(this.delay.toNanos() < this.maxDelay.toNanos(), "delay must be less than the maxDelay", new Object[0]);
        Assert.isTrue(delayMultiplier > 1.0, "delayMultiplier must be greater than 1", new Object[0]);
        return this;
    }

    public RetryPolicy withDelay(long delay, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        this.delay = new Duration(delay, timeUnit);
        Assert.isTrue(this.delay.toNanos() > 0L, "delay must be greater than 0", new Object[0]);
        if (this.maxDuration != null) {
            Assert.state(this.delay.toNanos() < this.maxDuration.toNanos(), "delay must be less than the maxDuration", new Object[0]);
        }
        Assert.state(this.maxDelay == null, "Backoff delays have already been set", new Object[0]);
        return this;
    }

    public RetryPolicy withMaxDuration(long maxDuration, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        this.maxDuration = new Duration(maxDuration, timeUnit);
        Assert.state(this.maxDuration.toNanos() > this.delay.toNanos(), "maxDuration must be greater than the delay", new Object[0]);
        return this;
    }

    public RetryPolicy withMaxRetries(int maxRetries) {
        Assert.isTrue(maxRetries >= -1, "maxRetries must be greater than or equal to -1", new Object[0]);
        this.maxRetries = maxRetries;
        return this;
    }
}

