/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal.util;

import java.util.BitSet;

public class CircularBitSet {
    private final BitSet bitSet;
    private final int size;
    private volatile int currentIndex;
    private volatile int occupiedBits;
    private volatile int positives;
    private volatile int negatives;

    public CircularBitSet(int size) {
        this.bitSet = new BitSet(size);
        this.size = size;
    }

    public double positiveRatio() {
        return (double)this.positives / (double)this.occupiedBits;
    }

    public double negativeRatio() {
        return (double)this.negatives / (double)this.occupiedBits;
    }

    public synchronized int setNext(boolean value) {
        int previousValue = -1;
        if (this.occupiedBits < this.size) {
            ++this.occupiedBits;
        } else {
            previousValue = this.bitSet.get(this.currentIndex) ? 1 : 0;
        }
        this.bitSet.set(this.currentIndex, value);
        this.currentIndex = this.currentIndex == this.size - 1 ? 0 : ++this.currentIndex;
        if (value) {
            if (previousValue != 1) {
                ++this.positives;
            }
            if (previousValue == 0) {
                --this.negatives;
            }
        } else {
            if (previousValue != 0) {
                ++this.negatives;
            }
            if (previousValue == 1) {
                --this.positives;
            }
        }
        return previousValue;
    }
}

