/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal;

import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.internal.CircuitBreakerStats;
import net.jodah.failsafe.internal.CircuitState;
import net.jodah.failsafe.internal.util.CircularBitSet;
import net.jodah.failsafe.util.Ratio;

public class ClosedState
implements CircuitState {
    private final CircuitBreaker circuit;
    private final Integer failureThresh;
    private final Ratio failureRatio;
    private volatile int executions;
    private volatile int successiveFailures;
    private CircularBitSet bitSet;

    public ClosedState(CircuitBreaker circuit) {
        this.circuit = circuit;
        this.failureThresh = circuit.getFailureThreshold();
        this.failureRatio = circuit.getFailureThresholdRatio();
        if (this.failureRatio != null) {
            this.bitSet = new CircularBitSet(this.failureRatio.denominator);
        }
    }

    @Override
    public boolean allowsExecution(CircuitBreakerStats stats) {
        return true;
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.CLOSED;
    }

    @Override
    public synchronized void recordFailure() {
        ++this.executions;
        ++this.successiveFailures;
        if (this.bitSet != null) {
            this.bitSet.setNext(false);
        }
        this.checkThreshold();
    }

    @Override
    public synchronized void recordSuccess() {
        ++this.executions;
        this.successiveFailures = 0;
        if (this.bitSet != null) {
            this.bitSet.setNext(true);
        }
        this.checkThreshold();
    }

    synchronized void checkThreshold() {
        if (this.failureRatio != null && this.executions >= this.failureRatio.denominator && this.bitSet.negativeRatio() >= this.failureRatio.ratio) {
            this.circuit.open();
        }
        if (this.failureThresh != null && this.successiveFailures == this.failureThresh) {
            this.circuit.open();
        }
        if (this.failureThresh == null && this.failureRatio == null && this.successiveFailures == 1) {
            this.circuit.open();
        }
    }
}

