/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.event.ContextualResultListener;
import net.jodah.failsafe.event.ContextualSuccessListener;
import net.jodah.failsafe.event.FailureListener;
import net.jodah.failsafe.event.ResultListener;
import net.jodah.failsafe.event.SuccessListener;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.concurrent.Scheduler;

public class Listeners<R> {
    public void onAbort(R result, Throwable failure) {
    }

    public void onAbort(R result, Throwable failure, ExecutionContext context) {
    }

    public void onComplete(R result, Throwable failure) {
    }

    public void onComplete(R result, Throwable failure, ExecutionContext context) {
    }

    public void onFailedAttempt(R result, Throwable failure) {
    }

    public void onFailedAttempt(R result, Throwable failure, ExecutionContext context) {
    }

    public void onFailure(R result, Throwable failure) {
    }

    public void onFailure(R result, Throwable failure, ExecutionContext context) {
    }

    public void onRetriesExceeded(R result, Throwable failure) {
    }

    public void onRetry(R result, Throwable failure) {
    }

    public void onRetry(R result, Throwable failure, ExecutionContext context) {
    }

    public void onSuccess(R result) {
    }

    public void onSuccess(R result, ExecutionContext context) {
    }

    static <T> ContextualResultListener<T, Throwable> of(final ContextualResultListener<? extends T, ? extends Throwable> listener, final ExecutorService executor, final Scheduler scheduler) {
        return new ContextualResultListener<T, Throwable>(){

            @Override
            public void onResult(final T result, final Throwable failure, final ExecutionContext context) {
                Callable callable = new Callable<T>(){

                    @Override
                    public T call() {
                        listener.onResult(result, failure, context);
                        return null;
                    }
                };
                try {
                    if (executor != null) {
                        executor.submit(callable);
                    } else {
                        scheduler.schedule(callable, 0L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    static <T> ContextualResultListener<T, Throwable> of(final ContextualSuccessListener<? extends T> listener) {
        Assert.notNull(listener, "listener");
        return new ContextualResultListener<T, Throwable>(){

            @Override
            public void onResult(T result, Throwable failure, ExecutionContext context) {
                listener.onSuccess(result, context);
            }
        };
    }

    static <T> ContextualResultListener<T, Throwable> of(final FailureListener<? extends Throwable> listener) {
        Assert.notNull(listener, "listener");
        return new ContextualResultListener<T, Throwable>(){

            @Override
            public void onResult(T result, Throwable failure, ExecutionContext context) {
                listener.onFailure(failure);
            }
        };
    }

    static <T> ContextualResultListener<T, Throwable> of(final ResultListener<? extends T, ? extends Throwable> listener) {
        Assert.notNull(listener, "listener");
        return new ContextualResultListener<T, Throwable>(){

            @Override
            public void onResult(T result, Throwable failure, ExecutionContext context) {
                listener.onResult(result, failure);
            }
        };
    }

    static <T> ContextualResultListener<T, Throwable> of(final SuccessListener<? extends T> listener) {
        Assert.notNull(listener, "listener");
        return new ContextualResultListener<T, Throwable>(){

            @Override
            public void onResult(T result, Throwable failure, ExecutionContext context) {
                listener.onSuccess(result);
            }
        };
    }
}

