/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.Listeners;
import net.jodah.failsafe.event.ContextualResultListener;
import net.jodah.failsafe.event.ContextualSuccessListener;
import net.jodah.failsafe.event.FailureListener;
import net.jodah.failsafe.event.ResultListener;
import net.jodah.failsafe.event.SuccessListener;
import net.jodah.failsafe.internal.util.Assert;

public class ListenerConfig<S, R> {
    Listeners<R> listeners;
    ListenerRegistry<R> listenerRegistry;

    ListenerConfig() {
    }

    static <T> void call(List<ContextualResultListener<T, Throwable>> listeners, T result, Throwable failure, ExecutionContext context) {
        for (ContextualResultListener<T, Throwable> listener : listeners) {
            try {
                listener.onResult(result, failure, context);
            }
            catch (Exception exception) {}
        }
    }

    public S onAbort(ContextualResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().abort().add(Assert.notNull(listener, "listener"));
        return (S)this;
    }

    public S onAbort(FailureListener<? extends Throwable> listener) {
        this.registry().abort().add(Listeners.of(listener));
        return (S)this;
    }

    public S onAbort(ResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().abort().add(Listeners.of(listener));
        return (S)this;
    }

    public S onAbortAsync(ContextualResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().abort().add(Listeners.of(listener, Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onAbortAsync(FailureListener<? extends Throwable> listener, ExecutorService executor) {
        this.registry().abort().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onAbortAsync(ResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().abort().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onComplete(ContextualResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().complete().add(Assert.notNull(listener, "listener"));
        return (S)this;
    }

    public S onComplete(ResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().complete().add(Listeners.of(listener));
        return (S)this;
    }

    public S onCompleteAsync(ContextualResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().complete().add(Listeners.of(listener, Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onCompleteAsync(ResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().complete().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onFailedAttempt(ContextualResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().failedAttempt().add(Assert.notNull(listener, "listener"));
        return (S)this;
    }

    public S onFailedAttempt(FailureListener<? extends Throwable> listener) {
        this.registry().failedAttempt().add(Listeners.of(listener));
        return (S)this;
    }

    public S onFailedAttempt(ResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().failedAttempt().add(Listeners.of(listener));
        return (S)this;
    }

    public S onFailedAttemptAsync(ContextualResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().failedAttempt().add(Listeners.of(listener, Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onFailedAttemptAsync(FailureListener<? extends Throwable> listener, ExecutorService executor) {
        this.registry().failedAttempt().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onFailedAttemptAsync(ResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().failedAttempt().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onFailure(ContextualResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().failure().add(Assert.notNull(listener, "listener"));
        return (S)this;
    }

    public S onFailure(FailureListener<? extends Throwable> listener) {
        this.registry().failure().add(Listeners.of(listener));
        return (S)this;
    }

    public S onFailure(ResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().failure().add(Listeners.of(listener));
        return (S)this;
    }

    public S onFailureAsync(ContextualResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().failure().add(Listeners.of(listener, Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onFailureAsync(FailureListener<? extends Throwable> listener, ExecutorService executor) {
        this.registry().failure().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onFailureAsync(ResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().failure().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onRetriesExceeded(FailureListener<? extends Throwable> listener) {
        this.registry().retriesExceeded().add(Listeners.of(listener));
        return (S)this;
    }

    public S onRetriesExceeded(ResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().retriesExceeded().add(Listeners.of(listener));
        return (S)this;
    }

    public S onRetriesExceededAsync(FailureListener<? extends Throwable> listener, ExecutorService executor) {
        this.registry().retriesExceeded().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onRetriesExceededAsync(ResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().retriesExceeded().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onRetry(ContextualResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().retry().add(Assert.notNull(listener, "listener"));
        return (S)this;
    }

    public S onRetry(FailureListener<? extends Throwable> listener) {
        this.registry().retry().add(Listeners.of(listener));
        return (S)this;
    }

    public S onRetry(ResultListener<? extends R, ? extends Throwable> listener) {
        this.registry().retry().add(Listeners.of(listener));
        return (S)this;
    }

    public S onRetryAsync(ContextualResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().retry().add(Listeners.of(listener, Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onRetryAsync(FailureListener<? extends Throwable> listener, ExecutorService executor) {
        this.registry().retry().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onRetryAsync(ResultListener<? extends R, ? extends Throwable> listener, ExecutorService executor) {
        this.registry().retry().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onSuccess(ContextualSuccessListener<? extends R> listener) {
        this.registry().success().add(Listeners.of(listener));
        return (S)this;
    }

    public S onSuccess(SuccessListener<? extends R> listener) {
        this.registry().success().add(Listeners.of(listener));
        return (S)this;
    }

    public S onSuccessAsync(ContextualSuccessListener<? extends R> listener, ExecutorService executor) {
        this.registry().success().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    public S onSuccessAsync(SuccessListener<? extends R> listener, ExecutorService executor) {
        this.registry().success().add(Listeners.of(Listeners.of(listener), Assert.notNull(executor, "executor"), null));
        return (S)this;
    }

    void handleAbort(R result, Throwable failure, ExecutionContext context) {
        if (this.listenerRegistry != null && ((ListenerRegistry)this.listenerRegistry).abortListeners != null) {
            context = context.copy();
            ListenerConfig.call(((ListenerRegistry)this.listenerRegistry).abortListeners, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onAbort(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onAbort(result, failure, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void handleComplete(R result, Throwable failure, ExecutionContext context, boolean success) {
        if (success) {
            this.handleSuccess(result, context);
        } else {
            this.handleFailure(result, failure, context);
        }
        this.handleComplete(result, failure, context);
    }

    void handleFailedAttempt(R result, Throwable failure, ExecutionContext context) {
        if (this.listenerRegistry != null && ((ListenerRegistry)this.listenerRegistry).failedAttemptListeners != null) {
            context = context.copy();
            ListenerConfig.call(((ListenerRegistry)this.listenerRegistry).failedAttemptListeners, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onFailedAttempt(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onFailedAttempt(result, failure, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void handleRetriesExceeded(R result, Throwable failure, ExecutionContext context) {
        if (this.listenerRegistry != null && ((ListenerRegistry)this.listenerRegistry).retriesExceededListeners != null) {
            context = context.copy();
            ListenerConfig.call(((ListenerRegistry)this.listenerRegistry).retriesExceededListeners, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onRetriesExceeded(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void handleRetry(R result, Throwable failure, ExecutionContext context) {
        if (this.listenerRegistry != null && ((ListenerRegistry)this.listenerRegistry).retryListeners != null) {
            context = context.copy();
            ListenerConfig.call(((ListenerRegistry)this.listenerRegistry).retryListeners, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onRetry(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onRetry(result, failure, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    ListenerRegistry<R> registry() {
        return this.listenerRegistry != null ? this.listenerRegistry : (this.listenerRegistry = new ListenerRegistry());
    }

    private void handleComplete(R result, Throwable failure, ExecutionContext context) {
        if (this.listenerRegistry != null && ((ListenerRegistry)this.listenerRegistry).completeListeners != null) {
            context = context.copy();
            ListenerConfig.call(((ListenerRegistry)this.listenerRegistry).completeListeners, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onComplete(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onComplete(result, failure, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handleFailure(R result, Throwable failure, ExecutionContext context) {
        if (this.listenerRegistry != null && ((ListenerRegistry)this.listenerRegistry).failureListeners != null) {
            context = context.copy();
            ListenerConfig.call(((ListenerRegistry)this.listenerRegistry).failureListeners, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onFailure(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onFailure(result, failure, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handleSuccess(R result, ExecutionContext context) {
        if (this.listenerRegistry != null && ((ListenerRegistry)this.listenerRegistry).successListeners != null) {
            context = context.copy();
            ListenerConfig.call(((ListenerRegistry)this.listenerRegistry).successListeners, result, null, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onSuccess(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onSuccess(result, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class ListenerRegistry<T> {
        private List<ContextualResultListener<T, Throwable>> abortListeners;
        private List<ContextualResultListener<T, Throwable>> completeListeners;
        private List<ContextualResultListener<T, Throwable>> failedAttemptListeners;
        private List<ContextualResultListener<T, Throwable>> failureListeners;
        private List<ContextualResultListener<T, Throwable>> retriesExceededListeners;
        private List<ContextualResultListener<T, Throwable>> retryListeners;
        private List<ContextualResultListener<T, Throwable>> successListeners;

        ListenerRegistry() {
        }

        List<ContextualResultListener<T, Throwable>> abort() {
            return this.abortListeners != null ? this.abortListeners : (this.abortListeners = new ArrayList<ContextualResultListener<T, Throwable>>(2));
        }

        List<ContextualResultListener<T, Throwable>> complete() {
            return this.completeListeners != null ? this.completeListeners : (this.completeListeners = new ArrayList<ContextualResultListener<T, Throwable>>(2));
        }

        List<ContextualResultListener<T, Throwable>> failedAttempt() {
            return this.failedAttemptListeners != null ? this.failedAttemptListeners : (this.failedAttemptListeners = new ArrayList<ContextualResultListener<T, Throwable>>(2));
        }

        List<ContextualResultListener<T, Throwable>> failure() {
            return this.failureListeners != null ? this.failureListeners : (this.failureListeners = new ArrayList<ContextualResultListener<T, Throwable>>(2));
        }

        List<ContextualResultListener<T, Throwable>> retriesExceeded() {
            return this.retriesExceededListeners != null ? this.retriesExceededListeners : (this.retriesExceededListeners = new ArrayList<ContextualResultListener<T, Throwable>>(2));
        }

        List<ContextualResultListener<T, Throwable>> retry() {
            return this.retryListeners != null ? this.retryListeners : (this.retryListeners = new ArrayList<ContextualResultListener<T, Throwable>>(2));
        }

        List<ContextualResultListener<T, Throwable>> success() {
            return this.successListeners != null ? this.successListeners : (this.successListeners = new ArrayList<ContextualResultListener<T, Throwable>>(2));
        }
    }
}

