/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal;

import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.internal.CircuitBreakerStats;
import net.jodah.failsafe.internal.CircuitState;
import net.jodah.failsafe.util.Duration;

public class OpenState
implements CircuitState {
    private final CircuitBreaker circuit;
    private final Duration delay;
    private final long startTime = System.nanoTime();

    public OpenState(CircuitBreaker circuit) {
        this.circuit = circuit;
        this.delay = circuit.getDelay();
    }

    @Override
    public boolean allowsExecution(CircuitBreakerStats stats) {
        if (System.nanoTime() - this.startTime >= this.delay.toNanos()) {
            this.circuit.halfOpen();
            return true;
        }
        return false;
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.OPEN;
    }

    @Override
    public void recordFailure() {
        throw new IllegalStateException("Cannot record result for open circuit");
    }

    @Override
    public void recordSuccess() {
        throw new IllegalStateException("Cannot record result for open circuit");
    }
}

