/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import net.jodah.failsafe.AsyncFailsafe;
import net.jodah.failsafe.Callables;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.CircuitBreakerOpenException;
import net.jodah.failsafe.Execution;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.ListenerConfig;
import net.jodah.failsafe.Listeners;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.function.CheckedRunnable;
import net.jodah.failsafe.function.ContextualCallable;
import net.jodah.failsafe.function.ContextualRunnable;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.concurrent.Scheduler;
import net.jodah.failsafe.util.concurrent.Schedulers;

public class SyncFailsafe<R>
extends ListenerConfig<SyncFailsafe<R>, R> {
    RetryPolicy retryPolicy = RetryPolicy.NEVER;
    CircuitBreaker circuitBreaker;

    SyncFailsafe(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    SyncFailsafe(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public <T> T get(Callable<T> callable) {
        return this.call(Assert.notNull(callable, "callable"));
    }

    public <T> T get(ContextualCallable<T> callable) {
        return this.call(Callables.of(callable));
    }

    public void run(CheckedRunnable runnable) {
        this.call(Callables.of(runnable));
    }

    public void run(ContextualRunnable runnable) {
        this.call(Callables.of(runnable));
    }

    public SyncFailsafe<R> with(CircuitBreaker circuitBreaker) {
        Assert.state(this.circuitBreaker == null, "A circuit breaker has already been configured", new Object[0]);
        this.circuitBreaker = Assert.notNull(circuitBreaker, "circuitBreaker");
        return this;
    }

    public SyncFailsafe<R> with(RetryPolicy retryPolicy) {
        Assert.state(this.retryPolicy == RetryPolicy.NEVER, "A retry policy has already been configured", new Object[0]);
        this.retryPolicy = Assert.notNull(retryPolicy, "retryPolicy");
        return this;
    }

    public <T> SyncFailsafe<T> with(Listeners<T> listeners) {
        this.listeners = Assert.notNull(listeners, "listeners");
        return this;
    }

    public AsyncFailsafe<R> with(ScheduledExecutorService executor) {
        return new AsyncFailsafe(this, Schedulers.of(executor));
    }

    public AsyncFailsafe<R> with(Scheduler scheduler) {
        return new AsyncFailsafe(this, Assert.notNull(scheduler, "scheduler"));
    }

    private <T> T call(Callable<T> callable) {
        if (this.circuitBreaker != null) {
            this.circuitBreaker.initialize();
        }
        Execution execution = new Execution(this.retryPolicy, this.circuitBreaker, this);
        if (callable instanceof Callables.ContextualCallableWrapper) {
            ((Callables.ContextualCallableWrapper)callable).inject(execution);
        }
        Object result = null;
        while (true) {
            Throwable failure;
            if (this.circuitBreaker != null && !this.circuitBreaker.allowsExecution()) {
                throw new CircuitBreakerOpenException();
            }
            try {
                execution.before();
                failure = null;
                result = callable.call();
            }
            catch (Throwable t) {
                failure = t;
            }
            if (execution.complete(result, failure, true)) {
                if (execution.success || failure == null) {
                    return (T)result;
                }
                FailsafeException re = failure instanceof FailsafeException ? (FailsafeException)failure : new FailsafeException(failure);
                throw re;
            }
            try {
                Thread.sleep(execution.getWaitTime().toMillis());
            }
            catch (InterruptedException e) {
                throw new FailsafeException(e);
            }
            this.handleRetry(result, failure, execution);
        }
    }
}

