/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.internal.util.ReentrantCircuit;

public class FailsafeFuture<T>
implements Future<T> {
    private final ReentrantCircuit circuit = new ReentrantCircuit();
    private final CompletableFuture<T> completableFuture;
    private volatile Future<T> delegate;
    private volatile boolean done;
    private volatile boolean cancelled;
    private volatile T result;
    private volatile Throwable failure;

    FailsafeFuture() {
        this.completableFuture = null;
        this.circuit.open();
    }

    FailsafeFuture(CompletableFuture<T> future) {
        this.completableFuture = future;
        this.circuit.open();
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = this.delegate.cancel(mayInterruptIfRunning);
        this.cancelled = true;
        this.circuit.close();
        return result;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.circuit.await();
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Assert.isTrue(timeout >= 0L, "timeout cannot be negative", new Object[0]);
        if (!this.circuit.await(timeout, Assert.notNull(unit, "unit"))) {
            throw new TimeoutException();
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    synchronized void complete(T result, Throwable failure) {
        this.result = result;
        this.failure = failure;
        this.done = true;
        if (this.completableFuture != null) {
            this.completeFuture();
        }
        this.circuit.close();
    }

    void setFuture(Future<T> delegate) {
        this.delegate = delegate;
    }

    private void completeFuture() {
        if (this.failure == null) {
            this.completableFuture.complete(this.result);
        } else {
            this.completableFuture.completeExceptionally(this.failure);
        }
    }
}

