/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.jodah.failsafe.Predicates;
import net.jodah.failsafe.function.BiPredicate;
import net.jodah.failsafe.function.CheckedRunnable;
import net.jodah.failsafe.function.Predicate;
import net.jodah.failsafe.internal.CircuitBreakerStats;
import net.jodah.failsafe.internal.CircuitState;
import net.jodah.failsafe.internal.ClosedState;
import net.jodah.failsafe.internal.HalfOpenState;
import net.jodah.failsafe.internal.OpenState;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.Duration;
import net.jodah.failsafe.util.Ratio;

public class CircuitBreaker {
    private final AtomicReference<CircuitState> state = new AtomicReference();
    private final AtomicInteger currentExecutions = new AtomicInteger();
    private final CircuitBreakerStats stats = new CircuitBreakerStats(){

        @Override
        public int getCurrentExecutions() {
            return CircuitBreaker.this.currentExecutions.get();
        }
    };
    private Duration delay = Duration.NONE;
    private Duration timeout;
    private Integer failureThreshold;
    private Ratio failureThresholdRatio;
    private Integer successThreshold;
    private Ratio successThresholdRatio;
    private boolean failuresChecked;
    private List<BiPredicate<Object, Throwable>> failureConditions = new ArrayList<BiPredicate<Object, Throwable>>();
    CheckedRunnable onOpen;
    CheckedRunnable onHalfOpen;
    CheckedRunnable onClose;

    public boolean allowsExecution() {
        return this.state.get().allowsExecution(this.stats);
    }

    public void close() {
        this.transitionTo(State.CLOSED, this.onClose);
    }

    public <T> CircuitBreaker failIf(BiPredicate<T, ? extends Throwable> completionPredicate) {
        Assert.notNull(completionPredicate, "completionPredicate");
        this.failuresChecked = true;
        this.failureConditions.add(completionPredicate);
        return this;
    }

    public <T> CircuitBreaker failIf(Predicate<T> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        this.failureConditions.add(Predicates.resultPredicateFor(resultPredicate));
        return this;
    }

    public CircuitBreaker failOn(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "failures cannot be empty", new Object[0]);
        return this.failOn(Arrays.asList(failures));
    }

    public CircuitBreaker failOn(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        this.failuresChecked = true;
        this.failureConditions.add(Predicates.failurePredicateFor(failures));
        return this;
    }

    public CircuitBreaker failOn(Predicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        this.failuresChecked = true;
        this.failureConditions.add(Predicates.failurePredicateFor(failurePredicate));
        return this;
    }

    public CircuitBreaker failWhen(Object result) {
        this.failureConditions.add(Predicates.resultPredicateFor(result));
        return this;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public Integer getFailureThreshold() {
        return this.failureThreshold;
    }

    public Ratio getFailureThresholdRatio() {
        return this.failureThresholdRatio;
    }

    public State getState() {
        CircuitState circuitState = this.state.get();
        return circuitState == null ? State.CLOSED : circuitState.getState();
    }

    public Integer getSuccessThreshold() {
        return this.successThreshold;
    }

    public Ratio getSuccessThresholdRatio() {
        return this.successThresholdRatio;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void halfOpen() {
        this.transitionTo(State.HALF_OPEN, this.onHalfOpen);
    }

    public boolean isClosed() {
        return State.CLOSED.equals((Object)this.getState());
    }

    public boolean isFailure(Object result, Throwable failure) {
        for (BiPredicate<Object, Throwable> predicate : this.failureConditions) {
            if (!predicate.test(result, failure)) continue;
            return true;
        }
        return failure != null && !this.failuresChecked;
    }

    public boolean isOpen() {
        return State.OPEN.equals((Object)this.getState());
    }

    public void onClose(CheckedRunnable runnable) {
        this.onClose = runnable;
    }

    public void onHalfOpen(CheckedRunnable runnable) {
        this.onHalfOpen = runnable;
    }

    public void onOpen(CheckedRunnable runnable) {
        this.onOpen = runnable;
    }

    public void open() {
        this.transitionTo(State.OPEN, this.onOpen);
    }

    public void recordFailure(Throwable failure) {
        this.recordResult(null, failure);
    }

    public void recordResult(Object result) {
        this.recordResult(result, null);
    }

    public void recordSuccess() {
        CircuitState circuitState = this.state.get();
        if (this.state != null) {
            circuitState.recordSuccess();
            this.currentExecutions.decrementAndGet();
        }
    }

    public String toString() {
        return this.getState().toString();
    }

    public CircuitBreaker withDelay(long delay, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        Assert.isTrue(delay > 0L, "delay must be greater than 0", new Object[0]);
        this.delay = new Duration(delay, timeUnit);
        return this;
    }

    public CircuitBreaker withFailureThreshold(int failureThreshold) {
        Assert.isTrue(failureThreshold >= 1, "failureThreshold must be greater than or equal to 1", new Object[0]);
        Assert.state(this.failureThresholdRatio == null, "failure threshold and failure threshold ratio cannot both be configured", new Object[0]);
        this.failureThreshold = failureThreshold;
        return this;
    }

    public CircuitBreaker withFailureThreshold(int failures, int executions) {
        Assert.isTrue(failures >= 1, "failures must be greater than or equal to 1", new Object[0]);
        Assert.isTrue(executions >= 1, "executions must be greater than or equal to 1", new Object[0]);
        Assert.isTrue(executions >= failures, "executions must be greater than or equal to failures", new Object[0]);
        Assert.state(this.failureThreshold == null, "failure threshold and failure threshold ratio cannot both be configured", new Object[0]);
        this.failureThresholdRatio = new Ratio(failures, executions);
        return this;
    }

    public CircuitBreaker withSuccessThreshold(int successThreshold) {
        Assert.isTrue(successThreshold >= 1, "successThreshold must be greater than or equal to 1", new Object[0]);
        Assert.state(this.successThresholdRatio == null, "success threshold and success threshold ratio cannot both be configured", new Object[0]);
        this.successThreshold = successThreshold;
        return this;
    }

    public CircuitBreaker withSuccessThreshold(int successes, int executions) {
        Assert.isTrue(successes >= 1, "successes must be greater than or equal to 1", new Object[0]);
        Assert.isTrue(executions >= 1, "executions must be greater than or equal to 1", new Object[0]);
        Assert.isTrue(executions >= successes, "executions must be greater than or equal to successes", new Object[0]);
        Assert.state(this.successThreshold == null, "success threshold and success threshold ratio cannot both be configured", new Object[0]);
        this.successThresholdRatio = new Ratio(successes, executions);
        return this;
    }

    public CircuitBreaker withTimeout(long timeout, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        Assert.isTrue(timeout > 0L, "timeout must be greater than 0", new Object[0]);
        this.timeout = new Duration(timeout, timeUnit);
        return this;
    }

    synchronized void initialize() {
        if (this.state.get() == null) {
            this.state.set(new ClosedState(this));
        }
    }

    void recordFailure() {
        CircuitState circuitState = this.state.get();
        if (this.state != null) {
            circuitState.recordFailure();
            this.currentExecutions.decrementAndGet();
        }
    }

    void recordResult(Object result, Throwable failure) {
        CircuitState circuitState = this.state.get();
        if (this.state != null) {
            if (this.isFailure(result, failure)) {
                circuitState.recordFailure();
            } else {
                circuitState.recordSuccess();
            }
            this.currentExecutions.decrementAndGet();
        }
    }

    void before() {
        this.currentExecutions.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transitionTo(State newState, CheckedRunnable listener) {
        boolean transitioned = false;
        CircuitBreaker circuitBreaker = this;
        synchronized (circuitBreaker) {
            if (!this.getState().equals((Object)newState)) {
                switch (newState) {
                    case CLOSED: {
                        this.state.set(new ClosedState(this));
                        break;
                    }
                    case OPEN: {
                        this.state.set(new OpenState(this));
                        break;
                    }
                    case HALF_OPEN: {
                        this.state.set(new HalfOpenState(this));
                    }
                }
                transitioned = true;
            }
        }
        if (transitioned && listener != null) {
            try {
                listener.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum State {
        CLOSED,
        OPEN,
        HALF_OPEN;

    }
}

