/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import net.jodah.failsafe.AsyncExecution;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.function.AsyncCallable;
import net.jodah.failsafe.function.AsyncRunnable;
import net.jodah.failsafe.function.CheckedRunnable;
import net.jodah.failsafe.function.ContextualCallable;
import net.jodah.failsafe.function.ContextualRunnable;
import net.jodah.failsafe.internal.util.Assert;

final class Callables {
    Callables() {
    }

    static <T> Callable<T> of(final CheckedRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                runnable.run();
                return null;
            }
        };
    }

    static <T> Callable<T> of(final ContextualCallable<T> callable) {
        Assert.notNull(callable, "callable");
        return new ContextualCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                Object result = callable.call(this.context);
                return result;
            }
        };
    }

    static <T> Callable<T> of(final ContextualRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new ContextualCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                runnable.run(this.context);
                return null;
            }
        };
    }

    static <T> AsyncCallableWrapper<T> asyncOf(final AsyncCallable<T> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public synchronized T call() throws Exception {
                try {
                    this.execution.before();
                    Object result = callable.call(this.execution);
                    return result;
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                    return null;
                }
            }
        };
    }

    static <T> AsyncCallableWrapper<T> asyncOf(final AsyncRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public synchronized T call() throws Exception {
                try {
                    this.execution.before();
                    runnable.run(this.execution);
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncCallableWrapper<T> asyncOf(final Callable<T> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.before();
                    Object result = callable.call();
                    this.execution.completeOrRetry(result, null);
                    return result;
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                    return null;
                }
            }
        };
    }

    static <T> AsyncCallableWrapper<T> asyncOf(final CheckedRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.before();
                    runnable.run();
                    this.execution.completeOrRetry(null, null);
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncCallableWrapper<T> asyncOf(final ContextualCallable<T> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.before();
                    Object result = callable.call(this.execution);
                    this.execution.completeOrRetry(result, null);
                    return result;
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                    return null;
                }
            }
        };
    }

    static <T> AsyncCallableWrapper<T> asyncOf(final ContextualRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.before();
                    runnable.run(this.execution);
                    this.execution.completeOrRetry(null, null);
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncCallableWrapper<T> ofFuture(final AsyncCallable<CompletableFuture<T>> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallableWrapper<T>(){
            Semaphore asyncFutureLock = new Semaphore(1);

            @Override
            public T call() throws Exception {
                try {
                    this.execution.before();
                    this.asyncFutureLock.acquire();
                    ((CompletableFuture)callable.call(this.execution)).whenComplete(new BiConsumer<T, Throwable>(){

                        @Override
                        public void accept(T innerResult, Throwable failure) {
                            try {
                                if (failure != null) {
                                    execution.completeOrRetry(innerResult, failure instanceof CompletionException ? failure.getCause() : failure);
                                }
                            }
                            finally {
                                asyncFutureLock.release();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    try {
                        this.execution.completeOrRetry(null, e);
                    }
                    finally {
                        this.asyncFutureLock.release();
                    }
                }
                return null;
            }
        };
    }

    static <T> AsyncCallableWrapper<T> ofFuture(final Callable<CompletableFuture<T>> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.before();
                    ((CompletableFuture)callable.call()).whenComplete(new BiConsumer<T, Throwable>(){

                        @Override
                        public void accept(T innerResult, Throwable failure) {
                            if (failure != null && failure instanceof CompletionException) {
                                failure = failure.getCause();
                            }
                            execution.completeOrRetry(innerResult, failure);
                        }
                    });
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncCallableWrapper<T> ofFuture(final ContextualCallable<CompletableFuture<T>> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallableWrapper<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.before();
                    ((CompletableFuture)callable.call(this.execution)).whenComplete(new BiConsumer<T, Throwable>(){

                        @Override
                        public void accept(T innerResult, Throwable failure) {
                            if (failure != null && failure instanceof CompletionException) {
                                failure = failure.getCause();
                            }
                            execution.completeOrRetry(innerResult, failure);
                        }
                    });
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static abstract class AsyncCallableWrapper<T>
    implements Callable<T> {
        protected AsyncExecution execution;

        AsyncCallableWrapper() {
        }

        void inject(AsyncExecution execution) {
            this.execution = execution;
        }
    }

    static abstract class ContextualCallableWrapper<T>
    implements Callable<T> {
        protected ExecutionContext context;

        ContextualCallableWrapper() {
        }

        void inject(ExecutionContext context) {
            this.context = context;
        }
    }
}

