/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.Predicates;
import net.jodah.failsafe.function.BiPredicate;
import net.jodah.failsafe.function.Predicate;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.Duration;

public final class RetryPolicy {
    static final RetryPolicy NEVER = new RetryPolicy().withMaxRetries(0);
    private Duration delay;
    private double delayMultiplier;
    private Duration maxDelay;
    private Duration maxDuration;
    private int maxRetries;
    private boolean failureConditionChecked;
    private List<BiPredicate<Object, Throwable>> retryPredicates;
    private List<BiPredicate<Object, Throwable>> abortPredicates;

    public RetryPolicy() {
        this.delay = Duration.NONE;
        this.maxRetries = -1;
        this.abortPredicates = new ArrayList<BiPredicate<Object, Throwable>>();
        this.retryPredicates = new ArrayList<BiPredicate<Object, Throwable>>();
    }

    public RetryPolicy(RetryPolicy rp) {
        this.delay = rp.delay;
        this.delayMultiplier = rp.delayMultiplier;
        this.maxDelay = rp.maxDelay;
        this.maxDuration = rp.maxDuration;
        this.maxRetries = rp.maxRetries;
        this.retryPredicates = new ArrayList<BiPredicate<Object, Throwable>>(rp.retryPredicates);
        this.abortPredicates = new ArrayList<BiPredicate<Object, Throwable>>(rp.abortPredicates);
        this.failureConditionChecked = rp.failureConditionChecked;
    }

    public <T> RetryPolicy abortIf(BiPredicate<T, ? extends Throwable> completionPredicate) {
        Assert.notNull(completionPredicate, "completionPredicate");
        this.abortPredicates.add(completionPredicate);
        return this;
    }

    public <T> RetryPolicy abortIf(Predicate<T> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        this.abortPredicates.add(Predicates.resultPredicateFor(resultPredicate));
        return this;
    }

    public RetryPolicy abortOn(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "Failures cannot be empty", new Object[0]);
        return this.abortOn(Arrays.asList(failures));
    }

    public RetryPolicy abortOn(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        this.abortPredicates.add(Predicates.failurePredicateFor(failures));
        return this;
    }

    public RetryPolicy abortOn(Predicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        this.abortPredicates.add(Predicates.failurePredicateFor(failurePredicate));
        return this;
    }

    public RetryPolicy abortWhen(Object result) {
        this.abortPredicates.add(Predicates.resultPredicateFor(result));
        return this;
    }

    public boolean canAbortFor(Object result, Throwable failure) {
        for (BiPredicate<Object, Throwable> predicate : this.abortPredicates) {
            if (!predicate.test(result, failure)) continue;
            return true;
        }
        return false;
    }

    public boolean canRetry() {
        return !(this.maxRetries != -1 && this.maxRetries <= 0 || this.maxDuration != null && this.maxDuration.toNanos() <= 0L);
    }

    public boolean canRetryFor(Object result, Throwable failure) {
        if (!this.canRetry()) {
            return false;
        }
        for (BiPredicate<Object, Throwable> predicate : this.retryPredicates) {
            if (!predicate.test(result, failure)) continue;
            return true;
        }
        return failure != null && !this.failureConditionChecked;
    }

    public RetryPolicy copy() {
        return new RetryPolicy(this);
    }

    public Duration getDelay() {
        return this.delay;
    }

    public double getDelayMultiplier() {
        return this.delayMultiplier;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public <T> RetryPolicy retryIf(BiPredicate<T, ? extends Throwable> completionPredicate) {
        Assert.notNull(completionPredicate, "completionPredicate");
        this.failureConditionChecked = true;
        this.retryPredicates.add(completionPredicate);
        return this;
    }

    public <T> RetryPolicy retryIf(Predicate<T> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        this.retryPredicates.add(Predicates.resultPredicateFor(resultPredicate));
        return this;
    }

    public RetryPolicy retryOn(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "Failures cannot be empty", new Object[0]);
        return this.retryOn(Arrays.asList(failures));
    }

    public RetryPolicy retryOn(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        this.failureConditionChecked = true;
        this.retryPredicates.add(Predicates.failurePredicateFor(failures));
        return this;
    }

    public RetryPolicy retryOn(Predicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        this.failureConditionChecked = true;
        this.retryPredicates.add(Predicates.failurePredicateFor(failurePredicate));
        return this;
    }

    public RetryPolicy retryWhen(Object result) {
        this.retryPredicates.add(Predicates.resultPredicateFor(result));
        return this;
    }

    public RetryPolicy withBackoff(long delay, long maxDelay, TimeUnit timeUnit) {
        return this.withBackoff(delay, maxDelay, timeUnit, 2.0);
    }

    public RetryPolicy withBackoff(long delay, long maxDelay, TimeUnit timeUnit, double delayMultiplier) {
        Assert.notNull(timeUnit, "timeUnit");
        this.delay = new Duration(delay, timeUnit);
        this.maxDelay = new Duration(maxDelay, timeUnit);
        this.delayMultiplier = delayMultiplier;
        Assert.isTrue(this.delay.toNanos() > 0L, "The delay must be greater than 0", new Object[0]);
        if (this.maxDuration != null) {
            Assert.state(this.delay.toNanos() < this.maxDuration.toNanos(), "delay must be less than the maxDuration", new Object[0]);
        }
        Assert.isTrue(this.delay.toNanos() < this.maxDelay.toNanos(), "delay must be less than the maxDelay", new Object[0]);
        Assert.isTrue(delayMultiplier > 1.0, "delayMultiplier must be greater than 1", new Object[0]);
        return this;
    }

    public RetryPolicy withDelay(long delay, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        this.delay = new Duration(delay, timeUnit);
        Assert.isTrue(this.delay.toNanos() > 0L, "delay must be greater than 0", new Object[0]);
        if (this.maxDuration != null) {
            Assert.state(this.delay.toNanos() < this.maxDuration.toNanos(), "delay must be less than the maxDuration", new Object[0]);
        }
        Assert.state(this.maxDelay == null, "Backoff delays have already been set", new Object[0]);
        return this;
    }

    public RetryPolicy withMaxDuration(long maxDuration, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        this.maxDuration = new Duration(maxDuration, timeUnit);
        Assert.state(this.maxDuration.toNanos() > this.delay.toNanos(), "maxDuration must be greater than the delay", new Object[0]);
        return this;
    }

    public RetryPolicy withMaxRetries(int maxRetries) {
        Assert.isTrue(maxRetries >= -1, "maxRetries must be greater than or equal to -1", new Object[0]);
        this.maxRetries = maxRetries;
        return this;
    }
}

