/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.Callables;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.Listeners;
import net.jodah.failsafe.event.ContextualResultListener;
import net.jodah.failsafe.event.ContextualSuccessListener;
import net.jodah.failsafe.event.FailureListener;
import net.jodah.failsafe.event.ResultListener;
import net.jodah.failsafe.event.SuccessListener;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.concurrent.Scheduler;

public class ListenerBindings<S, T> {
    Listeners<T> listeners;
    ListenerConfig<T> listenerConfig;

    ListenerBindings() {
    }

    ListenerConfig<T> getConfig() {
        return this.listenerConfig != null ? this.listenerConfig : (this.listenerConfig = new ListenerConfig());
    }

    public S onAbort(FailureListener<? extends Throwable> listener) {
        ((ListenerConfig)this.getConfig()).abortListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onAbort(ResultListener<? extends T, ? extends Throwable> listener) {
        ((ListenerConfig)this.getConfig()).abortResultListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onAbort(ContextualResultListener<? extends T, ? extends Throwable> listener) {
        ((ListenerConfig)this.getConfig()).ctxAbortListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onAbortAsync(FailureListener<? extends Throwable> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncAbortListener = new AsyncResultListener<T>(ListenerBindings.resultListenerOf(listener), executor);
        return (S)this;
    }

    public S onAbortAsync(ResultListener<? extends T, ? extends Throwable> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncAbortResultListener = new AsyncResultListener<T>(listener, executor);
        return (S)this;
    }

    public S onAbortAsync(ContextualResultListener<? extends T, ? extends Throwable> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncCtxAbortListener = new AsyncCtxResultListener<T>(listener, executor);
        return (S)this;
    }

    public S onComplete(ContextualResultListener<? extends T, ? extends Throwable> listener) {
        ((ListenerConfig)this.getConfig()).ctxCompleteListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onComplete(ResultListener<? extends T, ? extends Throwable> listener) {
        ((ListenerConfig)this.getConfig()).completeListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onCompleteAsync(ContextualResultListener<? extends T, ? extends Throwable> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncCtxCompleteListener = new AsyncCtxResultListener<T>(listener, executor);
        return (S)this;
    }

    public S onCompleteAsync(ResultListener<? extends T, ? extends Throwable> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncCompleteListener = new AsyncResultListener<T>(listener, executor);
        return (S)this;
    }

    public S onFailedAttempt(ContextualResultListener<? extends T, ? extends Throwable> listener) {
        ((ListenerConfig)this.getConfig()).ctxFailedAttemptListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onFailedAttempt(FailureListener<? extends Throwable> listener) {
        ((ListenerConfig)this.getConfig()).failedAttemptListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onFailedAttempt(ResultListener<? extends T, ? extends Throwable> listener) {
        ((ListenerConfig)this.getConfig()).failedAttemptResultListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onFailedAttemptAsync(ContextualResultListener<? extends T, ? extends Throwable> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncCtxFailedAttemptListener = new AsyncCtxResultListener<T>(listener, executor);
        return (S)this;
    }

    public S onFailedAttemptAsync(FailureListener<? extends Throwable> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncFailedAttemptListener = new AsyncResultListener<T>(ListenerBindings.resultListenerOf(listener), executor);
        return (S)this;
    }

    public S onFailedAttemptAsync(ResultListener<? extends T, ? extends Throwable> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncFailedAttemptResultListener = new AsyncResultListener<T>(listener, executor);
        return (S)this;
    }

    public S onFailure(ContextualResultListener<? extends T, ? extends Throwable> listener) {
        ((ListenerConfig)this.getConfig()).ctxFailureListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onFailure(FailureListener<? extends Throwable> listener) {
        ((ListenerConfig)this.getConfig()).failureListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onFailure(ResultListener<? extends T, ? extends Throwable> listener) {
        ((ListenerConfig)this.getConfig()).failureResultListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onFailureAsync(ContextualResultListener<? extends T, ? extends Throwable> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncCtxFailureListener = new AsyncCtxResultListener<T>(listener, executor);
        return (S)this;
    }

    public S onFailureAsync(FailureListener<? extends Throwable> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncFailureListener = new AsyncResultListener<T>(ListenerBindings.resultListenerOf(listener), executor);
        return (S)this;
    }

    public S onFailureAsync(ResultListener<? extends T, ? extends Throwable> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncFailureResultListener = new AsyncResultListener<T>(listener, executor);
        return (S)this;
    }

    public S onRetry(ContextualResultListener<? extends T, ? extends Throwable> listener) {
        ((ListenerConfig)this.getConfig()).ctxRetryListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onRetry(FailureListener<? extends Throwable> listener) {
        ((ListenerConfig)this.getConfig()).retryListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onRetry(ResultListener<? extends T, ? extends Throwable> listener) {
        ((ListenerConfig)this.getConfig()).retryResultListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onRetryAsync(ContextualResultListener<? extends T, ? extends Throwable> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncCtxRetryListener = new AsyncCtxResultListener<T>(listener, executor);
        return (S)this;
    }

    public S onRetryAsync(FailureListener<? extends Throwable> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncRetryListener = new AsyncResultListener<T>(ListenerBindings.resultListenerOf(listener), executor);
        return (S)this;
    }

    public S onRetryAsync(ResultListener<? extends T, ? extends Throwable> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncRetryResultListener = new AsyncResultListener<T>(listener, executor);
        return (S)this;
    }

    public S onSuccess(ContextualSuccessListener<? extends T> listener) {
        ((ListenerConfig)this.getConfig()).ctxSuccessListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onSuccess(SuccessListener<? extends T> listener) {
        ((ListenerConfig)this.getConfig()).successListener = Assert.notNull(listener, "listener");
        return (S)this;
    }

    public S onSuccessAsync(ContextualSuccessListener<? extends T> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncCtxSuccessListener = new AsyncCtxResultListener<T>(ListenerBindings.resultListenerOf(listener), executor);
        return (S)this;
    }

    public S onSuccessAsync(SuccessListener<? extends T> listener, ExecutorService executor) {
        ((ListenerConfig)this.getConfig()).asyncSuccessListener = new AsyncResultListener<T>(ListenerBindings.resultListenerOf(listener), executor);
        return (S)this;
    }

    void complete(T result, Throwable failure, ExecutionContext context, boolean success) {
        if (success) {
            this.handleSuccess(result, context);
        } else {
            this.handleFailure(result, failure, context);
        }
        this.handleComplete(result, failure, context);
    }

    void handleAbort(T result, Throwable failure, ExecutionContext context) {
        if (this.listenerConfig != null) {
            ListenerBindings.call(((ListenerConfig)this.listenerConfig).abortListener, ((ListenerConfig)this.listenerConfig).abortResultListener, ((ListenerConfig)this.listenerConfig).ctxAbortListener, ((ListenerConfig)this.listenerConfig).asyncAbortListener, ((ListenerConfig)this.listenerConfig).asyncAbortResultListener, ((ListenerConfig)this.listenerConfig).asyncCtxAbortListener, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onAbort(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onAbort(result, failure, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void handleFailedAttempt(T result, Throwable failure, ExecutionContext context) {
        if (this.listenerConfig != null) {
            ListenerBindings.call(((ListenerConfig)this.listenerConfig).failedAttemptListener, ((ListenerConfig)this.listenerConfig).failedAttemptResultListener, ((ListenerConfig)this.listenerConfig).ctxFailedAttemptListener, ((ListenerConfig)this.listenerConfig).asyncFailedAttemptListener, ((ListenerConfig)this.listenerConfig).asyncFailedAttemptResultListener, ((ListenerConfig)this.listenerConfig).asyncCtxFailedAttemptListener, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onFailedAttempt(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onFailedAttempt(result, failure, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void handleRetry(T result, Throwable failure, ExecutionContext context) {
        if (this.listenerConfig != null) {
            ListenerBindings.call(((ListenerConfig)this.listenerConfig).retryListener, ((ListenerConfig)this.listenerConfig).retryResultListener, ((ListenerConfig)this.listenerConfig).ctxRetryListener, ((ListenerConfig)this.listenerConfig).asyncRetryListener, ((ListenerConfig)this.listenerConfig).asyncRetryResultListener, ((ListenerConfig)this.listenerConfig).asyncCtxRetryListener, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onRetry(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onRetry(result, failure, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void handleSuccess(T result, ExecutionContext context) {
        if (this.listenerConfig != null) {
            ListenerBindings.call(((ListenerConfig)this.listenerConfig).successListener, ((ListenerConfig)this.listenerConfig).ctxSuccessListener, ((ListenerConfig)this.listenerConfig).asyncSuccessListener, ((ListenerConfig)this.listenerConfig).asyncCtxSuccessListener, result, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onSuccess(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onSuccess(result, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void handleComplete(T result, Throwable failure, ExecutionContext context) {
        if (this.listenerConfig != null) {
            ListenerBindings.call(null, ((ListenerConfig)this.listenerConfig).completeListener, ((ListenerConfig)this.listenerConfig).ctxCompleteListener, null, ((ListenerConfig)this.listenerConfig).asyncCompleteListener, ((ListenerConfig)this.listenerConfig).asyncCtxCompleteListener, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onComplete(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onComplete(result, failure, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void handleFailure(T result, Throwable failure, ExecutionContext context) {
        if (this.listenerConfig != null) {
            ListenerBindings.call(((ListenerConfig)this.listenerConfig).failureListener, ((ListenerConfig)this.listenerConfig).failureResultListener, ((ListenerConfig)this.listenerConfig).ctxFailureListener, ((ListenerConfig)this.listenerConfig).asyncFailureListener, ((ListenerConfig)this.listenerConfig).asyncFailureResultListener, ((ListenerConfig)this.listenerConfig).asyncCtxFailureListener, result, failure, context);
        }
        if (this.listeners != null) {
            try {
                this.listeners.onFailure(result, failure);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.listeners.onFailure(result, failure, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static <T> ContextualResultListener<T, Throwable> resultListenerOf(final ContextualSuccessListener<T> listener) {
        Assert.notNull(listener, "listener");
        return new ContextualResultListener<T, Throwable>(){

            @Override
            public void onResult(T result, Throwable failure, ExecutionContext context) {
                listener.onSuccess(result, context);
            }
        };
    }

    static <T> ResultListener<T, Throwable> resultListenerOf(final FailureListener<? extends Throwable> listener) {
        Assert.notNull(listener, "listener");
        return new ResultListener<T, Throwable>(){

            @Override
            public void onResult(T result, Throwable failure) {
                listener.onFailure(failure);
            }
        };
    }

    static <T> ResultListener<T, Throwable> resultListenerOf(final SuccessListener<T> listener) {
        Assert.notNull(listener, "listener");
        return new ResultListener<T, Throwable>(){

            @Override
            public void onResult(T result, Throwable failure) {
                listener.onSuccess(result);
            }
        };
    }

    private static <T> void call(FailureListener<Throwable> l1, ResultListener<T, Throwable> l2, ContextualResultListener<T, Throwable> l3, AsyncResultListener<T> l4, AsyncResultListener<T> l5, AsyncCtxResultListener<T> l6, T result, Throwable failure, ExecutionContext context) {
        if (l1 != null) {
            ListenerBindings.call(l1, failure);
        }
        if (l2 != null) {
            ListenerBindings.call(l2, result, failure);
        }
        if (l3 != null) {
            ListenerBindings.call(l3, result, failure, context);
        }
        if (l4 != null) {
            ListenerBindings.call(l4, result, failure, null);
        }
        if (l5 != null) {
            ListenerBindings.call(l5, result, failure, null);
        }
        if (l6 != null) {
            ListenerBindings.call(l6, result, failure, context, null);
        }
    }

    private static <T> void call(SuccessListener<T> l1, ContextualSuccessListener<T> l2, AsyncResultListener<T> l3, AsyncCtxResultListener<T> l4, T result, ExecutionContext context) {
        if (l1 != null) {
            ListenerBindings.call(l1, result);
        }
        if (l2 != null) {
            ListenerBindings.call(l2, result, context);
        }
        if (l3 != null) {
            ListenerBindings.call(l3, result, null, null);
        }
        if (l4 != null) {
            ListenerBindings.call(l4, result, null, context, null);
        }
    }

    private static <T> void call(FailureListener<Throwable> listener, Throwable failure) {
        try {
            listener.onFailure(failure);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static <T> void call(ResultListener<T, Throwable> listener, T result, Throwable failure) {
        try {
            listener.onResult(result, failure);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static <T> void call(ContextualResultListener<T, Throwable> listener, T result, Throwable failure, ExecutionContext context) {
        try {
            listener.onResult(result, failure, context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static <T> void call(SuccessListener<T> listener, T result) {
        try {
            listener.onSuccess(result);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static <T> void call(ContextualSuccessListener<T> listener, T result, ExecutionContext context) {
        try {
            listener.onSuccess(result, context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static <T> void call(AsyncResultListener<T> listener, T result, Throwable failure, Scheduler scheduler) {
        ListenerBindings.call(Callables.of(listener.listener, result, failure), listener.executor, scheduler);
    }

    static <T> void call(AsyncCtxResultListener<T> listener, T result, Throwable failure, ExecutionContext context, Scheduler scheduler) {
        ListenerBindings.call(Callables.of(listener.listener, result, failure, context.copy()), listener.executor, scheduler);
    }

    private static void call(Callable<?> callable, ExecutorService executor, Scheduler scheduler) {
        try {
            if (executor != null) {
                executor.submit(callable);
            } else {
                scheduler.schedule(callable, 0L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class AsyncResultListener<T> {
        ResultListener<T, Throwable> listener;
        ExecutorService executor;

        AsyncResultListener(ResultListener<? extends T, ? extends Throwable> listener) {
            this.listener = Assert.notNull(listener, "listener");
            this.executor = null;
        }

        AsyncResultListener(ResultListener<? extends T, ? extends Throwable> listener, ExecutorService executor) {
            this.listener = Assert.notNull(listener, "listener");
            this.executor = Assert.notNull(executor, "executor");
        }
    }

    static class AsyncCtxResultListener<T> {
        ContextualResultListener<T, Throwable> listener;
        ExecutorService executor;

        AsyncCtxResultListener(ContextualResultListener<? extends T, ? extends Throwable> listener) {
            this.listener = Assert.notNull(listener, "listener");
            this.executor = null;
        }

        AsyncCtxResultListener(ContextualResultListener<? extends T, ? extends Throwable> listener, ExecutorService executor) {
            this.listener = Assert.notNull(listener, "listener");
            this.executor = Assert.notNull(executor, "executor");
        }
    }

    static class ListenerConfig<T> {
        private FailureListener<Throwable> failedAttemptListener;
        private ResultListener<T, Throwable> failedAttemptResultListener;
        private ContextualResultListener<T, Throwable> ctxFailedAttemptListener;
        private AsyncResultListener<T> asyncFailedAttemptListener;
        private AsyncResultListener<T> asyncFailedAttemptResultListener;
        private AsyncCtxResultListener<T> asyncCtxFailedAttemptListener;
        private FailureListener<Throwable> retryListener;
        private ResultListener<T, Throwable> retryResultListener;
        private ContextualResultListener<T, Throwable> ctxRetryListener;
        private AsyncResultListener<T> asyncRetryListener;
        private AsyncResultListener<T> asyncRetryResultListener;
        private AsyncCtxResultListener<T> asyncCtxRetryListener;
        private ResultListener<T, Throwable> completeListener;
        private ContextualResultListener<T, Throwable> ctxCompleteListener;
        private AsyncResultListener<T> asyncCompleteListener;
        private AsyncCtxResultListener<T> asyncCtxCompleteListener;
        private FailureListener<Throwable> failureListener;
        private ResultListener<T, Throwable> failureResultListener;
        private ContextualResultListener<T, Throwable> ctxFailureListener;
        private AsyncResultListener<T> asyncFailureListener;
        private AsyncResultListener<T> asyncFailureResultListener;
        private AsyncCtxResultListener<T> asyncCtxFailureListener;
        private FailureListener<Throwable> abortListener;
        private ResultListener<T, Throwable> abortResultListener;
        private ContextualResultListener<T, Throwable> ctxAbortListener;
        private AsyncResultListener<T> asyncAbortListener;
        private AsyncResultListener<T> asyncAbortResultListener;
        private AsyncCtxResultListener<T> asyncCtxAbortListener;
        private SuccessListener<T> successListener;
        private ContextualSuccessListener<T> ctxSuccessListener;
        private AsyncResultListener<T> asyncSuccessListener;
        private AsyncCtxResultListener<T> asyncCtxSuccessListener;

        ListenerConfig() {
        }
    }
}

