/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.ListenerBindings;
import net.jodah.failsafe.event.ContextualResultListener;
import net.jodah.failsafe.event.ContextualSuccessListener;
import net.jodah.failsafe.event.FailureListener;
import net.jodah.failsafe.event.ResultListener;
import net.jodah.failsafe.event.SuccessListener;
import net.jodah.failsafe.util.concurrent.Scheduler;

public class AsyncListenerBindings<S, T>
extends ListenerBindings<S, T> {
    AsyncListenerConfig<T> asyncListenerConfig;
    final Scheduler scheduler;

    AsyncListenerBindings(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    AsyncListenerConfig<T> getAsyncConfig() {
        return this.asyncListenerConfig != null ? this.asyncListenerConfig : (this.asyncListenerConfig = new AsyncListenerConfig());
    }

    public S onAbortAsync(ContextualResultListener<? extends T, ? extends Throwable> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncCtxAbortListener = new ListenerBindings.AsyncCtxResultListener<T>(listener);
        return (S)this;
    }

    public S onAbortAsync(FailureListener<? extends Throwable> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncAbortListener = new ListenerBindings.AsyncResultListener(ListenerBindings.resultListenerOf(listener));
        return (S)this;
    }

    public S onAbortAsync(ResultListener<? extends T, ? extends Throwable> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncAbortResultListener = new ListenerBindings.AsyncResultListener<T>(listener);
        return (S)this;
    }

    public S onCompleteAsync(ContextualResultListener<? extends T, ? extends Throwable> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncCtxCompleteListener = new ListenerBindings.AsyncCtxResultListener<T>(listener);
        return (S)this;
    }

    public S onCompleteAsync(ResultListener<? extends T, ? extends Throwable> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncCompleteListener = new ListenerBindings.AsyncResultListener<T>(listener);
        return (S)this;
    }

    public S onFailedAttemptAsync(ContextualResultListener<? extends T, ? extends Throwable> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncCtxFailedAttemptListener = new ListenerBindings.AsyncCtxResultListener<T>(listener);
        return (S)this;
    }

    public S onFailedAttemptAsync(FailureListener<? extends Throwable> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncFailedAttemptListener = new ListenerBindings.AsyncResultListener(ListenerBindings.resultListenerOf(listener));
        return (S)this;
    }

    public S onFailedAttemptAsync(ResultListener<? extends T, ? extends Throwable> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncFailedAttemptResultListener = new ListenerBindings.AsyncResultListener<T>(listener);
        return (S)this;
    }

    public S onFailureAsync(ContextualResultListener<? extends T, ? extends Throwable> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncCtxFailureListener = new ListenerBindings.AsyncCtxResultListener<T>(listener);
        return (S)this;
    }

    public S onFailureAsync(FailureListener<? extends Throwable> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncFailureListener = new ListenerBindings.AsyncResultListener(ListenerBindings.resultListenerOf(listener));
        return (S)this;
    }

    public S onFailureAsync(ResultListener<? extends T, ? extends Throwable> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncFailureResultListener = new ListenerBindings.AsyncResultListener<T>(listener);
        return (S)this;
    }

    public S onRetryAsync(ContextualResultListener<? extends T, ? extends Throwable> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncCtxRetryListener = new ListenerBindings.AsyncCtxResultListener<T>(listener);
        return (S)this;
    }

    public S onRetryAsync(FailureListener<? extends Throwable> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncRetryListener = new ListenerBindings.AsyncResultListener(ListenerBindings.resultListenerOf(listener));
        return (S)this;
    }

    public S onRetryAsync(ResultListener<? extends T, ? extends Throwable> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncRetryResultListener = new ListenerBindings.AsyncResultListener<T>(listener);
        return (S)this;
    }

    public S onSuccessAsync(ContextualSuccessListener<? extends T> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncCtxSuccessListener = new ListenerBindings.AsyncCtxResultListener<T>(ListenerBindings.resultListenerOf(listener));
        return (S)this;
    }

    public S onSuccessAsync(SuccessListener<? extends T> listener) {
        ((AsyncListenerConfig)this.getAsyncConfig()).asyncSuccessListener = new ListenerBindings.AsyncResultListener<T>(ListenerBindings.resultListenerOf(listener));
        return (S)this;
    }

    @Override
    void handleAbort(T result, Throwable failure, ExecutionContext context) {
        super.handleAbort(result, failure, context);
        if (this.asyncListenerConfig != null) {
            this.call(((AsyncListenerConfig)this.asyncListenerConfig).asyncAbortListener, ((AsyncListenerConfig)this.asyncListenerConfig).asyncAbortResultListener, ((AsyncListenerConfig)this.asyncListenerConfig).asyncCtxAbortListener, result, failure, context);
        }
    }

    @Override
    void handleFailedAttempt(T result, Throwable failure, ExecutionContext context) {
        super.handleFailedAttempt(result, failure, context);
        if (this.asyncListenerConfig != null) {
            this.call(((AsyncListenerConfig)this.asyncListenerConfig).asyncFailedAttemptListener, ((AsyncListenerConfig)this.asyncListenerConfig).asyncFailedAttemptResultListener, ((AsyncListenerConfig)this.asyncListenerConfig).asyncCtxFailedAttemptListener, result, failure, context);
        }
    }

    @Override
    void handleRetry(T result, Throwable failure, ExecutionContext context) {
        super.handleRetry(result, failure, context);
        if (this.asyncListenerConfig != null) {
            this.call(((AsyncListenerConfig)this.asyncListenerConfig).asyncRetryListener, ((AsyncListenerConfig)this.asyncListenerConfig).asyncRetryResultListener, ((AsyncListenerConfig)this.asyncListenerConfig).asyncCtxRetryListener, result, failure, context);
        }
    }

    @Override
    void handleComplete(T result, Throwable failure, ExecutionContext context) {
        super.handleComplete(result, failure, context);
        if (this.asyncListenerConfig != null) {
            this.call(null, ((AsyncListenerConfig)this.asyncListenerConfig).asyncCompleteListener, ((AsyncListenerConfig)this.asyncListenerConfig).asyncCtxCompleteListener, result, failure, context);
        }
    }

    @Override
    void handleFailure(T result, Throwable failure, ExecutionContext context) {
        super.handleFailure(result, failure, context);
        if (this.asyncListenerConfig != null) {
            this.call(((AsyncListenerConfig)this.asyncListenerConfig).asyncFailureListener, ((AsyncListenerConfig)this.asyncListenerConfig).asyncFailureResultListener, ((AsyncListenerConfig)this.asyncListenerConfig).asyncCtxFailureListener, result, failure, context);
        }
    }

    @Override
    void handleSuccess(T result, ExecutionContext context) {
        super.handleSuccess(result, context);
        if (this.asyncListenerConfig != null) {
            this.call(null, ((AsyncListenerConfig)this.asyncListenerConfig).asyncSuccessListener, ((AsyncListenerConfig)this.asyncListenerConfig).asyncCtxSuccessListener, result, null, context);
        }
    }

    private void call(ListenerBindings.AsyncResultListener<T> l1, ListenerBindings.AsyncResultListener<T> l2, ListenerBindings.AsyncCtxResultListener<T> l3, T result, Throwable failure, ExecutionContext context) {
        if (l1 != null) {
            AsyncListenerBindings.call(l1, result, failure, this.scheduler);
        }
        if (l2 != null) {
            AsyncListenerBindings.call(l2, result, failure, this.scheduler);
        }
        if (l3 != null) {
            AsyncListenerBindings.call(l3, result, failure, context, this.scheduler);
        }
    }

    static class AsyncListenerConfig<T> {
        private ListenerBindings.AsyncResultListener<T> asyncFailedAttemptListener;
        private ListenerBindings.AsyncResultListener<T> asyncFailedAttemptResultListener;
        private ListenerBindings.AsyncCtxResultListener<T> asyncCtxFailedAttemptListener;
        private ListenerBindings.AsyncResultListener<T> asyncRetryListener;
        private ListenerBindings.AsyncResultListener<T> asyncRetryResultListener;
        private ListenerBindings.AsyncCtxResultListener<T> asyncCtxRetryListener;
        private ListenerBindings.AsyncResultListener<T> asyncCompleteListener;
        private ListenerBindings.AsyncCtxResultListener<T> asyncCtxCompleteListener;
        private ListenerBindings.AsyncResultListener<T> asyncAbortListener;
        private ListenerBindings.AsyncResultListener<T> asyncAbortResultListener;
        private ListenerBindings.AsyncCtxResultListener<T> asyncCtxAbortListener;
        private ListenerBindings.AsyncResultListener<T> asyncFailureListener;
        private ListenerBindings.AsyncResultListener<T> asyncFailureResultListener;
        private ListenerBindings.AsyncCtxResultListener<T> asyncCtxFailureListener;
        private ListenerBindings.AsyncResultListener<T> asyncSuccessListener;
        private ListenerBindings.AsyncCtxResultListener<T> asyncCtxSuccessListener;

        AsyncListenerConfig() {
        }
    }
}

