/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.AsyncExecution;
import net.jodah.failsafe.AsyncListenerBindings;
import net.jodah.failsafe.Callables;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.CircuitBreakerOpenException;
import net.jodah.failsafe.FailsafeFuture;
import net.jodah.failsafe.Listeners;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.SyncFailsafe;
import net.jodah.failsafe.function.AsyncCallable;
import net.jodah.failsafe.function.AsyncRunnable;
import net.jodah.failsafe.function.CheckedRunnable;
import net.jodah.failsafe.function.ContextualCallable;
import net.jodah.failsafe.function.ContextualRunnable;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.concurrent.Scheduler;

public class AsyncFailsafe<L>
extends AsyncListenerBindings<AsyncFailsafe<L>, L> {
    private RetryPolicy retryPolicy;
    private CircuitBreaker circuitBreaker;

    AsyncFailsafe(SyncFailsafe<L> failsafe, Scheduler scheduler) {
        super(scheduler);
        this.retryPolicy = failsafe.retryPolicy;
        this.circuitBreaker = failsafe.circuitBreaker;
        this.listeners = failsafe.listeners;
        this.listenerConfig = failsafe.listenerConfig;
    }

    public <T> FailsafeFuture<T> get(Callable<T> callable) {
        return this.call(Callables.asyncOf(callable), null);
    }

    public <T> FailsafeFuture<T> get(ContextualCallable<T> callable) {
        return this.call(Callables.asyncOf(callable), null);
    }

    public <T> FailsafeFuture<T> getAsync(AsyncCallable<T> callable) {
        return this.call(Callables.asyncOf(callable), null);
    }

    public FailsafeFuture<Void> run(CheckedRunnable runnable) {
        return this.call(Callables.asyncOf(runnable), null);
    }

    public FailsafeFuture<Void> run(ContextualRunnable runnable) {
        return this.call(Callables.asyncOf(runnable), null);
    }

    public FailsafeFuture<Void> runAsync(AsyncRunnable runnable) {
        return this.call(Callables.asyncOf(runnable), null);
    }

    public <T> CompletableFuture<T> future(Callable<CompletableFuture<T>> callable) {
        CompletableFuture response = new CompletableFuture();
        this.call(Callables.ofFuture(callable), new FailsafeFuture(response));
        return response;
    }

    public <T> CompletableFuture<T> future(ContextualCallable<CompletableFuture<T>> callable) {
        CompletableFuture response = new CompletableFuture();
        this.call(Callables.ofFuture(callable), new FailsafeFuture(response));
        return response;
    }

    public <T> CompletableFuture<T> futureAsync(AsyncCallable<CompletableFuture<T>> callable) {
        CompletableFuture response = new CompletableFuture();
        this.call(Callables.ofFuture(callable), new FailsafeFuture(response));
        return response;
    }

    public AsyncFailsafe<L> with(CircuitBreaker circuitBreaker) {
        Assert.state(this.circuitBreaker == null, "A circuit breaker has already been configurd", new Object[0]);
        this.circuitBreaker = Assert.notNull(circuitBreaker, "circuitBreaker");
        return this;
    }

    public AsyncFailsafe<L> with(RetryPolicy retryPolicy) {
        Assert.state(this.retryPolicy == RetryPolicy.NEVER, "A retry policy has already been configurd", new Object[0]);
        this.retryPolicy = Assert.notNull(retryPolicy, "retryPolicy");
        return this;
    }

    public <T> AsyncFailsafe<T> with(Listeners<T> listeners) {
        this.listeners = Assert.notNull(listeners, "listeners");
        return this;
    }

    private <T> FailsafeFuture<T> call(Callables.AsyncCallableWrapper<T> callable, FailsafeFuture<T> future) {
        if (this.circuitBreaker != null) {
            this.circuitBreaker.initialize();
            if (!this.circuitBreaker.allowsExecution()) {
                throw new CircuitBreakerOpenException();
            }
        }
        if (future == null) {
            future = new FailsafeFuture();
        }
        AsyncExecution execution = new AsyncExecution(callable, this.retryPolicy, this.circuitBreaker, this.scheduler, future, this);
        callable.inject(execution);
        try {
            future.setFuture(this.scheduler.schedule(callable, 0L, TimeUnit.MILLISECONDS));
        }
        catch (Throwable t) {
            this.complete(null, t, execution, false);
            future.complete(null, t);
        }
        return future;
    }
}

