/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.CircuitBreakerOpenException;
import net.jodah.failsafe.FailsafeFuture;
import net.jodah.failsafe.ListenerBindings;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.concurrent.Scheduler;

public final class AsyncExecution
extends AbstractExecution {
    private final Callable<Object> callable;
    private final FailsafeFuture<Object> future;
    private final Scheduler scheduler;
    volatile boolean completeCalled;
    volatile boolean retryCalled;

    <T> AsyncExecution(Callable<T> callable, RetryPolicy retryPolicy, CircuitBreaker circuitBreaker, Scheduler scheduler, FailsafeFuture<T> future, ListenerBindings<?, Object> listeners) {
        super(retryPolicy, circuitBreaker, listeners);
        this.callable = callable;
        this.scheduler = scheduler;
        this.future = future;
    }

    public void complete() {
        this.complete(null, null, false);
    }

    public boolean complete(Object result) {
        return this.complete(result, null, true);
    }

    public boolean complete(Object result, Throwable failure) {
        return this.complete(result, failure, true);
    }

    public boolean retry() {
        Assert.state(!this.retryCalled, "Retry has already been called", new Object[0]);
        this.retryCalled = true;
        return this.completeOrRetry(this.lastResult, this.lastFailure);
    }

    public boolean retryFor(Object result) {
        return this.retryFor(result, null);
    }

    public boolean retryFor(Object result, Throwable failure) {
        Assert.state(!this.retryCalled, "Retry has already been called", new Object[0]);
        this.retryCalled = true;
        return this.completeOrRetry(result, failure);
    }

    public boolean retryOn(Throwable failure) {
        Assert.notNull(failure, "failure");
        return this.retryFor(null, failure);
    }

    @Override
    void before() {
        if (this.circuitBreaker != null && !this.circuitBreaker.allowsExecution()) {
            this.completed = true;
            CircuitBreakerOpenException failure = new CircuitBreakerOpenException();
            if (this.listeners != null) {
                this.listeners.complete(null, failure, this, false);
            }
            this.future.complete(null, failure);
            return;
        }
        if (this.completeCalled && this.listeners != null) {
            this.listeners.handleRetry(this.lastResult, this.lastFailure, this);
        }
        super.before();
        this.completeCalled = false;
        this.retryCalled = false;
    }

    @Override
    synchronized boolean complete(Object result, Throwable failure, boolean checkArgs) {
        if (!this.completeCalled) {
            if (super.complete(result, failure, checkArgs)) {
                this.future.complete(result, failure);
            }
            this.completeCalled = true;
        }
        return this.completed;
    }

    synchronized boolean completeOrRetry(Object result, Throwable failure) {
        if (!(this.complete(result, failure, true) || this.future.isDone() || this.future.isCancelled())) {
            try {
                this.future.setFuture(this.scheduler.schedule(this.callable, this.waitNanos, TimeUnit.NANOSECONDS));
                return true;
            }
            catch (Throwable t) {
                failure = t;
                if (this.listeners != null) {
                    this.listeners.complete(null, t, this, false);
                }
                this.future.complete(null, failure);
            }
        }
        return false;
    }
}

