/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.ListenerBindings;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.Duration;

abstract class AbstractExecution
extends ExecutionContext {
    final RetryPolicy retryPolicy;
    final CircuitBreaker circuitBreaker;
    final ListenerBindings<?, Object> listeners;
    long attemptStartTime;
    volatile Object lastResult;
    volatile Throwable lastFailure;
    volatile boolean completed;
    volatile boolean success;
    volatile long waitNanos;

    AbstractExecution(RetryPolicy retryPolicy, CircuitBreaker circuitBreaker, ListenerBindings<?, Object> listeners) {
        super(new Duration(System.nanoTime(), TimeUnit.NANOSECONDS));
        this.retryPolicy = retryPolicy;
        this.circuitBreaker = circuitBreaker;
        this.listeners = listeners;
        this.waitNanos = retryPolicy.getDelay().toNanos();
    }

    public <T extends Throwable> T getLastFailure() {
        return (T)this.lastFailure;
    }

    public <T> T getLastResult() {
        return (T)this.lastResult;
    }

    public Duration getWaitTime() {
        return new Duration(this.waitNanos, TimeUnit.NANOSECONDS);
    }

    public boolean isComplete() {
        return this.completed;
    }

    void before() {
        if (this.circuitBreaker != null) {
            this.circuitBreaker.before();
        }
        this.attemptStartTime = System.nanoTime();
    }

    boolean complete(Object result, Throwable failure, boolean checkArgs) {
        Assert.state(!this.completed, "Execution has already been completed", new Object[0]);
        ++this.executions;
        this.lastResult = result;
        this.lastFailure = failure;
        long elapsedNanos = this.getElapsedTime().toNanos();
        if (this.circuitBreaker != null) {
            boolean timeoutExceeded;
            Duration timeout = this.circuitBreaker.getTimeout();
            boolean bl = timeoutExceeded = timeout != null && elapsedNanos >= timeout.toNanos();
            if (this.circuitBreaker.isFailure(result, failure) || timeoutExceeded) {
                this.circuitBreaker.recordFailure();
            } else {
                this.circuitBreaker.recordSuccess();
            }
        }
        if (this.retryPolicy.getMaxDuration() != null) {
            long maxRemainingWaitTime = this.retryPolicy.getMaxDuration().toNanos() - elapsedNanos;
            this.waitNanos = Math.min(this.waitNanos, maxRemainingWaitTime < 0L ? 0L : maxRemainingWaitTime);
            if (this.waitNanos < 0L) {
                this.waitNanos = 0L;
            }
        }
        if (this.retryPolicy.getMaxDelay() != null) {
            this.waitNanos = (long)Math.min((double)this.waitNanos * this.retryPolicy.getDelayMultiplier(), (double)this.retryPolicy.getMaxDelay().toNanos());
        }
        boolean maxRetriesExceeded = this.retryPolicy.getMaxRetries() != -1 && this.executions > this.retryPolicy.getMaxRetries();
        boolean maxDurationExceeded = this.retryPolicy.getMaxDuration() != null && elapsedNanos > this.retryPolicy.getMaxDuration().toNanos();
        boolean shouldAbort = this.retryPolicy.canAbortFor(result, failure);
        boolean shouldRetry = checkArgs && this.retryPolicy.canRetryFor(result, failure);
        this.completed = maxRetriesExceeded || maxDurationExceeded || !shouldRetry || shouldAbort;
        boolean bl = this.success = this.completed && !shouldRetry && !shouldAbort && failure == null;
        if (this.listeners != null) {
            if (!this.success) {
                this.listeners.handleFailedAttempt(result, failure, this);
            }
            if (shouldAbort) {
                this.listeners.handleAbort(result, failure, this);
            }
            if (this.completed) {
                this.listeners.complete(result, failure, this, this.success);
            }
        }
        return this.completed;
    }
}

