/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal;

import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.internal.CircuitBreakerStats;
import net.jodah.failsafe.internal.CircuitState;
import net.jodah.failsafe.internal.util.CircularBitSet;
import net.jodah.failsafe.internal.util.Ratio;

public class HalfOpenState
implements CircuitState {
    private final CircuitBreaker circuit;
    private final Integer successThresh;
    private final Integer failureThresh;
    private final Ratio successRatio;
    private final Ratio failureRatio;
    private final int maxConcurrentExecutions;
    private volatile int executions;
    private volatile int successiveSuccesses;
    private volatile int successiveFailures;
    private CircularBitSet bitSet;

    public HalfOpenState(CircuitBreaker circuit) {
        this.circuit = circuit;
        this.successThresh = circuit.getSuccessThreshold();
        this.failureThresh = circuit.getFailureThreshold();
        this.successRatio = circuit.getSuccessThresholdRatio();
        this.failureRatio = circuit.getFailureThresholdRatio();
        this.maxConcurrentExecutions = this.maxConcurrentExecutions();
        if (this.successRatio != null) {
            this.bitSet = new CircularBitSet(this.successRatio.denominator);
        }
        if (this.failureRatio != null) {
            this.bitSet = new CircularBitSet(this.failureRatio.denominator);
        }
    }

    @Override
    public boolean allowsExecution(CircuitBreakerStats stats) {
        return stats.getCurrentExecutions() < this.maxConcurrentExecutions;
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.HALF_OPEN;
    }

    @Override
    public synchronized void recordFailure() {
        ++this.executions;
        ++this.successiveFailures;
        this.successiveSuccesses = 0;
        if (this.bitSet != null) {
            this.bitSet.setNext(false);
        }
        this.checkThreshold();
    }

    @Override
    public synchronized void recordSuccess() {
        ++this.executions;
        ++this.successiveSuccesses;
        this.successiveFailures = 0;
        if (this.bitSet != null) {
            this.bitSet.setNext(true);
        }
        this.checkThreshold();
    }

    int maxConcurrentExecutions() {
        if (this.successRatio != null) {
            return this.successRatio.denominator;
        }
        if (this.successThresh != null) {
            return this.successThresh;
        }
        if (this.failureRatio != null) {
            return this.failureRatio.denominator;
        }
        if (this.failureThresh != null) {
            return this.failureThresh;
        }
        return 1;
    }

    synchronized void checkThreshold() {
        if (this.successRatio != null && this.executions == this.successRatio.denominator) {
            if (this.bitSet.positiveRatio() >= this.successRatio.ratio) {
                this.circuit.close();
            } else {
                this.circuit.open();
            }
        }
        if (this.successThresh != null) {
            if (this.successiveSuccesses == this.successThresh) {
                this.circuit.close();
            } else if (this.failureThresh == null && this.failureRatio == null && this.successiveFailures == 1) {
                this.circuit.open();
            }
        }
        if (this.failureRatio != null && this.executions == this.failureRatio.denominator) {
            if (this.bitSet.negativeRatio() >= this.failureRatio.ratio) {
                this.circuit.open();
            } else {
                this.circuit.close();
            }
        }
        if (this.failureThresh != null) {
            if (this.successiveFailures == this.failureThresh) {
                this.circuit.open();
            } else if (this.successThresh == null && this.successRatio == null && this.successiveSuccesses == 1) {
                this.circuit.close();
            }
        }
        if (this.successThresh == null && this.failureThresh == null && this.successRatio == null && this.failureRatio == null) {
            if (this.successiveSuccesses == 1) {
                this.circuit.close();
            } else {
                this.circuit.open();
            }
        }
    }
}

