/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.function.BiPredicate;
import net.jodah.failsafe.function.Predicate;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.Duration;

public final class RetryPolicy {
    static final RetryPolicy NEVER = new RetryPolicy().withMaxRetries(0);
    private static final Object DEFAULT_VALUE = new Object();
    private Duration delay;
    private double delayMultiplier;
    private Duration maxDelay;
    private Duration maxDuration;
    private int maxRetries;
    private List<Class<? extends Throwable>> retryableFailures;
    private List<Class<? extends Throwable>> abortableFailures;
    private Predicate<Throwable> retryableFailurePredicate;
    private Predicate<Throwable> abortableFailurePredicate;
    private Object retryableValue = DEFAULT_VALUE;
    private Object abortableValue = DEFAULT_VALUE;
    private Predicate<Object> retryableResultPredicate;
    private Predicate<Object> abortableResultPredicate;
    private BiPredicate<Object, Throwable> retryableCompletionPredicate;
    private BiPredicate<Object, Throwable> abortableCompletionPredicate;

    public RetryPolicy() {
        this.delay = Duration.NONE;
        this.maxRetries = -1;
    }

    public RetryPolicy(RetryPolicy rp) {
        this.delay = rp.delay;
        this.delayMultiplier = rp.delayMultiplier;
        this.maxDelay = rp.maxDelay;
        this.maxDuration = rp.maxDuration;
        this.maxRetries = rp.maxRetries;
        this.retryableFailures = rp.retryableFailures;
        this.abortableFailures = rp.abortableFailures;
        this.retryableFailurePredicate = rp.retryableFailurePredicate;
        this.abortableFailurePredicate = rp.abortableFailurePredicate;
        this.retryableValue = rp.retryableValue;
        this.abortableValue = rp.abortableValue;
        this.retryableResultPredicate = rp.retryableResultPredicate;
        this.abortableResultPredicate = rp.abortableResultPredicate;
        this.retryableCompletionPredicate = rp.retryableCompletionPredicate;
        this.abortableCompletionPredicate = rp.abortableCompletionPredicate;
    }

    public <T> RetryPolicy abortIf(BiPredicate<T, ? extends Throwable> completionPredicate) {
        Assert.notNull(completionPredicate, "completionPredicate");
        this.abortableCompletionPredicate = completionPredicate;
        return this;
    }

    public <T> RetryPolicy abortIf(Predicate<T> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        this.abortableResultPredicate = resultPredicate;
        return this;
    }

    public RetryPolicy abortOn(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "Failures cannot be empty", new Object[0]);
        this.abortableFailures = Arrays.asList(failures);
        return this;
    }

    public RetryPolicy abortOn(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        this.abortableFailures = failures;
        return this;
    }

    public RetryPolicy abortOn(Predicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        this.abortableFailurePredicate = failurePredicate;
        return this;
    }

    public RetryPolicy abortWhen(Object result) {
        this.abortableValue = result;
        return this;
    }

    public boolean canAbortFor(Object result, Throwable failure) {
        if (this.abortableCompletionPredicate != null && this.abortableCompletionPredicate.test(result, failure)) {
            return true;
        }
        if (failure != null) {
            if (this.abortableFailurePredicate != null && this.abortableFailurePredicate.test(failure)) {
                return true;
            }
            if (this.abortableFailures != null) {
                for (Class<? extends Throwable> failureType : this.abortableFailures) {
                    if (!failureType.isAssignableFrom(failure.getClass())) continue;
                    return true;
                }
            }
        }
        if (this.abortableResultPredicate != null && this.abortableResultPredicate.test(result)) {
            return true;
        }
        return !DEFAULT_VALUE.equals(this.abortableValue) && this.abortableValue == null ? result == null : this.abortableValue.equals(result);
    }

    public boolean canRetry() {
        return !(this.maxRetries != -1 && this.maxRetries <= 0 || this.maxDuration != null && this.maxDuration.toNanos() <= 0L);
    }

    public boolean canRetryFor(Object result, Throwable failure) {
        if (!this.canRetry()) {
            return false;
        }
        if (this.retryableCompletionPredicate != null && this.retryableCompletionPredicate.test(result, failure)) {
            return true;
        }
        if (failure != null) {
            if (this.retryableFailurePredicate != null && this.retryableFailurePredicate.test(failure)) {
                return true;
            }
            if (this.retryableFailures != null) {
                for (Class<? extends Throwable> failureType : this.retryableFailures) {
                    if (!failureType.isAssignableFrom(failure.getClass())) continue;
                    return true;
                }
            }
            return this.retryableCompletionPredicate == null && this.retryableFailurePredicate == null && this.retryableFailures == null;
        }
        if (this.retryableResultPredicate != null && this.retryableResultPredicate.test(result)) {
            return true;
        }
        if (!DEFAULT_VALUE.equals(this.retryableValue)) {
            return this.retryableValue == null ? result == null : this.retryableValue.equals(result);
        }
        return false;
    }

    public RetryPolicy copy() {
        return new RetryPolicy(this);
    }

    public Duration getDelay() {
        return this.delay;
    }

    public double getDelayMultiplier() {
        return this.delayMultiplier;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public <T> RetryPolicy retryIf(BiPredicate<T, ? extends Throwable> completionPredicate) {
        Assert.notNull(completionPredicate, "completionPredicate");
        this.retryableCompletionPredicate = completionPredicate;
        return this;
    }

    public <T> RetryPolicy retryIf(Predicate<T> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        this.retryableResultPredicate = resultPredicate;
        return this;
    }

    public RetryPolicy retryOn(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "Failures cannot be empty", new Object[0]);
        this.retryableFailures = Arrays.asList(failures);
        return this;
    }

    public RetryPolicy retryOn(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        this.retryableFailures = failures;
        return this;
    }

    public RetryPolicy retryOn(Predicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        this.retryableFailurePredicate = failurePredicate;
        return this;
    }

    public RetryPolicy retryWhen(Object result) {
        this.retryableValue = result;
        return this;
    }

    public RetryPolicy withBackoff(long delay, long maxDelay, TimeUnit timeUnit) {
        return this.withBackoff(delay, maxDelay, timeUnit, 2.0);
    }

    public RetryPolicy withBackoff(long delay, long maxDelay, TimeUnit timeUnit, double delayMultiplier) {
        Assert.notNull(timeUnit, "timeUnit");
        this.delay = new Duration(delay, timeUnit);
        this.maxDelay = new Duration(maxDelay, timeUnit);
        this.delayMultiplier = delayMultiplier;
        Assert.isTrue(this.delay.toNanos() > 0L, "The delay must be greater than 0", new Object[0]);
        if (this.maxDuration != null) {
            Assert.state(this.delay.toNanos() < this.maxDuration.toNanos(), "delay must be less than the maxDuration", new Object[0]);
        }
        Assert.isTrue(this.delay.toNanos() < this.maxDelay.toNanos(), "delay must be less than the maxDelay", new Object[0]);
        Assert.isTrue(delayMultiplier > 1.0, "delayMultiplier must be greater than 1", new Object[0]);
        return this;
    }

    public RetryPolicy withDelay(long delay, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        this.delay = new Duration(delay, timeUnit);
        Assert.isTrue(this.delay.toNanos() > 0L, "delay must be greater than 0", new Object[0]);
        if (this.maxDuration != null) {
            Assert.state(this.delay.toNanos() < this.maxDuration.toNanos(), "delay must be less than the maxDuration", new Object[0]);
        }
        Assert.state(this.maxDelay == null, "Backoff delays have already been set", new Object[0]);
        return this;
    }

    public RetryPolicy withMaxDuration(long maxDuration, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        this.maxDuration = new Duration(maxDuration, timeUnit);
        Assert.state(this.maxDuration.toNanos() > this.delay.toNanos(), "maxDuration must be greater than the delay", new Object[0]);
        return this;
    }

    public RetryPolicy withMaxRetries(int maxRetries) {
        Assert.isTrue(maxRetries >= -1, "maxRetries must be greater than or equal to -1", new Object[0]);
        this.maxRetries = maxRetries;
        return this;
    }
}

