/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.event.ContextualResultListener;
import net.jodah.failsafe.event.ContextualSuccessListener;
import net.jodah.failsafe.event.ResultListener;
import net.jodah.failsafe.event.SuccessListener;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.concurrent.Scheduler;

public class Listeners<T> {
    private volatile ResultListener<T, Throwable> completeListener;
    private volatile ContextualResultListener<T, Throwable> ctxCompleteListener;
    private volatile ResultListener<T, Throwable> failedAttemptListener;
    private volatile ContextualResultListener<T, Throwable> ctxFailedAttemptListener;
    private volatile ResultListener<T, Throwable> failureListener;
    private volatile ContextualResultListener<T, Throwable> ctxFailureListener;
    private volatile ResultListener<T, Throwable> retryListener;
    private volatile ContextualResultListener<T, Throwable> ctxRetryListener;
    private volatile SuccessListener<T> successListener;
    private volatile ContextualSuccessListener<T> ctxSuccessListener;

    static <T> ContextualResultListener<T, Throwable> resultListenerOf(final ContextualSuccessListener<T> listener) {
        Assert.notNull(listener, "listener");
        return new ContextualResultListener<T, Throwable>(){

            @Override
            public void onResult(T result, Throwable failure, ExecutionContext context) {
                listener.onSuccess(result, context);
            }
        };
    }

    static <T> ResultListener<T, Throwable> resultListenerOf(final SuccessListener<T> listener) {
        Assert.notNull(listener, "listener");
        return new ResultListener<T, Throwable>(){

            @Override
            public void onResult(T result, Throwable failure) {
                listener.onSuccess(result);
            }
        };
    }

    public void onComplete(T result, Throwable failure) {
        if (this.completeListener != null) {
            this.completeListener.onResult(result, failure);
        }
    }

    public void onComplete(T result, Throwable failure, ExecutionContext context) {
        if (this.ctxCompleteListener != null) {
            this.ctxCompleteListener.onResult(result, failure, context);
        }
    }

    public void onFailedAttempt(T result, Throwable failure) {
        if (this.failedAttemptListener != null) {
            this.failedAttemptListener.onResult(result, failure);
        }
    }

    public void onFailedAttempt(T result, Throwable failure, ExecutionContext context) {
        if (this.ctxFailedAttemptListener != null) {
            this.ctxFailedAttemptListener.onResult(result, failure, context);
        }
    }

    public void onFailure(T result, Throwable failure) {
        if (this.failureListener != null) {
            this.failureListener.onResult(result, failure);
        }
    }

    public void onFailure(T result, Throwable failure, ExecutionContext context) {
        if (this.ctxFailureListener != null) {
            this.ctxFailureListener.onResult(result, failure, context);
        }
    }

    public void onRetry(T result, Throwable failure) {
        if (this.retryListener != null) {
            this.retryListener.onResult(result, failure);
        }
    }

    public void onRetry(T result, Throwable failure, ExecutionContext context) {
        if (this.ctxRetryListener != null) {
            this.ctxRetryListener.onResult(result, failure, context);
        }
    }

    public void onSuccess(T result) {
        if (this.successListener != null) {
            this.successListener.onSuccess(result);
        }
    }

    public void onSuccess(T result, ExecutionContext context) {
        if (this.ctxSuccessListener != null) {
            this.ctxSuccessListener.onSuccess(result, context);
        }
    }

    public <L extends Listeners<T>> L onComplete(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.ctxCompleteListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L onComplete(ResultListener<? super T, ? extends Throwable> listener) {
        this.completeListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L onFailedAttempt(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.ctxFailedAttemptListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L onFailedAttempt(ResultListener<? super T, ? extends Throwable> listener) {
        this.failedAttemptListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L onFailure(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.ctxFailureListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L onFailure(ResultListener<? super T, ? extends Throwable> listener) {
        this.failureListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L onRetry(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.ctxRetryListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L onRetry(ResultListener<? super T, ? extends Throwable> listener) {
        this.retryListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L onSuccess(ContextualSuccessListener<? super T> listener) {
        this.ctxSuccessListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public Listeners<T> onSuccess(SuccessListener<? super T> listener) {
        this.successListener = Assert.notNull(listener, "listener");
        return this;
    }

    void complete(T result, Throwable failure, ExecutionContext context, boolean success) {
        if (success) {
            this.handleSuccess(result);
            this.handleSuccess(result, context);
        } else {
            this.handleFailure(result, failure);
            this.handleFailure(result, failure, context);
        }
        this.handleComplete(result, failure);
        this.handleComplete(result, failure, context);
    }

    void handleComplete(T result, Throwable failure) {
        try {
            this.onComplete(result, failure);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleComplete(T result, Throwable failure, ExecutionContext context) {
        try {
            this.onComplete(result, failure, context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleFailedAttempt(T result, Throwable failure, ExecutionContext context, Scheduler scheduler) {
        try {
            this.onFailedAttempt(result, failure);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onFailedAttempt(result, failure, context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleFailure(T result, Throwable failure) {
        try {
            this.onFailure(result, failure);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleFailure(T result, Throwable failure, ExecutionContext context) {
        try {
            this.onFailure(result, failure, context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleRetry(T result, Throwable failure, ExecutionContext context, Scheduler scheduler) {
        try {
            this.onRetry(result, failure);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onRetry(result, failure, context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleSuccess(T result) {
        try {
            this.onSuccess(result);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleSuccess(T result, ExecutionContext context) {
        try {
            this.onSuccess(result, context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

