/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jodah.failsafe.AsyncListeners;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.Listeners;
import net.jodah.failsafe.event.ContextualResultListener;
import net.jodah.failsafe.event.ContextualSuccessListener;
import net.jodah.failsafe.event.ResultListener;
import net.jodah.failsafe.event.SuccessListener;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.internal.util.ReentrantCircuit;
import net.jodah.failsafe.util.concurrent.Scheduler;

public class FailsafeFuture<T>
implements Future<T> {
    private final ReentrantCircuit circuit = new ReentrantCircuit();
    private final Scheduler scheduler;
    private ExecutionContext context;
    private volatile Future<T> delegate;
    private volatile boolean done;
    private volatile boolean cancelled;
    private volatile boolean success;
    private volatile T result;
    private volatile Throwable failure;
    private final Listeners<T> listeners;
    private volatile AsyncListeners.AsyncResultListener<T> asyncCompleteListener;
    private volatile AsyncListeners.AsyncCtxResultListener<T> asyncCtxCompleteListener;
    private volatile AsyncListeners.AsyncResultListener<T> asyncFailureListener;
    private volatile AsyncListeners.AsyncCtxResultListener<T> asyncCtxFailureListener;
    private volatile AsyncListeners.AsyncResultListener<T> asyncSuccessListener;
    private volatile AsyncListeners.AsyncCtxResultListener<T> asyncCtxSuccessListener;

    FailsafeFuture(Scheduler scheduler, Listeners<T> listeners) {
        this.scheduler = scheduler;
        this.listeners = listeners == null ? new Listeners() : listeners;
        this.circuit.open();
    }

    static <T> FailsafeFuture<T> of(final CompletableFuture<T> future, Scheduler scheduler, Listeners<T> listeners) {
        Assert.notNull(future, "future");
        Assert.notNull(scheduler, "scheduler");
        return new FailsafeFuture<T>(scheduler, listeners).onComplete(new ResultListener<T, Throwable>(){

            @Override
            public void onResult(T result, Throwable failure) {
                if (failure == null) {
                    future.complete(result);
                } else {
                    future.completeExceptionally(failure);
                }
            }
        });
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = this.delegate.cancel(mayInterruptIfRunning);
        this.cancelled = true;
        this.circuit.close();
        return result;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.circuit.await();
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.circuit.await(timeout, Assert.notNull(unit, "unit"))) {
            throw new TimeoutException();
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public synchronized FailsafeFuture<T> onComplete(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.listeners.onComplete(listener);
        if (this.done) {
            this.listeners.handleComplete(this.result, this.failure, this.context);
        }
        return this;
    }

    public synchronized FailsafeFuture<T> onComplete(ResultListener<? super T, ? extends Throwable> listener) {
        this.listeners.onComplete(listener);
        if (this.done) {
            this.listeners.handleComplete(this.result, this.failure);
        }
        return this;
    }

    public synchronized FailsafeFuture<T> onCompleteAsync(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.asyncCtxCompleteListener = new AsyncListeners.AsyncCtxResultListener<T>(listener);
        this.call(this.done, this.asyncCtxCompleteListener);
        return this;
    }

    public synchronized FailsafeFuture<T> onCompleteAsync(ContextualResultListener<? super T, ? extends Throwable> listener, ExecutorService executor) {
        this.asyncCtxCompleteListener = new AsyncListeners.AsyncCtxResultListener<T>(listener, executor);
        this.call(this.done, this.asyncCtxCompleteListener);
        return this;
    }

    public synchronized FailsafeFuture<T> onCompleteAsync(ResultListener<? super T, ? extends Throwable> listener) {
        this.asyncCompleteListener = new AsyncListeners.AsyncResultListener<T>(listener);
        this.call(this.done, this.asyncCompleteListener);
        return this;
    }

    public synchronized FailsafeFuture<T> onCompleteAsync(ResultListener<? super T, ? extends Throwable> listener, ExecutorService executor) {
        this.asyncCompleteListener = new AsyncListeners.AsyncResultListener<T>(listener, executor);
        this.call(this.done, this.asyncCompleteListener);
        return this;
    }

    public synchronized FailsafeFuture<T> onFailure(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.listeners.onFailure(listener);
        if (this.done && !this.success) {
            this.listeners.handleFailure(this.result, this.failure, this.context);
        }
        return this;
    }

    public synchronized FailsafeFuture<T> onFailure(ResultListener<? super T, ? extends Throwable> listener) {
        this.listeners.onFailure(listener);
        if (this.done && !this.success) {
            this.listeners.handleFailure(this.result, this.failure);
        }
        return this;
    }

    public synchronized FailsafeFuture<T> onFailureAsync(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.asyncCtxFailureListener = new AsyncListeners.AsyncCtxResultListener<T>(listener);
        this.call(this.done && !this.success, this.asyncCtxFailureListener);
        return this;
    }

    public synchronized FailsafeFuture<T> onFailureAsync(ContextualResultListener<? super T, ? extends Throwable> listener, ExecutorService executor) {
        this.asyncCtxFailureListener = new AsyncListeners.AsyncCtxResultListener<T>(listener, executor);
        this.call(this.done && !this.success, this.asyncCtxFailureListener);
        return this;
    }

    public synchronized FailsafeFuture<T> onFailureAsync(ResultListener<? super T, ? extends Throwable> listener) {
        this.asyncFailureListener = new AsyncListeners.AsyncResultListener<T>(listener);
        this.call(this.done && !this.success, this.asyncFailureListener);
        return this;
    }

    public synchronized FailsafeFuture<T> onFailureAsync(ResultListener<? super T, ? extends Throwable> listener, ExecutorService executor) {
        this.asyncFailureListener = new AsyncListeners.AsyncResultListener<T>(listener, executor);
        this.call(this.done && !this.success, this.asyncFailureListener);
        return this;
    }

    public synchronized FailsafeFuture<T> onSuccess(ContextualSuccessListener<? super T> listener) {
        this.listeners.onSuccess(listener);
        if (this.done && this.success) {
            this.listeners.handleSuccess(this.result, this.context);
        }
        return this;
    }

    public synchronized FailsafeFuture<T> onSuccess(SuccessListener<? super T> listener) {
        this.listeners.onSuccess(listener);
        if (this.done && this.success) {
            this.listeners.handleSuccess(this.result);
        }
        return this;
    }

    public synchronized FailsafeFuture<T> onSuccessAsync(ContextualSuccessListener<? super T> listener) {
        this.asyncCtxSuccessListener = new AsyncListeners.AsyncCtxResultListener<T>(Listeners.resultListenerOf(listener));
        this.call(this.done && this.success, this.asyncCtxSuccessListener);
        return this;
    }

    public synchronized FailsafeFuture<T> onSuccessAsync(ContextualSuccessListener<? super T> listener, ExecutorService executor) {
        this.asyncCtxSuccessListener = new AsyncListeners.AsyncCtxResultListener<T>(Listeners.resultListenerOf(listener), executor);
        this.call(this.done && this.success, this.asyncCtxSuccessListener);
        return this;
    }

    public synchronized FailsafeFuture<T> onSuccessAsync(SuccessListener<? super T> listener) {
        this.asyncSuccessListener = new AsyncListeners.AsyncResultListener<T>(Listeners.resultListenerOf(listener));
        this.call(this.done && this.success, this.asyncSuccessListener);
        return this;
    }

    public synchronized FailsafeFuture<T> onSuccessAsync(SuccessListener<? super T> listener, ExecutorService executor) {
        this.asyncSuccessListener = new AsyncListeners.AsyncResultListener<T>(Listeners.resultListenerOf(listener), executor);
        this.call(this.done && this.success, this.asyncSuccessListener);
        return this;
    }

    synchronized void complete(T result, Throwable failure, boolean success) {
        this.result = result;
        this.failure = failure;
        this.success = success;
        this.done = true;
        if (success) {
            AsyncListeners.call(this.asyncSuccessListener, this.asyncCtxSuccessListener, result, failure, this.context, this.scheduler);
        } else {
            AsyncListeners.call(this.asyncFailureListener, this.asyncCtxFailureListener, result, failure, this.context, this.scheduler);
        }
        AsyncListeners.call(this.asyncCompleteListener, this.asyncCtxCompleteListener, result, failure, this.context, this.scheduler);
        this.listeners.complete(result, failure, this.context, success);
        this.circuit.close();
    }

    void inject(ExecutionContext context) {
        this.context = context;
    }

    void setFuture(Future<T> delegate) {
        this.delegate = delegate;
    }

    private void call(boolean condition, AsyncListeners.AsyncCtxResultListener<T> listener) {
        if (condition) {
            AsyncListeners.call(listener, this.result, this.failure, this.context, this.scheduler);
        }
    }

    private void call(boolean condition, AsyncListeners.AsyncResultListener<T> listener) {
        if (condition) {
            AsyncListeners.call(listener, this.result, this.failure, this.context, this.scheduler);
        }
    }
}

