/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.Callables;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.Listeners;
import net.jodah.failsafe.event.ContextualResultListener;
import net.jodah.failsafe.event.ResultListener;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.concurrent.Scheduler;

public class AsyncListeners<T>
extends Listeners<T> {
    private volatile AsyncResultListener<T> asyncFailedAttemptListener;
    private volatile AsyncCtxResultListener<T> asyncCtxFailedAttemptListener;
    private volatile AsyncResultListener<T> asyncRetryListener;
    private volatile AsyncCtxResultListener<T> asyncCtxRetryListener;

    static <T> void call(AsyncCtxResultListener<T> listener, T result, Throwable failure, ExecutionContext context, Scheduler scheduler) {
        AsyncListeners.call(Callables.of(listener.listener, result, failure, context), listener.executor, scheduler);
    }

    static <T> void call(AsyncResultListener<T> listener, AsyncCtxResultListener<T> ctxListener, T result, Throwable failure, ExecutionContext context, Scheduler scheduler) {
        if (listener != null) {
            AsyncListeners.call(listener, result, failure, context, scheduler);
        }
        if (ctxListener != null) {
            AsyncListeners.call(ctxListener, result, failure, context, scheduler);
        }
    }

    static <T> void call(AsyncResultListener<T> listener, T result, Throwable failure, ExecutionContext context, Scheduler scheduler) {
        AsyncListeners.call(Callables.of(listener.listener, result, failure), listener.executor, scheduler);
    }

    private static void call(Callable<?> callable, ExecutorService executor, Scheduler scheduler) {
        if (executor != null) {
            executor.submit(callable);
        } else {
            scheduler.schedule(callable, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public AsyncListeners<T> onFailedAttemptAsync(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.asyncCtxFailedAttemptListener = new AsyncCtxResultListener<T>(listener);
        return this;
    }

    public AsyncListeners<T> onFailedAttemptAsync(ContextualResultListener<? super T, ? extends Throwable> listener, ExecutorService executor) {
        this.asyncCtxFailedAttemptListener = new AsyncCtxResultListener<T>(listener, executor);
        return this;
    }

    public AsyncListeners<T> onFailedAttemptAsync(ResultListener<? super T, ? extends Throwable> listener) {
        this.asyncFailedAttemptListener = new AsyncResultListener<T>(listener);
        return this;
    }

    public AsyncListeners<T> onFailedAttemptAsync(ResultListener<? super T, ? extends Throwable> listener, ExecutorService executor) {
        this.asyncFailedAttemptListener = new AsyncResultListener<T>(listener, executor);
        return this;
    }

    public AsyncListeners<T> onRetryAsync(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.asyncCtxRetryListener = new AsyncCtxResultListener<T>(listener);
        return this;
    }

    public AsyncListeners<T> onRetryAsync(ContextualResultListener<? super T, ? extends Throwable> listener, ExecutorService executor) {
        this.asyncCtxRetryListener = new AsyncCtxResultListener<T>(listener, executor);
        return this;
    }

    public AsyncListeners<T> onRetryAsync(ResultListener<? super T, ? extends Throwable> listener) {
        this.asyncRetryListener = new AsyncResultListener<T>(listener);
        return this;
    }

    public AsyncListeners<T> onRetryAsync(ResultListener<? super T, ? extends Throwable> listener, ExecutorService executor) {
        this.asyncRetryListener = new AsyncResultListener<T>(listener, executor);
        return this;
    }

    @Override
    void handleFailedAttempt(T result, Throwable failure, ExecutionContext context, Scheduler scheduler) {
        AsyncListeners.call(this.asyncFailedAttemptListener, this.asyncCtxFailedAttemptListener, result, failure, context, scheduler);
        super.handleFailedAttempt(result, failure, context, scheduler);
    }

    @Override
    void handleRetry(T result, Throwable failure, ExecutionContext context, Scheduler scheduler) {
        AsyncListeners.call(this.asyncRetryListener, this.asyncCtxRetryListener, result, failure, context, scheduler);
        super.handleRetry(result, failure, context, scheduler);
    }

    static class AsyncResultListener<T> {
        ResultListener<T, Throwable> listener;
        ExecutorService executor;

        AsyncResultListener(ResultListener<? super T, ? extends Throwable> listener) {
            this.listener = Assert.notNull(listener, "listener");
            this.executor = null;
        }

        AsyncResultListener(ResultListener<? super T, ? extends Throwable> listener, ExecutorService executor) {
            this.listener = Assert.notNull(listener, "listener");
            this.executor = Assert.notNull(executor, "executor");
        }
    }

    static class AsyncCtxResultListener<T> {
        ContextualResultListener<T, Throwable> listener;
        ExecutorService executor;

        AsyncCtxResultListener(ContextualResultListener<? super T, ? extends Throwable> listener) {
            this.listener = Assert.notNull(listener, "listener");
            this.executor = null;
        }

        AsyncCtxResultListener(ContextualResultListener<? super T, ? extends Throwable> listener, ExecutorService executor) {
            this.listener = Assert.notNull(listener, "listener");
            this.executor = Assert.notNull(executor, "executor");
        }
    }
}

