/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.AsyncListeners;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.CircuitBreakerOpenException;
import net.jodah.failsafe.FailsafeFuture;
import net.jodah.failsafe.Listeners;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.concurrent.Scheduler;

public final class AsyncExecution
extends AbstractExecution {
    private final Callable<Object> callable;
    private final FailsafeFuture<Object> future;
    private final Listeners<Object> listeners;
    private final Scheduler scheduler;
    volatile boolean completeCalled;
    volatile boolean retryCalled;

    <T> AsyncExecution(Callable<T> callable, RetryPolicy retryPolicy, CircuitBreaker circuitBreaker, Scheduler scheduler, FailsafeFuture<T> future, Listeners<?> listeners) {
        super(retryPolicy, circuitBreaker);
        this.callable = callable;
        this.scheduler = scheduler;
        this.future = future;
        this.listeners = listeners;
    }

    public void complete() {
        this.complete(null, null, false);
    }

    public boolean complete(Object result) {
        return this.complete(result, null, true);
    }

    public boolean complete(Object result, Throwable failure) {
        return this.complete(result, failure, true);
    }

    public boolean retry() {
        Assert.state(!this.retryCalled, "Retry has already been called", new Object[0]);
        this.retryCalled = true;
        return this.completeOrRetry(this.lastResult, this.lastFailure);
    }

    public boolean retryFor(Object result) {
        return this.retryFor(result, null);
    }

    public boolean retryFor(Object result, Throwable failure) {
        Assert.state(!this.retryCalled, "Retry has already been called", new Object[0]);
        this.retryCalled = true;
        return this.completeOrRetry(result, failure);
    }

    public boolean retryOn(Throwable failure) {
        Assert.notNull(failure, "failure");
        return this.retryFor(null, failure);
    }

    @Override
    void before() {
        if (this.circuitBreaker != null && !this.circuitBreaker.allowsExecution()) {
            this.completed = true;
            this.future.complete(null, new CircuitBreakerOpenException(), false);
            return;
        }
        if (this.completeCalled && this.listeners != null) {
            this.listeners.handleRetry(this.lastResult, this.lastFailure, this.listeners instanceof AsyncListeners ? this.copy() : this, this.scheduler);
        }
        super.before();
        this.completeCalled = false;
        this.retryCalled = false;
    }

    @Override
    synchronized boolean complete(Object result, Throwable failure, boolean checkArgs) {
        if (!this.completeCalled) {
            super.complete(result, failure, checkArgs);
            if (!this.success && this.listeners != null) {
                this.listeners.handleFailedAttempt(result, failure, this, this.scheduler);
            }
            if (this.completed) {
                this.future.complete(result, failure, this.success);
            }
            this.completeCalled = true;
        }
        return this.completed;
    }

    synchronized boolean completeOrRetry(Object result, Throwable failure) {
        if (!(this.complete(result, failure, true) || this.future.isDone() || this.future.isCancelled())) {
            try {
                this.future.setFuture(this.scheduler.schedule(this.callable, this.waitNanos, TimeUnit.NANOSECONDS));
                return true;
            }
            catch (Throwable t) {
                failure = t;
                this.future.complete(null, failure, false);
            }
        }
        return false;
    }
}

