/*
 * Decompiled with CFR 0.152.
 */
package net.jimblackler.usejson;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import net.jimblackler.usejson.InternalParserError;
import net.jimblackler.usejson.NumberUtils;
import net.jimblackler.usejson.SyntaxError;
import net.jimblackler.usejson.Util;

public class Json5Parser {
    private static final Logger LOG = Logger.getLogger(Json5Parser.class.getName());
    private final StringBuilder buffer = new StringBuilder();
    private String source;
    private State parseState;
    private Deque<Object> stack;
    private int pos;
    private int line;
    private int column;
    private Token token;
    private State lexState;
    private boolean doubleQuote;
    private int sign;
    private Character c;
    private String key;
    private Object root;

    static String formatChar(char c) {
        switch (c) {
            case '\'': {
                return "\\'";
            }
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\u0000': {
                return "\\0";
            }
            case '\u2028': {
                return "\\u2028";
            }
            case '\u2029': {
                return "\u2029";
            }
        }
        if (c < ' ') {
            String hexString = Integer.toString(c, 16);
            return "\\x" + ("00" + hexString).substring(hexString.length());
        }
        return String.valueOf(c);
    }

    public <T> T parse(String text) {
        this.source = text;
        this.parseState = State.START;
        this.stack = new LinkedList<Object>();
        this.pos = 0;
        this.line = 1;
        this.column = 0;
        this.token = null;
        this.key = null;
        this.root = null;
        do {
            this.token = this.lex();
            this.parseStates();
        } while (this.token.getType() != TokenType.EOF);
        return (T)this.root;
    }

    private Token lex() {
        this.lexState = State.DEFAULT;
        this.buffer.setLength(0);
        this.doubleQuote = false;
        this.sign = 1;
        do {
            this.c = this.peek();
            this.token = this.lexStates(this.lexState);
        } while (this.token == null);
        return this.token;
    }

    private Character peek() {
        try {
            return Character.valueOf(this.source.charAt(this.pos));
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
    }

    private Character read() {
        Character c = this.peek();
        if (c == null) {
            ++this.column;
        } else if (c.charValue() == '\n') {
            ++this.line;
            this.column = 0;
        } else {
            ++this.column;
        }
        if (c != null) {
            ++this.pos;
        }
        return c;
    }

    private Token lexStates(State state) {
        switch (state) {
            case DEFAULT: {
                if (this.c == null) {
                    this.read();
                    return new Token(TokenType.EOF);
                }
                switch (this.c.charValue()) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\u00a0': 
                    case '\u2028': 
                    case '\u2029': 
                    case '\ufeff': {
                        this.read();
                        return null;
                    }
                    case '/': {
                        this.read();
                        this.lexState = State.COMMENT;
                        return null;
                    }
                }
                if (Util.isSpaceSeparator(this.c.charValue())) {
                    this.read();
                    return null;
                }
                return this.lexStates(this.parseState);
            }
            case COMMENT: {
                switch (this.c.charValue()) {
                    case '*': {
                        this.read();
                        this.lexState = State.MULTI_LINE_COMMENT;
                        return null;
                    }
                    case '/': {
                        this.read();
                        this.lexState = State.SINGLE_LINE_COMMENT;
                        return null;
                    }
                }
                throw this.invalidChar(this.read());
            }
            case MULTI_LINE_COMMENT: {
                if (this.c == null) {
                    throw this.invalidChar(this.read());
                }
                switch (this.c.charValue()) {
                    case '*': {
                        this.read();
                        this.lexState = State.MULTI_LINE_COMMENT_ASTERISK;
                        return null;
                    }
                }
                this.read();
                return null;
            }
            case MULTI_LINE_COMMENT_ASTERISK: {
                if (this.c == null) {
                    throw this.invalidChar(this.read());
                }
                switch (this.c.charValue()) {
                    case '*': {
                        this.read();
                        return null;
                    }
                    case '/': {
                        this.read();
                        this.lexState = State.DEFAULT;
                        return null;
                    }
                }
                this.read();
                this.lexState = State.MULTI_LINE_COMMENT;
                return null;
            }
            case SINGLE_LINE_COMMENT: {
                if (this.c == null) {
                    this.read();
                    return new Token(TokenType.EOF);
                }
                switch (this.c.charValue()) {
                    case '\n': 
                    case '\r': 
                    case '\u2028': 
                    case '\u2029': {
                        this.read();
                        this.lexState = State.DEFAULT;
                        return null;
                    }
                }
                this.read();
                break;
            }
            case VALUE: {
                switch (this.c.charValue()) {
                    case '[': 
                    case '{': {
                        return new Token(TokenType.PUNCTUATOR, this.read());
                    }
                    case 'n': {
                        this.read();
                        this.literal("ull");
                        return new Token(TokenType.NULL, null);
                    }
                    case 't': {
                        this.read();
                        this.literal("rue");
                        return new Token(TokenType.BOOLEAN, true);
                    }
                    case 'f': {
                        this.read();
                        this.literal("alse");
                        return new Token(TokenType.BOOLEAN, false);
                    }
                    case '+': 
                    case '-': {
                        if (this.read().charValue() == '-') {
                            this.sign = -1;
                        }
                        this.lexState = State.SIGN;
                        return null;
                    }
                    case '.': {
                        this.buffer.setLength(0);
                        this.buffer.append(this.read().charValue());
                        this.lexState = State.DECIMAL_POINT_LEADING;
                        return null;
                    }
                    case '0': {
                        this.buffer.setLength(0);
                        this.buffer.append(this.read().charValue());
                        this.lexState = State.ZERO;
                        return null;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.buffer.setLength(0);
                        this.buffer.append(this.read().charValue());
                        this.lexState = State.DECIMAL_INTEGER;
                        return null;
                    }
                    case 'I': {
                        this.read();
                        this.literal("nfinity");
                        return new Token(TokenType.NUMERIC, Double.POSITIVE_INFINITY);
                    }
                    case 'N': {
                        this.read();
                        this.literal("aN");
                        return new Token(TokenType.NUMERIC, Double.NaN);
                    }
                    case '\"': 
                    case '\'': {
                        this.doubleQuote = this.read().charValue() == '\"';
                        this.buffer.setLength(0);
                        this.lexState = State.STRING;
                        return null;
                    }
                }
                throw this.invalidChar(this.read());
            }
            case IDENTIFIER_NAME_START_ESCAPE: {
                if (this.c.charValue() != 'u') {
                    throw this.invalidChar(this.read());
                }
                this.read();
                char u = this.unicodeEscape();
                switch (u) {
                    case '$': 
                    case '_': {
                        break;
                    }
                    default: {
                        if (Util.isIdStartChar(u)) break;
                        throw this.invalidIdentifier();
                    }
                }
                this.buffer.append(u);
                this.lexState = State.IDENTIFIER_NAME;
                break;
            }
            case IDENTIFIER_NAME: {
                switch (this.c.charValue()) {
                    case '$': 
                    case '_': 
                    case '\u200c': 
                    case '\u200d': {
                        this.buffer.append(this.read().charValue());
                        return null;
                    }
                    case '\\': {
                        this.read();
                        this.lexState = State.IDENTIFIER_NAME_ESCAPE;
                        return null;
                    }
                }
                if (Util.isIdContinueChar(this.c.charValue())) {
                    this.buffer.append(this.read().charValue());
                    return null;
                }
                return new Token(TokenType.IDENTIFIER, this.buffer.toString());
            }
            case IDENTIFIER_NAME_ESCAPE: {
                if (this.c.charValue() != 'u') {
                    throw this.invalidChar(this.read());
                }
                this.read();
                char u1 = this.unicodeEscape();
                switch (u1) {
                    case '$': 
                    case '_': 
                    case '\u200c': 
                    case '\u200d': {
                        break;
                    }
                    default: {
                        if (Util.isIdContinueChar(u1)) break;
                        throw this.invalidIdentifier();
                    }
                }
                this.buffer.append(u1);
                this.lexState = State.IDENTIFIER_NAME;
                break;
            }
            case SIGN: {
                switch (this.c.charValue()) {
                    case '.': {
                        this.buffer.setLength(0);
                        this.buffer.append(this.read().charValue());
                        this.lexState = State.DECIMAL_POINT_LEADING;
                        return null;
                    }
                    case '0': {
                        this.buffer.setLength(0);
                        this.buffer.append(this.read().charValue());
                        this.lexState = State.ZERO;
                        return null;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.buffer.setLength(0);
                        this.buffer.append(this.read().charValue());
                        this.lexState = State.DECIMAL_INTEGER;
                        return null;
                    }
                    case 'I': {
                        this.read();
                        this.literal("nfinity");
                        return new Token(TokenType.NUMERIC, (double)this.sign * Double.POSITIVE_INFINITY);
                    }
                    case 'N': {
                        this.read();
                        this.literal("aN");
                        return new Token(TokenType.NUMERIC, Double.NaN);
                    }
                }
                throw this.invalidChar(this.read());
            }
            case ZERO: {
                if (this.c != null) {
                    switch (this.c.charValue()) {
                        case '.': {
                            this.buffer.append(this.read().charValue());
                            this.lexState = State.DECIMAL_POINT;
                            return null;
                        }
                        case 'E': 
                        case 'e': {
                            this.buffer.append(this.read().charValue());
                            this.lexState = State.DECIMAL_EXPONENT;
                            return null;
                        }
                        case 'X': 
                        case 'x': {
                            this.buffer.append(this.read().charValue());
                            this.lexState = State.HEXADECIMAL;
                            return null;
                        }
                    }
                }
                return new Token(TokenType.NUMERIC, this.sign * 0);
            }
            case DECIMAL_INTEGER: {
                if (this.c != null) {
                    switch (this.c.charValue()) {
                        case '.': {
                            this.buffer.append(this.read().charValue());
                            this.lexState = State.DECIMAL_POINT;
                            return null;
                        }
                        case 'E': 
                        case 'e': {
                            this.buffer.append(this.read().charValue());
                            this.lexState = State.DECIMAL_EXPONENT;
                            return null;
                        }
                    }
                    if (Util.isDigit(this.c.charValue())) {
                        this.buffer.append(this.read().charValue());
                        return null;
                    }
                }
                return new Token(TokenType.NUMERIC, NumberUtils.toBestObject(new BigInteger(this.buffer.toString()).multiply(BigInteger.valueOf(this.sign))));
            }
            case DECIMAL_POINT_LEADING: {
                if (this.c != null && Util.isDigit(this.c.charValue())) {
                    this.buffer.append(this.read().charValue());
                    this.lexState = State.DECIMAL_FRACTION;
                    return null;
                }
                throw this.invalidChar(this.read());
            }
            case DECIMAL_POINT: {
                switch (this.c.charValue()) {
                    case 'E': 
                    case 'e': {
                        this.buffer.append(this.read().charValue());
                        this.lexState = State.DECIMAL_EXPONENT;
                        return null;
                    }
                }
                if (Util.isDigit(this.c.charValue())) {
                    this.buffer.append(this.read().charValue());
                    this.lexState = State.DECIMAL_FRACTION;
                    return null;
                }
                return new Token(TokenType.NUMERIC, NumberUtils.toBestObject(new BigInteger(this.buffer.toString()).multiply(BigInteger.valueOf(this.sign))));
            }
            case DECIMAL_FRACTION: {
                if (this.c != null) {
                    switch (this.c.charValue()) {
                        case 'E': 
                        case 'e': {
                            this.buffer.append(this.read().charValue());
                            this.lexState = State.DECIMAL_EXPONENT;
                            return null;
                        }
                    }
                    if (Util.isDigit(this.c.charValue())) {
                        this.buffer.append(this.read().charValue());
                        return null;
                    }
                }
                return new Token(TokenType.NUMERIC, (double)this.sign * Double.parseDouble(this.buffer.toString()));
            }
            case DECIMAL_EXPONENT: {
                if (this.c != null) {
                    switch (this.c.charValue()) {
                        case '+': 
                        case '-': {
                            this.buffer.append(this.read().charValue());
                            this.lexState = State.DECIMAL_EXPONENT_SIGN;
                            return null;
                        }
                    }
                    if (Util.isDigit(this.c.charValue())) {
                        this.buffer.append(this.read().charValue());
                        this.lexState = State.DECIMAL_EXPONENT_INTEGER;
                        return null;
                    }
                }
                throw this.invalidChar(this.read());
            }
            case DECIMAL_EXPONENT_SIGN: {
                if (Util.isDigit(this.c.charValue())) {
                    this.buffer.append(this.read().charValue());
                    this.lexState = State.DECIMAL_EXPONENT_INTEGER;
                    return null;
                }
                throw this.invalidChar(this.read());
            }
            case DECIMAL_EXPONENT_INTEGER: {
                if (this.c != null && Util.isDigit(this.c.charValue())) {
                    this.buffer.append(this.read().charValue());
                    return null;
                }
                return new Token(TokenType.NUMERIC, BigDecimal.valueOf(this.sign).multiply(new BigDecimal(this.buffer.toString())));
            }
            case HEXADECIMAL: {
                if (Util.isHexDigit(this.c.charValue())) {
                    this.buffer.append(this.read().charValue());
                    this.lexState = State.HEXADECIMAL_INTEGER;
                    return null;
                }
                throw this.invalidChar(this.read());
            }
            case HEXADECIMAL_INTEGER: {
                if (this.c != null && Util.isHexDigit(this.c.charValue())) {
                    this.buffer.append(this.read().charValue());
                    return null;
                }
                return new Token(TokenType.NUMERIC, this.sign * Integer.parseInt(this.buffer.substring(2), 16));
            }
            case STRING: {
                if (this.c == null) {
                    throw this.invalidChar(this.read());
                }
                switch (this.c.charValue()) {
                    case '\\': {
                        this.read();
                        this.buffer.append(this.escape());
                        return null;
                    }
                    case '\"': {
                        if (this.doubleQuote) {
                            this.read();
                            return new Token(TokenType.STRING, this.buffer.toString());
                        }
                        this.buffer.append(this.read().charValue());
                        return null;
                    }
                    case '\'': {
                        if (!this.doubleQuote) {
                            this.read();
                            return new Token(TokenType.STRING, this.buffer.toString());
                        }
                        this.buffer.append(this.read().charValue());
                        return null;
                    }
                    case '\n': 
                    case '\r': {
                        throw this.invalidChar(this.read());
                    }
                    case '\u2028': 
                    case '\u2029': {
                        this.separatorChar(this.c.charValue());
                    }
                }
                this.buffer.append(this.read().charValue());
                break;
            }
            case START: {
                switch (this.c.charValue()) {
                    case '[': 
                    case '{': {
                        return new Token(TokenType.PUNCTUATOR, this.read());
                    }
                }
                this.lexState = State.VALUE;
                break;
            }
            case BEFORE_PROPERTY_NAME: {
                switch (this.c.charValue()) {
                    case '$': 
                    case '_': {
                        this.buffer.setLength(0);
                        this.buffer.append(this.read().charValue());
                        this.lexState = State.IDENTIFIER_NAME;
                        return null;
                    }
                    case '\\': {
                        this.read();
                        this.lexState = State.IDENTIFIER_NAME_START_ESCAPE;
                        return null;
                    }
                    case '}': {
                        return new Token(TokenType.PUNCTUATOR, this.read());
                    }
                    case '\"': 
                    case '\'': {
                        this.doubleQuote = this.read().charValue() == '\"';
                        this.lexState = State.STRING;
                        return null;
                    }
                }
                if (Util.isIdStartChar(this.c.charValue())) {
                    this.buffer.append(this.read().charValue());
                    this.lexState = State.IDENTIFIER_NAME;
                    return null;
                }
                throw this.invalidChar(this.read());
            }
            case AFTER_PROPERTY_NAME: {
                if (this.c.charValue() == ':') {
                    return new Token(TokenType.PUNCTUATOR, this.read());
                }
                throw this.invalidChar(this.read());
            }
            case BEFORE_PROPERTY_VALUE: {
                this.lexState = State.VALUE;
                break;
            }
            case AFTER_PROPERTY_VALUE: {
                switch (this.c.charValue()) {
                    case ',': 
                    case '}': {
                        return new Token(TokenType.PUNCTUATOR, this.read());
                    }
                }
                throw this.invalidChar(this.read());
            }
            case BEFORE_ARRAY_VALUE: {
                if (this.c.charValue() == ']') {
                    return new Token(TokenType.PUNCTUATOR, this.read());
                }
                this.lexState = State.VALUE;
                break;
            }
            case AFTER_ARRAY_VALUE: {
                switch (this.c.charValue()) {
                    case ',': 
                    case ']': {
                        return new Token(TokenType.PUNCTUATOR, this.read());
                    }
                }
                throw this.invalidChar(this.read());
            }
            case END: {
                throw this.invalidChar(this.read());
            }
            default: {
                throw new InternalParserError("Unknown state: " + state.name());
            }
        }
        return null;
    }

    private void literal(String s) {
        for (char c : s.toCharArray()) {
            Character p = this.peek();
            if (p.charValue() != c) {
                throw this.invalidChar(this.read());
            }
            this.read();
        }
    }

    private char escape() {
        Character c = this.peek();
        if (c == null) {
            throw this.invalidChar(this.read());
        }
        switch (c.charValue()) {
            case 'b': {
                this.read();
                return '\b';
            }
            case 'f': {
                this.read();
                return '\f';
            }
            case 'n': {
                this.read();
                return '\n';
            }
            case 'r': {
                this.read();
                return '\r';
            }
            case 't': {
                this.read();
                return '\t';
            }
            case 'v': {
                this.read();
                return '\u000b';
            }
            case '0': {
                this.read();
                if (Util.isDigit(this.peek().charValue())) {
                    throw this.invalidChar(this.read());
                }
                return '\u0000';
            }
            case 'x': {
                this.read();
                return this.hexEscape();
            }
            case 'u': {
                this.read();
                return this.unicodeEscape();
            }
            case '\n': 
            case '\u2028': 
            case '\u2029': {
                this.read();
                return '\u0000';
            }
            case '\r': {
                this.read();
                if (this.peek().charValue() == '\n') {
                    this.read();
                }
                return '\u0000';
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                throw this.invalidChar(this.read());
            }
        }
        return this.read().charValue();
    }

    char hexEscape() {
        StringBuilder buffer = new StringBuilder();
        Character c = this.peek();
        if (!Util.isHexDigit(c.charValue())) {
            throw this.invalidChar(this.read());
        }
        buffer.append(this.read().charValue());
        c = this.peek();
        if (!Util.isHexDigit(c.charValue())) {
            throw this.invalidChar(this.read());
        }
        buffer.append(this.read().charValue());
        return (char)Integer.parseInt(buffer.toString(), 16);
    }

    char unicodeEscape() {
        StringBuilder buffer = new StringBuilder();
        int count = 4;
        while (count-- > 0) {
            Character c = this.peek();
            if (!Util.isHexDigit(c.charValue())) {
                throw this.invalidChar(this.read());
            }
            buffer.append(this.read().charValue());
        }
        return (char)Integer.parseInt(buffer.toString(), 16);
    }

    private void parseStates() {
        switch (this.parseState) {
            case START: {
                if (this.token.getType() == TokenType.EOF) {
                    throw this.invalidEOF();
                }
                this.push();
                break;
            }
            case BEFORE_PROPERTY_NAME: {
                switch (this.token.getType()) {
                    case IDENTIFIER: 
                    case STRING: {
                        this.key = this.token.getValue().toString();
                        this.parseState = State.AFTER_PROPERTY_NAME;
                        return;
                    }
                    case PUNCTUATOR: {
                        this.pop();
                        return;
                    }
                    case EOF: {
                        throw this.invalidEOF();
                    }
                }
                break;
            }
            case AFTER_PROPERTY_NAME: {
                if (this.token.getType() == TokenType.EOF) {
                    throw this.invalidEOF();
                }
                this.parseState = State.BEFORE_PROPERTY_VALUE;
                break;
            }
            case BEFORE_PROPERTY_VALUE: {
                if (this.token.getType() == TokenType.EOF) {
                    throw this.invalidEOF();
                }
                this.push();
                break;
            }
            case BEFORE_ARRAY_VALUE: {
                if (this.token.getType() == TokenType.EOF) {
                    throw this.invalidEOF();
                }
                if (this.token.getType() == TokenType.PUNCTUATOR && ((Character)this.token.getValue()).charValue() == ']') {
                    this.pop();
                    return;
                }
                this.push();
                break;
            }
            case AFTER_PROPERTY_VALUE: {
                if (this.token.getType() == TokenType.EOF) {
                    throw this.invalidEOF();
                }
                switch (((Character)this.token.getValue()).charValue()) {
                    case ',': {
                        this.parseState = State.BEFORE_PROPERTY_NAME;
                        return;
                    }
                    case '}': {
                        this.pop();
                    }
                }
                break;
            }
            case AFTER_ARRAY_VALUE: {
                if (this.token.getType() == TokenType.EOF) {
                    throw this.invalidEOF();
                }
                switch (((Character)this.token.getValue()).charValue()) {
                    case ',': {
                        this.parseState = State.BEFORE_ARRAY_VALUE;
                        return;
                    }
                    case ']': {
                        this.pop();
                    }
                }
                break;
            }
        }
    }

    private void push() {
        Cloneable value;
        block1 : switch (this.token.getType()) {
            case PUNCTUATOR: {
                Object token = this.token.getValue();
                switch (((Character)token).charValue()) {
                    case '{': {
                        value = new LinkedHashMap();
                        break block1;
                    }
                    case '[': {
                        value = new ArrayList();
                        break block1;
                    }
                }
                throw new InternalParserError();
            }
            case STRING: 
            case NULL: 
            case BOOLEAN: 
            case NUMERIC: {
                value = this.token.getValue();
                break;
            }
            default: {
                throw new InternalParserError();
            }
        }
        if (this.root == null) {
            this.root = value;
        } else {
            Object parent = this.stack.getLast();
            if (parent instanceof List) {
                ((List)parent).add(value);
            } else {
                ((Map)parent).put(this.key, value);
            }
        }
        if (value instanceof List || value instanceof Map) {
            this.stack.add(value);
            this.parseState = value instanceof List ? State.BEFORE_ARRAY_VALUE : State.BEFORE_PROPERTY_NAME;
        } else {
            try {
                Object current = this.stack.getLast();
                this.parseState = current instanceof List ? State.AFTER_ARRAY_VALUE : State.AFTER_PROPERTY_VALUE;
            }
            catch (NoSuchElementException e) {
                this.parseState = State.END;
            }
        }
    }

    private void pop() {
        this.stack.removeLast();
        try {
            Object current = this.stack.getLast();
            this.parseState = current instanceof List ? State.AFTER_ARRAY_VALUE : State.AFTER_PROPERTY_VALUE;
        }
        catch (NoSuchElementException ex) {
            this.parseState = State.END;
        }
    }

    private SyntaxError invalidChar(Character c) {
        if (c == null) {
            return new SyntaxError("JSON5: invalid end of input at " + this.line + ":" + this.column);
        }
        return new SyntaxError("JSON5: invalid character '" + Json5Parser.formatChar(c.charValue()) + "' at " + this.line + ":" + this.column);
    }

    private SyntaxError invalidEOF() {
        return new SyntaxError("JSON5: invalid end of input at " + this.line + ":" + this.column);
    }

    private SyntaxError invalidIdentifier() {
        this.column -= 5;
        return new SyntaxError("JSON5: invalid identifier character at " + this.line + ":" + this.column);
    }

    private void separatorChar(char c) {
        LOG.warning("JSON5: '" + Json5Parser.formatChar(c) + "' in strings is not valid ECMAScript; consider escaping");
    }

    private static class Token {
        private final TokenType type;
        private final Object value;

        Token(TokenType type) {
            this.type = type;
            this.value = null;
        }

        Token(TokenType type, Object value) {
            this.type = type;
            this.value = value;
        }

        private TokenType getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }
    }

    private static enum State {
        DEFAULT,
        COMMENT,
        MULTI_LINE_COMMENT,
        MULTI_LINE_COMMENT_ASTERISK,
        SINGLE_LINE_COMMENT,
        VALUE,
        IDENTIFIER_NAME_START_ESCAPE,
        IDENTIFIER_NAME,
        IDENTIFIER_NAME_ESCAPE,
        SIGN,
        ZERO,
        DECIMAL_INTEGER,
        DECIMAL_POINT_LEADING,
        DECIMAL_POINT,
        DECIMAL_FRACTION,
        DECIMAL_EXPONENT,
        DECIMAL_EXPONENT_SIGN,
        DECIMAL_EXPONENT_INTEGER,
        HEXADECIMAL,
        HEXADECIMAL_INTEGER,
        STRING,
        START,
        BEFORE_PROPERTY_NAME,
        AFTER_PROPERTY_NAME,
        BEFORE_PROPERTY_VALUE,
        AFTER_PROPERTY_VALUE,
        BEFORE_ARRAY_VALUE,
        AFTER_ARRAY_VALUE,
        END;

    }

    private static enum TokenType {
        EOF,
        PUNCTUATOR,
        NULL,
        BOOLEAN,
        NUMERIC,
        STRING,
        IDENTIFIER;

    }
}

