/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.concurrent.ScheduledExecutorService;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.spring.ScheduledLockConfiguration;
import net.javacrumbs.shedlock.spring.ScheduledLockConfigurationBuilder;
import net.javacrumbs.shedlock.spring.SpringLockableTaskSchedulerFactoryBean;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

class DefaultScheduledLockConfigurationBuilder
implements ScheduledLockConfigurationBuilder,
ScheduledLockConfigurationBuilder.ScheduledLockConfigurationBuilderWithoutTaskScheduler,
ScheduledLockConfigurationBuilder.ConfiguredScheduledLockConfigurationBuilder,
ScheduledLockConfigurationBuilder.ScheduledLockConfigurationBuilderWithoutDefaultLockAtMostFor {
    private static final Duration DEFAULT_LOCK_AT_MOST_FOR = Duration.of(1L, ChronoUnit.HOURS);
    private final LockProvider lockProvider;
    private TaskScheduler taskScheduler;
    private TemporalAmount defaultLockAtMostFor = DEFAULT_LOCK_AT_MOST_FOR;
    private TemporalAmount defaultLockAtLeastFor = Duration.ZERO;

    DefaultScheduledLockConfigurationBuilder(LockProvider lockProvider) {
        this.lockProvider = lockProvider;
    }

    @Override
    public ScheduledLockConfigurationBuilder.ScheduledLockConfigurationBuilderWithoutDefaultLockAtMostFor withPoolSize(int poolSize) {
        this.taskScheduler = DefaultScheduledLockConfigurationBuilder.createThreadPoolTaskScheduler(poolSize);
        return this;
    }

    @Override
    public ScheduledLockConfigurationBuilder.ScheduledLockConfigurationBuilderWithoutDefaultLockAtMostFor withExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.taskScheduler = new ConcurrentTaskScheduler(scheduledExecutorService);
        return this;
    }

    @Override
    public ScheduledLockConfigurationBuilder.ScheduledLockConfigurationBuilderWithoutDefaultLockAtMostFor withTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
        return this;
    }

    private static ThreadPoolTaskScheduler createThreadPoolTaskScheduler(int poolSize) {
        ThreadPoolTaskScheduler newTaskScheduler = new ThreadPoolTaskScheduler();
        newTaskScheduler.setPoolSize(poolSize);
        newTaskScheduler.initialize();
        return newTaskScheduler;
    }

    @Override
    public ScheduledLockConfigurationBuilder.ConfiguredScheduledLockConfigurationBuilder withDefaultLockAtMostFor(TemporalAmount defaultLockAtMostFor) {
        this.defaultLockAtMostFor = defaultLockAtMostFor;
        return this;
    }

    @Override
    public ScheduledLockConfigurationBuilder.ConfiguredScheduledLockConfigurationBuilder withDefaultLockAtLeastFor(TemporalAmount defaultLockAtLeastFor) {
        this.defaultLockAtLeastFor = defaultLockAtLeastFor;
        return this;
    }

    @Override
    public ScheduledLockConfiguration build() {
        return new SpringLockableTaskSchedulerFactoryBean(this.taskScheduler, this.lockProvider, this.defaultLockAtMostFor, this.defaultLockAtLeastFor);
    }
}

