/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.vertx.sqlclient;

import io.vertx.sqlclient.DatabaseException;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.templates.SqlTemplate;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.sql.SqlConfiguration;
import net.javacrumbs.shedlock.provider.sql.SqlStatementsSource;
import net.javacrumbs.shedlock.provider.sql.internal.ErrorCodeUtils;
import net.javacrumbs.shedlock.provider.vertx.sqlclient.VertxSqlClientLockProvider;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.LockException;

class VertxSqlClientStorageAccessor
extends AbstractStorageAccessor {
    private static final Pattern NAMED_PARAMETER_PATTERN = Pattern.compile(":[a-zA-Z]+");
    private final SqlClient sqlClient;
    private final SqlStatementsSource sqlStatementsSource;

    VertxSqlClientStorageAccessor(VertxSqlClientLockProvider.Configuration configuration) {
        this.sqlClient = configuration.getSqlClient();
        this.sqlStatementsSource = SqlStatementsSource.create((SqlConfiguration)configuration);
    }

    public boolean insertRecord(LockConfiguration lockConfiguration) {
        String stmt = this.translate(this.sqlStatementsSource().getInsertStatement());
        try {
            int updated = this.executeUpdate(stmt, lockConfiguration);
            return updated > 0;
        }
        catch (Exception e) {
            DatabaseException dbException;
            Throwable cause = VertxSqlClientStorageAccessor.unwrap(e);
            if (cause instanceof DatabaseException && ErrorCodeUtils.isConstraintViolation((String)(dbException = (DatabaseException)cause).getSqlState())) {
                this.logger.debug("Constraint violation, duplicate key error is expected here {}", (Object)e.getMessage());
                return false;
            }
            this.logger.debug("Exception thrown when inserting record", cause);
            throw new LockException("Unexpected exception when locking", cause);
        }
    }

    public boolean updateRecord(LockConfiguration lockConfiguration) {
        String stmt = this.translate(this.sqlStatementsSource().getUpdateStatement());
        try {
            int updated = this.executeUpdate(stmt, lockConfiguration);
            return updated > 0;
        }
        catch (Exception e) {
            this.logger.debug("Unexpected exception when updating lock record", (Throwable)e);
            throw new LockException("Unexpected exception when locking", VertxSqlClientStorageAccessor.unwrap(e));
        }
    }

    public boolean extend(LockConfiguration lockConfiguration) {
        String stmt = this.translate(this.sqlStatementsSource().getExtendStatement());
        this.logger.debug("Extending lock={} until={}", (Object)lockConfiguration.getName(), (Object)lockConfiguration.getLockAtMostUntil());
        try {
            int updated = this.executeUpdate(stmt, lockConfiguration);
            return updated > 0;
        }
        catch (Exception e) {
            throw new LockException("Unexpected exception when unlocking", VertxSqlClientStorageAccessor.unwrap(e));
        }
    }

    public void unlock(LockConfiguration lockConfiguration) {
        String stmt = this.translate(this.sqlStatementsSource().getUnlockStatement());
        try {
            this.executeUpdate(stmt, lockConfiguration);
        }
        catch (Exception e) {
            throw new LockException("Unexpected exception when unlocking", VertxSqlClientStorageAccessor.unwrap(e));
        }
    }

    private String translate(String statement) {
        return NAMED_PARAMETER_PATTERN.matcher(statement).replaceAll(result -> "#{" + result.group().substring(1) + "}");
    }

    private SqlStatementsSource sqlStatementsSource() {
        return this.sqlStatementsSource;
    }

    private int executeUpdate(String sql, LockConfiguration lockConfiguration) throws ExecutionException, InterruptedException, TimeoutException {
        Map<String, Object> params = this.translateParams(this.sqlStatementsSource().params(lockConfiguration));
        RowSet rs = (RowSet)SqlTemplate.forQuery((SqlClient)this.sqlClient, (String)sql).execute(params).toCompletionStage().toCompletableFuture().get(30L, TimeUnit.SECONDS);
        return rs.rowCount();
    }

    private Map<String, Object> translateParams(Map<String, Object> params) {
        return params.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), VertxSqlClientStorageAccessor.translate(entry.getValue()))).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Object translate(Object value) {
        if (value instanceof ZonedDateTime) {
            ZonedDateTime cal = (ZonedDateTime)value;
            return cal.toLocalDateTime();
        }
        return value;
    }

    private static Throwable unwrap(Throwable e) {
        if ((e instanceof CompletionException || e instanceof ExecutionException) && e.getCause() != null) {
            return e.getCause();
        }
        return e;
    }
}

