/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.opensearch.java;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.provider.opensearch.java.DocumentFieldNames;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.BuiltinScriptLanguage;
import org.opensearch.client.opensearch._types.InlineScript;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.Result;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.UpdateResponse;
import org.opensearch.client.transport.httpclient5.ResponseException;

public class OpenSearchLockProvider
implements LockProvider {
    static final String SCHEDLOCK_DEFAULT_INDEX = "shedlock";
    private static final String PARAM_LOCK_UNTIL_FIELD = "lockUntilField";
    private static final String PARAM_LOCKED_AT_FIELD = "lockedAtField";
    private static final String PARAM_LOCKED_BY_FIELD = "lockedByField";
    private static final String PARAM_NOW = "now";
    private static final String PARAM_LOCK_UNTIL = "lockUntil";
    private static final String PARAM_LOCKED_BY = "lockedBy";
    private static final String PARAM_UNLOCK_TIME = "unlockTime";
    private static final String LOCK_SCRIPT = "def v = ctx._source[params.lockUntilField];\nif (!(v instanceof Number)) {\n    throw new IllegalStateException(\"Field '\" + params.lockUntilField + \"' is missing or not a Number. \" +\n        \"Possible field name mismatch - check DocumentFieldNames configuration and ensure data migration was performed.\");\n}\nif (((Number) v).longValue() <= params.now) {\n    ctx._source[params.lockUntilField] = params.lockUntil;\n    ctx._source[params.lockedAtField] = params.now;\n    ctx._source[params.lockedByField] = params.lockedBy;\n} else {\n    ctx.op = 'none';\n}";
    private static final String UNLOCK_SCRIPT = "ctx._source[params.lockUntilField] = params.unlockTime;";
    private final OpenSearchClient openSearchClient;
    private final String hostname;
    private final String index;
    private final DocumentFieldNames fieldNames;

    public OpenSearchLockProvider(Configuration configuration) {
        this.openSearchClient = Objects.requireNonNull(configuration.getClient(), "client cannot be null");
        this.index = Objects.requireNonNull(configuration.getIndex(), "index cannot be null");
        this.fieldNames = Objects.requireNonNull(configuration.getFieldNames(), "fieldNames cannot be null");
        this.hostname = Utils.getHostname();
    }

    public OpenSearchLockProvider(OpenSearchClient openSearchClient) {
        this(openSearchClient, SCHEDLOCK_DEFAULT_INDEX);
    }

    public OpenSearchLockProvider(OpenSearchClient openSearchClient, String index) {
        this(Configuration.builder(openSearchClient).withIndex(index).build());
    }

    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        Instant now = ClockProvider.now();
        UpdateRequest<Object, Object> updateRequest = this.createUpdateRequest(lockConfiguration, now);
        try {
            UpdateResponse updateResponse = this.openSearchClient.update(updateRequest, Object.class);
            return updateResponse.result() == Result.NoOp ? Optional.empty() : Optional.of(new OpenSearchSimpleLock(lockConfiguration));
        }
        catch (IOException | OpenSearchException e) {
            if (OpenSearchLockProvider.isResponseExceptionWithConflictStatus((Exception)e) || OpenSearchLockProvider.isOpenSearchExceptionWithConflictStatus((Exception)e)) {
                return Optional.empty();
            }
            throw new LockException("Unexpected exception while locking", e);
        }
    }

    private static boolean isResponseExceptionWithConflictStatus(Exception e) {
        ResponseException ex;
        return e instanceof ResponseException && (ex = (ResponseException)e).status() == 409;
    }

    private static boolean isOpenSearchExceptionWithConflictStatus(Exception e) {
        OpenSearchException ex;
        return e instanceof OpenSearchException && (ex = (OpenSearchException)((Object)e)).status() == 409;
    }

    private UpdateRequest<Object, Object> createUpdateRequest(LockConfiguration lockConfiguration, Instant now) {
        Map<String, Object> upsertDoc = this.createUpsertDocument(lockConfiguration.getName(), lockConfiguration.getLockAtMostUntil(), now);
        return new UpdateRequest.Builder().index(this.index).script(this.createUpdateScript(lockConfiguration, now)).id(lockConfiguration.getName()).refresh(Refresh.True).upsert(upsertDoc).build();
    }

    private Script createUpdateScript(LockConfiguration lockConfiguration, Instant now) {
        Map<String, JsonData> updateScriptParams = this.createLockParams(lockConfiguration.getLockAtMostUntil(), now);
        InlineScript inlineScript = OpenSearchLockProvider.inlineScript(LOCK_SCRIPT, updateScriptParams);
        return Script.of(scriptBuilder -> scriptBuilder.inline(inlineScript));
    }

    private Map<String, Object> createUpsertDocument(String name, Instant lockUntil, Instant lockedAt) {
        return Map.of(this.fieldNames.name(), name, this.fieldNames.lockedBy(), this.hostname, this.fieldNames.lockedAt(), lockedAt.toEpochMilli(), this.fieldNames.lockUntil(), lockUntil.toEpochMilli());
    }

    private Map<String, JsonData> createLockParams(Instant lockUntil, Instant lockedAt) {
        return Map.of(PARAM_LOCK_UNTIL_FIELD, JsonData.of((Object)this.fieldNames.lockUntil()), PARAM_LOCKED_AT_FIELD, JsonData.of((Object)this.fieldNames.lockedAt()), PARAM_LOCKED_BY_FIELD, JsonData.of((Object)this.fieldNames.lockedBy()), PARAM_NOW, JsonData.of((Object)lockedAt.toEpochMilli()), PARAM_LOCK_UNTIL, JsonData.of((Object)lockUntil.toEpochMilli()), PARAM_LOCKED_BY, JsonData.of((Object)this.hostname));
    }

    private static InlineScript inlineScript(String sc, Map<String, JsonData> params) {
        return InlineScript.of(builder -> ((InlineScript.Builder)builder.source(sc).params(params)).lang(l -> l.builtin(BuiltinScriptLanguage.Painless)));
    }

    public static final class Configuration {
        private final OpenSearchClient client;
        private final String index;
        private final DocumentFieldNames fieldNames;

        Configuration(OpenSearchClient client, String index, DocumentFieldNames fieldNames) {
            this.client = Objects.requireNonNull(client, "client cannot be null");
            this.index = Objects.requireNonNull(index, "index cannot be null");
            this.fieldNames = Objects.requireNonNull(fieldNames, "fieldNames cannot be null");
        }

        public OpenSearchClient getClient() {
            return this.client;
        }

        public String getIndex() {
            return this.index;
        }

        public DocumentFieldNames getFieldNames() {
            return this.fieldNames;
        }

        public static Builder builder(OpenSearchClient client) {
            return new Builder(client);
        }

        public static final class Builder {
            private final OpenSearchClient client;
            private String index = "shedlock";
            private DocumentFieldNames fieldNames = DocumentFieldNames.DEFAULT;

            private Builder(OpenSearchClient client) {
                this.client = client;
            }

            public Builder withIndex(String index) {
                this.index = index;
                return this;
            }

            public Builder withFieldNames(DocumentFieldNames fieldNames) {
                this.fieldNames = fieldNames;
                return this;
            }

            public Configuration build() {
                return new Configuration(Objects.requireNonNull(this.client, "client is required"), this.index, this.fieldNames);
            }
        }
    }

    private final class OpenSearchSimpleLock
    extends AbstractSimpleLock {
        private OpenSearchSimpleLock(LockConfiguration lockConfiguration) {
            super(lockConfiguration);
        }

        public void doUnlock() {
            Map<String, JsonData> unlockParams = Map.of(OpenSearchLockProvider.PARAM_LOCK_UNTIL_FIELD, JsonData.of((Object)OpenSearchLockProvider.this.fieldNames.lockUntil()), OpenSearchLockProvider.PARAM_UNLOCK_TIME, JsonData.of((Object)this.lockConfiguration.getUnlockTime().toEpochMilli()));
            InlineScript inlineScript = OpenSearchLockProvider.inlineScript(OpenSearchLockProvider.UNLOCK_SCRIPT, unlockParams);
            Script script = Script.of(scriptBuilder -> scriptBuilder.inline(inlineScript));
            UpdateRequest unlockUpdateRequest = new UpdateRequest.Builder().index(OpenSearchLockProvider.this.index).script(script).id(this.lockConfiguration.getName()).refresh(Refresh.True).build();
            try {
                OpenSearchLockProvider.this.openSearchClient.update(unlockUpdateRequest, Object.class);
            }
            catch (IOException | OpenSearchException e) {
                throw new LockException("Unexpected exception while unlocking", e);
            }
        }
    }
}

